/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.util.StateUtils;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyKey {
    public static final int CAP_NOT_BOUND = 1;
    public static final int CAP_TRANSIENT = 2;
    public static final int CAP_LIST = 4;
    public static final int CAP_STATE_HOLDER = 8;
    private static final Map<Class<?>, Object> _PRIMITIVE_DEFAULTS = PropertyKey._createPrimitiveDefaults();
    private static final Map<Class<?>, Class<?>> _BOXED_PRIMITIVES = PropertyKey._createBoxedPrimitives();
    private final int _hashCode;
    private final String _name;
    private final int _index;
    private final int _capabilities;
    private final Class<?> _type;
    private final Object _default;
    private final boolean _serializeAsList;
    private FacesBean.Type _owner;
    private static final Class<List> LIST_CLASS = List.class;
    private static final int _CAPS_DEFAULT = 0;
    private static final int _CAPS_ALL = 15;
    private static final Class<Object> _TYPE_DEFAULT = Object.class;
    private static final Object _OBJECT_NULL = new Object();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PropertyKey.class);

    public static PropertyKey createPropertyKey(String name) {
        return new PropertyKey(name);
    }

    PropertyKey(String name) {
        this(name, _TYPE_DEFAULT);
    }

    PropertyKey(String name, Class<?> type) {
        this(name, type, null);
    }

    PropertyKey(String name, Class<?> type, Object defaultValue) {
        this(name, type, defaultValue, 0, -1);
    }

    protected PropertyKey(String name, Class<?> type, Object defaultValue, int capabilities, int index) {
        boolean hasListCapability;
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (defaultValue != null) {
            Class<?> boxedType = PropertyKey._getBoxedType(type);
            if (!boxedType.isAssignableFrom(defaultValue.getClass())) {
                throw new IllegalStateException(_LOG.getMessage("DEFAULT_VALUE_IS_NOT_ASSIGNED_TO_TYPE", new Object[]{defaultValue, type}));
            }
        } else {
            defaultValue = PropertyKey._getJavaDefault(type);
            if (defaultValue == null) {
                defaultValue = _OBJECT_NULL;
            }
        }
        if ((capabilities & 0xFFFFFFF0) != 0) {
            throw new IllegalStateException(_LOG.getMessage("CAPABILITY_MASK_NOT_UNDERSTOOD", capabilities & 0xFFFFFFF0));
        }
        boolean bl = hasListCapability = (capabilities & 4) != 0;
        if (hasListCapability) {
            capabilities |= 1;
        }
        this._name = name;
        this._type = type;
        this._default = defaultValue;
        this._capabilities = capabilities;
        this._index = index;
        this._serializeAsList = hasListCapability || LIST_CLASS.isAssignableFrom(this._type);
        this._hashCode = this._name.hashCode();
    }

    public Class<?> getType() {
        return this._type;
    }

    public Object getDefault() {
        return this._default != _OBJECT_NULL ? this._default : null;
    }

    public FacesBean.Type getOwner() {
        return this._owner;
    }

    public boolean getSupportsBinding() {
        return (this._capabilities & 1) == 0;
    }

    public boolean isTransient() {
        return (this._capabilities & 2) != 0;
    }

    public boolean isList() {
        return (this._capabilities & 4) != 0;
    }

    public String getName() {
        return this._name;
    }

    public int getIndex() {
        return this._index;
    }

    public Object saveValue(FacesContext context, Object value) {
        if ((this._capabilities & 8) != 0) {
            return StateUtils.saveStateHolder(context, value);
        }
        if (this._serializeAsList && value instanceof List) {
            return StateUtils.saveList(context, value);
        }
        if (value != null && !(value instanceof Serializable) && _LOG.isWarning()) {
            _LOG.warning(_LOG.getMessage("UNSERIALIZABLE_PROPERTY_VALUE_NO_CONTAINER", new Object[]{value, this}));
        }
        return value;
    }

    public Object restoreValue(FacesContext context, Object savedValue) {
        if ((this._capabilities & 8) != 0) {
            return StateUtils.restoreStateHolder(context, savedValue);
        }
        if (this._serializeAsList && savedValue instanceof Object[]) {
            return StateUtils.restoreList(context, savedValue);
        }
        return savedValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyKey)) {
            return false;
        }
        PropertyKey that = (PropertyKey)o;
        if (this._owner != that._owner) {
            return false;
        }
        int index = this._index;
        if (index == -1) {
            return that._index == -1 && that._name.equals(this._name) && that._type.equals(this._type) && that._default.equals(this._default);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        String className = this.getClass().getName();
        int lastPeriod = className.lastIndexOf(46);
        if (lastPeriod >= 0) {
            className = className.substring(lastPeriod + 1);
        }
        if (this._index >= 0) {
            return className + "[" + this._name + "," + this._index + "]";
        }
        return className + "[" + this._name + "]";
    }

    void __setOwner(FacesBean.Type owner) {
        this._owner = owner;
    }

    private static Object _getJavaDefault(Class<?> type) {
        return _PRIMITIVE_DEFAULTS.get(type);
    }

    private static Class<?> _getBoxedType(Class<?> type) {
        Class<?> boxedType = _BOXED_PRIMITIVES.get(type);
        return boxedType != null ? boxedType : type;
    }

    private static Map<Class<?>, Object> _createPrimitiveDefaults() {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> map = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        map.put(Boolean.TYPE, Boolean.FALSE);
        map.put(Byte.TYPE, Byte.valueOf((byte)0));
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Double.TYPE, Double.valueOf(0.0));
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Integer.TYPE, Integer.valueOf(0));
        map.put(Long.TYPE, Long.valueOf(0L));
        map.put(Short.TYPE, Short.valueOf((short)0));
        return Collections.unmodifiableMap(map);
    }

    private static Map<Class<?>, Class<?>> _createBoxedPrimitives() {
        HashMap<Class<Comparable<Boolean>>, Class> map = new HashMap<Class<Comparable<Boolean>>, Class>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        return Collections.unmodifiableMap(map);
    }
}

