/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pda;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandLink;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CommandLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class PdaCommandLinkRenderer
extends CommandLinkRenderer {
    public PdaCommandLinkRenderer() {
        super(CoreCommandLink.TYPE);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (PdaCommandLinkRenderer.supportsScripting(rc)) {
            this.encodeBegin(context, rc, component, bean);
            this.encodeAllChildren(context, component);
            this.encodeEnd(context, rc, component, bean);
            return;
        }
        String clientId = this.getClientId(context, component);
        if (this.canSkipRendering(rc, clientId)) {
            return;
        }
        assert (rc.getCurrentClientId() == null);
        rc.setCurrentClientId(clientId);
        ResponseWriter rw = context.getResponseWriter();
        String element = "input";
        rw.startElement(element, component);
        this.renderId(context, component);
        String text = this.getText(component, bean);
        rw.writeAttribute("type", (Object)"submit", null);
        if (this.getDisabled(component, bean)) {
            rw.writeAttribute("disabled", (Object)Boolean.TRUE, "disabled");
            this.renderStyleAttributes(context, rc, component, bean);
        } else {
            this.renderAllAttributes(context, rc, component, bean);
        }
        if (PdaCommandLinkRenderer.supportsAccessKeys(rc)) {
            char accessKey = this.getAccessKey(component, bean);
            if (accessKey != '\uffff') {
                rw.writeAttribute("accesskey", (Object)Character.valueOf(accessKey), "accessKey");
            }
        } else {
            int accessKey = 65535;
        }
        rw.writeAttribute("name", (Object)(XhtmlUtils.getEncodedParameter("source") + clientId), null);
        rw.writeAttribute("id", (Object)clientId, "id");
        rw.writeAttribute("value", (Object)text, "text");
        PdaCommandLinkRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|commandButton");
        String style = this.getInlineStyle(component, bean);
        this._writeInlineStyles(rw, style, "border:none;background:inherit;text-decoration:underline;");
        rw.endElement(element);
        rc.setCurrentClientId(null);
    }

    @Override
    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeURIAttribute("id", (Object)clientId, "id");
            RenderingContext arc = RenderingContext.getCurrentInstance();
            if (PdaCommandLinkRenderer.supportsScripting(arc)) {
                context.getResponseWriter().writeURIAttribute("name", (Object)clientId, "id");
            }
        }
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, String defaultStyleClass) throws IOException {
        if (PdaCommandLinkRenderer.supportsScripting(rc)) {
            super.renderStyleAttributes(context, rc, component, bean, defaultStyleClass);
        }
    }

    private void _writeInlineStyles(ResponseWriter rw, String userInlineStyle, String appendedInlineStyle) throws IOException {
        if (userInlineStyle == null) {
            rw.writeAttribute("style", (Object)appendedInlineStyle, "inlineStyle");
        } else {
            StringBuilder linkInlineStyle = new StringBuilder();
            linkInlineStyle.append(appendedInlineStyle);
            linkInlineStyle.append(userInlineStyle.trim());
            rw.writeAttribute("style", (Object)linkInlineStyle.toString(), "inlineStyle");
        }
    }
}

