/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.InternalView;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidad.util.Enums;
import org.apache.myfaces.trinidadinternal.skin.pregen.SkinPregenerationUtils;
import org.apache.myfaces.trinidadinternal.skin.pregen.config.InvalidConfigException;
import org.apache.myfaces.trinidadinternal.skin.pregen.config.PregenConfig;

public class SkinPregenerationService
extends InternalView {
    private static volatile ServiceStatus _sServiceStatus;
    private static final String _SKIN_ID_REQUEST_PARAM = "id";
    private static final String _SERVICE_PROPERTY = "org.apache.myfaces.trinidad.SKIN_PREGENERATION_SERVICE";
    private static final String _RESPONSE_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private static final String _VIEW_ID = "/-tr-pregenerate-skins";
    private static final TrinidadLogger _LOG;

    public static boolean isEnabled() {
        return SkinPregenerationService._getServiceStatus() == ServiceStatus.ON;
    }

    public static boolean isPregenerationRequest(String viewId) {
        return _VIEW_ID.equals(viewId);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return null;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        return null;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (!SkinPregenerationService.isEnabled()) {
            SkinPregenerationService._sendPregenerationDisabledError(context);
            return;
        }
        long duration = SkinPregenerationService._pregenerateSkin(context);
        if (!context.getResponseComplete()) {
            SkinPregenerationService._renderResponse(context, duration);
        }
    }

    private static long _pregenerateSkin(FacesContext context) {
        long startTime = System.currentTimeMillis();
        try {
            PregenConfig config = PregenConfig.parse(context);
            Skin skin = SkinPregenerationService._parseSkin(context);
            SkinPregenerationUtils.pregenerate(context, skin, config);
        }
        catch (Exception e) {
            SkinPregenerationService._pregenFailed(context, e);
        }
        return System.currentTimeMillis() - startTime;
    }

    private static Skin _parseSkin(FacesContext context) throws InvalidConfigException {
        Skin skin;
        String skinId = SkinPregenerationService._getSkinId(context);
        if (skinId != null && (skin = SkinPregenerationService._getSkin(context, skinId)) != null) {
            return skin;
        }
        String message = _LOG.getMessage("SKIN_PREGEN_REQUESTED_SKIN_INVALID", (Object)skinId);
        throw new InvalidConfigException(message);
    }

    private static String _getSkinId(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        return (String)external.getRequestParameterMap().get(_SKIN_ID_REQUEST_PARAM);
    }

    private static Skin _getSkin(FacesContext context, String skinId) {
        SkinFactory factory = SkinFactory.getFactory();
        return factory.getSkin(context, skinId);
    }

    private static void _pregenFailed(FacesContext context, Exception e) {
        String message = _LOG.getMessage("SKIN_PREGEN_FAILED", (Object)e.getMessage());
        _LOG.severe(message, (Throwable)e);
        SkinPregenerationService._sendError(context, message);
    }

    private static void _sendPregenerationDisabledError(FacesContext context) {
        String message = _LOG.getMessage("SKIN_PREGEN_DISABLED", new Object[]{_SERVICE_PROPERTY, SkinPregenerationService._getServicePropertyValues()});
        SkinPregenerationService._sendError(context, message);
    }

    private static String _getServicePropertyValues() {
        return Enums.patternOf(ServiceStatus.class, (Enums.StringProducer)Enums.displayNameStringProducer(ServiceStatus.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _sendError(FacesContext context, String message) {
        if (context.getResponseComplete()) {
            return;
        }
        ExternalContext external = context.getExternalContext();
        try {
            external.responseSendError(500, message);
        }
        catch (IOException e) {
            _LOG.warning((Throwable)e);
        }
        finally {
            context.responseComplete();
        }
    }

    private static void _renderResponse(FacesContext context, long duration) throws IOException {
        ResponseWriter rw = SkinPregenerationService._getResponseWriter(context);
        rw.startDocument();
        rw.write(_RESPONSE_DOCTYPE);
        rw.startElement("html", null);
        rw.startElement("head", null);
        rw.startElement("title", null);
        rw.writeText((Object)_LOG.getMessage("SKIN_PREGEN_RESPONSE_TITLE"), null);
        rw.endElement("title");
        rw.endElement("head");
        rw.startElement("body", null);
        rw.startElement("p", null);
        String message = _LOG.getMessage("SKIN_PREGEN_RESPONSE", (Object)duration);
        rw.writeText((Object)message, null);
        rw.endElement("p");
        rw.endElement("body");
        rw.endElement("html");
        rw.endDocument();
    }

    private static ResponseWriter _getResponseWriter(FacesContext context) throws IOException {
        ExternalContext external = context.getExternalContext();
        String contentType = "text/html";
        String encoding = "UTF-8";
        external.setResponseContentType(contentType);
        external.setResponseCharacterEncoding(encoding);
        ResponseWriter rw = context.getRenderKit().createResponseWriter(external.getResponseOutputWriter(), contentType, encoding);
        context.setResponseWriter(rw);
        return rw;
    }

    private static ServiceStatus _getServiceStatus() {
        String serviceProperty;
        if (_sServiceStatus == null && (serviceProperty = System.getProperty(_SERVICE_PROPERTY)) != null && serviceProperty.length() > 0) {
            try {
                _sServiceStatus = ServiceStatus.valueOfDisplayName(serviceProperty);
            }
            catch (IllegalArgumentException e) {
                _sServiceStatus = ServiceStatus.OFF;
                _LOG.severe("ILLEGAL_SYSTEM_PROPERTY_VALUE", new Object[]{serviceProperty, _SERVICE_PROPERTY, SkinPregenerationService._getServicePropertyValues()});
            }
        }
        return _sServiceStatus;
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(SkinPregenerationService.class);
    }

    public static enum ServiceStatus {
        ON("on"),
        OFF("off");

        private final String _displayName;
        private static final Map<String, ServiceStatus> _displayNameMap;

        private ServiceStatus(String displayName) {
            this._displayName = displayName;
        }

        public String displayName() {
            return this._displayName;
        }

        public static ServiceStatus valueOfDisplayName(String displayName) {
            return (ServiceStatus)Enums.stringToEnum(_displayNameMap, (String)displayName, ServiceStatus.class);
        }

        static {
            _displayNameMap = Enums.createDisplayNameMap(ServiceStatus.class);
        }
    }
}

