/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.config.ConfigPropertyService;
import org.apache.myfaces.trinidad.config.PropertyValueProvider;
import org.apache.myfaces.trinidad.config.TestPropertyValueProvider;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.config.DefaultValueProvider;
import org.apache.myfaces.trinidadinternal.config.ServletConfigValueProvider;

public final class ConfigPropertyServiceImpl
extends ConfigPropertyService {
    private TestPropertyValueProvider _testProvider = null;
    private final List<PropertyValueProvider> _valueProviders;
    private final Set<PropertyChangeListener> _changeListeners = new CopyOnWriteArraySet<PropertyChangeListener>();
    private static final String _PROPERTY_PROVIDER_URL = "org.apache.myfaces.trinidad.config.PropertyValueProvider";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ConfigPropertyServiceImpl.class);

    private ConfigPropertyServiceImpl(List<PropertyValueProvider> valueProviders) {
        this._valueProviders = new CopyOnWriteArrayList<PropertyValueProvider>(valueProviders);
    }

    public String getProperty(ExternalContext externalContext, String name) {
        PropertyValueProvider provider;
        if (name == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_CONFIG_PROPERTY_NAME"));
        }
        String result = null;
        Iterator<PropertyValueProvider> i$ = this._valueProviders.iterator();
        while (i$.hasNext() && (result = (provider = i$.next()).getValue(externalContext, name)) == null) {
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeListeners.remove(listener);
    }

    protected synchronized TestPropertyValueProvider getTestProvider() {
        if (this._testProvider == null) {
            this._testProvider = new TestPropertyValueProvider();
            this._valueProviders.add(0, (PropertyValueProvider)this._testProvider);
        }
        return this._testProvider;
    }

    protected void notifyValueChange(ExternalContext externalContext, String name, String oldValue) {
        String newValue = this.getProperty(externalContext, name);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
        for (PropertyChangeListener listener : this._changeListeners) {
            listener.propertyChange(event);
        }
    }

    static void initialize(ExternalContext externalContext) {
        ArrayList<PropertyValueProvider> valueProviders = new ArrayList<PropertyValueProvider>(5);
        valueProviders.add(new ServletConfigValueProvider());
        List list = ClassLoaderUtils.getServices((String)_PROPERTY_PROVIDER_URL);
        if (list.size() > 1) {
            throw new RuntimeException(_LOG.getMessage("MULTIPLE_CONFIG_PROPERTY_PROVIDERS_FOUND"));
        }
        if (list.size() == 1) {
            valueProviders.add((PropertyValueProvider)list.get(0));
        }
        valueProviders.add(new DefaultValueProvider());
        ConfigPropertyServiceImpl instance = new ConfigPropertyServiceImpl(valueProviders);
        externalContext.getApplicationMap().put("org.apache.myfaces.trinidad.config.CONFIG_PROPERTY_SERVICE_INSTANCE", instance);
    }
}

