/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class URLUtils {
    private static final String _URL_PARAM_SEPERATOR = "&";
    private static final String _URL_QUERY_SEPERATOR = "?";
    private static final String _URL_FRAGMENT_SEPERATOR = "#";
    private static final String _URL_NAME_VALUE_PAIR_SEPERATOR = "=";
    private static final String _JS_IMMUNE_CHARS = ",._";

    private URLUtils() {
    }

    public static long getLastModified(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String externalForm = url.toExternalForm();
            File file = new File(externalForm.substring(5));
            return file.lastModified();
        }
        return URLUtils.getLastModified(url.openConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URLConnection connection) throws IOException {
        long modified;
        if (connection instanceof JarURLConnection) {
            URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
            URLConnection jarFileConnection = jarFileUrl.openConnection();
            try {
                modified = jarFileConnection.getLastModified();
            }
            finally {
                try {
                    jarFileConnection.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        modified = connection.getLastModified();
        return modified;
    }

    public static String jsEncodeURL(String url, String charset) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(url.length() * 2);
        for (char c : url.toCharArray()) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || _JS_IMMUNE_CHARS.indexOf(c) > -1) {
                sb.append(c);
                continue;
            }
            for (byte b : Character.toString(c).getBytes(charset)) {
                sb.append("\\x").append(String.format("%02X", b));
            }
        }
        return sb.toString();
    }

    public static String encodeURL(String url, Map<String, List<String>> params, String characterResponseEncoding) {
        String fragment = null;
        String queryString = null;
        HashMap<String, List<String>> paramMap = null;
        int index = url.indexOf(_URL_FRAGMENT_SEPERATOR);
        if (index != -1) {
            fragment = url.substring(index + 1);
            url = url.substring(0, index);
        }
        if ((index = url.indexOf(_URL_QUERY_SEPERATOR)) != -1) {
            queryString = url.substring(index + 1);
            url = url.substring(0, index);
            String[] nameValuePairs = queryString.split(_URL_PARAM_SEPERATOR);
            for (int i = 0; i < nameValuePairs.length; ++i) {
                String[] currentPair = nameValuePairs[i].split(_URL_NAME_VALUE_PAIR_SEPERATOR);
                ArrayList<String> value = new ArrayList<String>(1);
                try {
                    value.add(currentPair.length > 1 ? URLDecoder.decode(currentPair[1], characterResponseEncoding) : "");
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException("Encoding type=" + characterResponseEncoding + " not supported", e);
                }
                if (paramMap == null) {
                    paramMap = new HashMap();
                }
                paramMap.put(currentPair[0], value);
            }
        }
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, List<String>> pair : params.entrySet()) {
                if (pair.getKey() == null || pair.getKey().trim().length() == 0) continue;
                if (paramMap == null) {
                    paramMap = new HashMap<String, List<String>>();
                }
                paramMap.put(pair.getKey(), pair.getValue());
            }
        }
        StringBuilder newUrl = new StringBuilder(url);
        if (paramMap != null && paramMap.size() > 0) {
            boolean isFirstPair = true;
            for (Map.Entry pair : paramMap.entrySet()) {
                for (String value : (List)pair.getValue()) {
                    if (!isFirstPair) {
                        newUrl.append(_URL_PARAM_SEPERATOR);
                    } else {
                        newUrl.append(_URL_QUERY_SEPERATOR);
                        isFirstPair = false;
                    }
                    newUrl.append((String)pair.getKey());
                    newUrl.append(_URL_NAME_VALUE_PAIR_SEPERATOR);
                    try {
                        newUrl.append(URLEncoder.encode(value, characterResponseEncoding));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnsupportedOperationException("Encoding type=" + characterResponseEncoding + " not supported", e);
                    }
                }
            }
        }
        if (fragment != null) {
            newUrl.append(_URL_FRAGMENT_SEPERATOR + fragment);
        }
        return newUrl.toString();
    }
}

