"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const package_managers_1 = __importDefault(require("../package-managers"));
/**
 * Resolves the package manager from a string or object. Throws an error if an invalid packageManager is provided.
 *
 * @param packageManagerNameOrObject
 * @param packageManagerNameOrObject.global
 * @param packageManagerNameOrObject.packageManager
 * @returns
 */
function getPackageManager(name) {
    // default to npm
    if (!name || name === 'deno') {
        return package_managers_1.default.npm;
    }
    if (!package_managers_1.default[name]) {
        throw new Error(`Invalid package manager: ${name}`);
    }
    return package_managers_1.default[name];
}
exports.default = getPackageManager;
//# sourceMappingURL=getPackageManager.js.map