/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.zip;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.netbeans.nbpackage.AbstractPackagerTask;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.FileUtils;
import org.apache.netbeans.nbpackage.zip.ZipPackager;

class ZipPackageTask
extends AbstractPackagerTask {
    ZipPackageTask(ExecutionContext context) {
        super(context);
    }

    @Override
    protected void customizeImage(Path image) throws Exception {
    }

    @Override
    protected Path buildPackage(Path image) throws Exception {
        Path dst = this.context().destination().resolve(image.getFileName().toString() + ".zip");
        FileUtils.createZipArchive(image, dst);
        return dst;
    }

    @Override
    protected Path calculateRuntimePath(Path image, Path application) throws Exception {
        if (Files.exists(application.resolve("bin").resolve("netbeans"), new LinkOption[0])) {
            this.context().warningHandler().accept(ZipPackager.MESSAGES.getString("zip.nbruntime.warning"));
        }
        return super.calculateRuntimePath(image, application);
    }
}

