/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.netbeans.nbpackage.ArchiveUtils;

public class FileUtils {
    private FileUtils() {
    }

    public static void copyFiles(final Path src, final Path dst) throws IOException {
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetDir = dst.resolve(src.relativize(dir));
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                        FileUtils.ensureWritable(targetDir);
                    }
                    catch (FileAlreadyExistsException ex) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                        throw ex;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = dst.resolve(src.relativize(file));
                Files.copy(file, targetFile, StandardCopyOption.COPY_ATTRIBUTES);
                FileUtils.ensureWritable(targetFile);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void createZipArchive(Path directory, Path destination) throws IOException {
        if (Files.exists(destination, new LinkOption[0])) {
            throw new IOException(destination.toString());
        }
        try {
            ArchiveUtils.createArchive(ArchiveUtils.ArchiveType.ZIP, directory, destination);
        }
        catch (ArchiveException ex) {
            throw new IOException(ex);
        }
    }

    public static void extractArchive(Path archive, Path destination) throws IOException {
        if (!Files.isDirectory(destination, new LinkOption[0])) {
            throw new IOException(destination.toString());
        }
        try {
            ArchiveUtils.extractArchive(archive, destination);
        }
        catch (ArchiveException | CompressorException ex) {
            throw new IOException(ex);
        }
    }

    public static void moveFiles(final Path src, final Path dst) throws IOException {
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block3: {
                    if (dir.equals(src)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path targetDir = dst.resolve(src.relativize(dir));
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                        FileUtils.ensureWritable(targetDir);
                    }
                    catch (FileAlreadyExistsException ex) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block3;
                        throw ex;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = dst.resolve(src.relativize(file));
                Files.move(file, targetFile, new CopyOption[0]);
                FileUtils.ensureWritable(targetFile);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (dir.equals(src)) {
                    return FileVisitResult.CONTINUE;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteFiles(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static List<Path> find(Path searchDir, String pattern) throws IOException {
        PathMatcher matcher = searchDir.getFileSystem().getPathMatcher("glob:" + pattern);
        try (Stream<Path> stream = Files.find(searchDir, Integer.MAX_VALUE, (file, attr) -> !file.equals(searchDir) && (matcher.matches(searchDir.relativize((Path)file)) || matcher.matches(file.getFileName())), new FileVisitOption[0]);){
            List<Path> list = stream.toList();
            return list;
        }
    }

    public static List<Path> findDirs(Path searchDir, int searchDepth, String ... patterns) throws IOException {
        List<PathMatcher> matchers = Stream.of(patterns).map(p -> FileSystems.getDefault().getPathMatcher("glob:" + p)).toList();
        int intDepth = Stream.of(patterns).map(p -> p.split("/")).mapToInt(ps -> ((String[])ps).length).max().orElse(1);
        try (Stream<Path> stream = Files.find(searchDir, searchDepth, (intPath, attr) -> matchers.stream().map(m -> {
            Boolean bl;
            block8: {
                Stream<Path> files = Files.walk(intPath, intDepth, new FileVisitOption[0]);
                try {
                    bl = files.map(file -> intPath.relativize((Path)file)).anyMatch(m::matches);
                    if (files == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
                files.close();
            }
            return bl;
        }).allMatch(v -> v), new FileVisitOption[0]);){
            List<Path> list = stream.toList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean processJarContents(Path jarFile, String pattern, JarProcessor processor) throws IOException {
        URI jarURI = URI.create("jar:" + String.valueOf(jarFile.toUri()));
        boolean updated = false;
        try (FileSystem jarFS = FileSystems.newFileSystem(jarURI, Map.of());){
            List<Path> filesToProcess;
            PathMatcher matcher = jarFS.getPathMatcher("glob:" + pattern);
            try (Stream<Path> jarStream = Files.walk(jarFS.getPath("/", new String[0]), new FileVisitOption[0]);){
                filesToProcess = jarStream.filter(file -> Files.isRegularFile(file, new LinkOption[0])).filter(matcher::matches).toList();
            }
            if (filesToProcess.isEmpty()) {
                boolean jarStream = false;
                return jarStream;
            }
            Path tmpDir = Files.createTempDirectory("nbpackage-jar-", new FileAttribute[0]);
            try {
                for (Path file2 : filesToProcess) {
                    Path tmp;
                    block21: {
                        tmp = null;
                        try {
                            tmp = Files.copy(file2, tmpDir.resolve(file2.getFileName().toString()), new CopyOption[0]);
                            boolean processed = processor.processFile(tmp, file2.toString());
                            if (!processed) break block21;
                            Files.copy(tmp, file2, StandardCopyOption.REPLACE_EXISTING);
                            updated = true;
                        }
                        catch (Throwable throwable) {
                            Files.deleteIfExists(tmp);
                            throw throwable;
                            return updated;
                        }
                    }
                    Files.deleteIfExists(tmp);
                }
            }
            finally {
                Files.delete(tmpDir);
            }
        }
    }

    public static String removeExtension(String filename) {
        int lastDot = filename.lastIndexOf(".");
        if (lastDot > 0) {
            return filename.substring(0, lastDot);
        }
        return filename;
    }

    static void ensureWritable(Path path) throws IOException {
        if (Files.isWritable(path) || Files.isSymbolicLink(path)) {
            return;
        }
        PosixFileAttributeView posix = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (posix != null) {
            Set<PosixFilePermission> perms = posix.readAttributes().permissions();
            perms.add(PosixFilePermission.OWNER_WRITE);
            posix.setPermissions(perms);
            return;
        }
        DosFileAttributeView dos = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
        if (dos != null) {
            dos.setReadOnly(false);
        }
    }

    @FunctionalInterface
    public static interface JarProcessor {
        public boolean processFile(Path var1, String var2) throws IOException;
    }
}

