/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.metrics.Counter;
import io.questdb.metrics.MetricsRegistry;

public class TableWriterMetrics {
    private final Counter commitCounter;
    private final Counter committedRowCounter;
    private final Counter o3CommitCounter;
    private final Counter physicallyWrittenRowCounter;
    private final Counter rollbackCounter;

    public TableWriterMetrics(MetricsRegistry metricsRegistry) {
        this.commitCounter = metricsRegistry.newCounter("commits");
        this.o3CommitCounter = metricsRegistry.newCounter("o3_commits");
        this.committedRowCounter = metricsRegistry.newCounter("committed_rows");
        this.rollbackCounter = metricsRegistry.newCounter("rollbacks");
        this.physicallyWrittenRowCounter = metricsRegistry.newCounter("physically_written_rows");
    }

    public void addCommittedRows(long rows) {
        this.committedRowCounter.add(rows);
    }

    public void addPhysicallyWrittenRows(long rows) {
        this.physicallyWrittenRowCounter.add(rows);
    }

    public long getCommitCount() {
        return this.commitCounter.getValue();
    }

    public long getCommittedRows() {
        return this.committedRowCounter.getValue();
    }

    public long getO3CommitCount() {
        return this.o3CommitCounter.getValue();
    }

    public long getPhysicallyWrittenRows() {
        return this.physicallyWrittenRowCounter.getValue();
    }

    public long getRollbackCount() {
        return this.rollbackCounter.getValue();
    }

    public void incrementCommits() {
        this.commitCounter.inc();
    }

    public void incrementO3Commits() {
        this.o3CommitCounter.inc();
    }

    public void incrementRollbacks() {
        this.rollbackCounter.inc();
    }
}

