/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.text.AbstractTextLexer;
import io.questdb.cutlass.text.CairoTextWriter;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.TextDelimiterScanner;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextLexerWrapper;
import io.questdb.cutlass.text.TextMetadataDetector;
import io.questdb.cutlass.text.TextMetadataParser;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TextLoader
implements Closeable,
Mutable {
    public static final int ANALYZE_STRUCTURE = 1;
    public static final int LOAD_DATA = 2;
    public static final int LOAD_JSON_METADATA = 0;
    private static final Log LOG = LogFactory.getLog(TextLoader.class);
    private final JsonLexer jsonLexer;
    private final ObjList<ParserMethod> parseMethods = new ObjList();
    private final Path path = new Path();
    private final int textAnalysisMaxLines;
    private final TextConfiguration textConfiguration;
    private final TextDelimiterScanner textDelimiterScanner;
    private final TextMetadataDetector textMetadataDetector;
    private final TextMetadataParser textMetadataParser;
    private final CairoTextWriter textWriter;
    private final TextLexerWrapper tlw;
    private final TypeManager typeManager;
    private final DirectCharSink utf8Sink;
    private byte columnDelimiter = (byte)-1;
    private boolean forceHeaders = false;
    private AbstractTextLexer lexer;
    private boolean skipLinesWithExtraValues = true;
    private int state;
    private CharSequence tableName;
    private TimestampAdapter timestampAdapter;
    private CharSequence timestampColumn;

    public TextLoader(CairoEngine engine) {
        this.tlw = new TextLexerWrapper(engine.getConfiguration().getTextConfiguration());
        this.textWriter = new CairoTextWriter(engine);
        this.textConfiguration = engine.getConfiguration().getTextConfiguration();
        this.utf8Sink = new DirectCharSink(this.textConfiguration.getUtf8SinkSize());
        this.typeManager = new TypeManager(this.textConfiguration, this.utf8Sink);
        this.jsonLexer = new JsonLexer(this.textConfiguration.getJsonCacheSize(), this.textConfiguration.getJsonCacheLimit());
        this.textMetadataDetector = new TextMetadataDetector(this.typeManager, this.textConfiguration);
        this.textMetadataParser = new TextMetadataParser(this.textConfiguration, this.typeManager);
        this.textAnalysisMaxLines = this.textConfiguration.getTextAnalysisMaxLines();
        this.textDelimiterScanner = new TextDelimiterScanner(this.textConfiguration);
        this.parseMethods.extendAndSet(0, this::parseJsonMetadata);
        this.parseMethods.extendAndSet(1, this::parseStructure);
        this.parseMethods.extendAndSet(2, this::parseData);
    }

    @Override
    public void clear() {
        this.textWriter.clear();
        if (this.lexer != null) {
            this.lexer.clear();
            this.lexer = null;
        }
        this.textMetadataParser.clear();
        this.textMetadataDetector.clear();
        this.jsonLexer.clear();
        this.forceHeaders = false;
        this.columnDelimiter = (byte)-1;
        this.typeManager.clear();
        this.timestampAdapter = null;
        this.skipLinesWithExtraValues = true;
        this.tableName = null;
    }

    @Override
    public void close() {
        Misc.free(this.textWriter);
        Misc.free(this.tlw);
        Misc.free(this.textMetadataDetector);
        Misc.free(this.textMetadataParser);
        Misc.free(this.jsonLexer);
        Misc.free(this.path);
        Misc.free(this.textDelimiterScanner);
        Misc.free(this.utf8Sink);
    }

    public void closeWriter() {
        this.textWriter.closeWriter();
    }

    public void configureColumnDelimiter(byte columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
        assert (this.columnDelimiter > 0);
    }

    public void configureDestination(CharSequence tableName, boolean overwrite, boolean durable, int atomicity, int partitionBy, CharSequence timestampColumn, CharSequence timestampFormat) {
        this.configureDestination(tableName, overwrite, durable, atomicity, partitionBy, timestampColumn);
        this.textDelimiterScanner.setTableName(tableName);
        this.textMetadataParser.setTableName(tableName);
        this.timestampColumn = timestampColumn;
        if (timestampFormat != null) {
            DateFormat dateFormat = this.typeManager.getInputFormatConfiguration().getTimestampFormatFactory().get(timestampFormat);
            this.timestampAdapter = (TimestampAdapter)this.typeManager.nextTimestampAdapter(false, dateFormat, this.textConfiguration.getDefaultDateLocale());
        }
        LOG.info().$("configured [table=`").$(tableName).$("`, overwrite=").$(overwrite).$(", durable=").$(durable).$(", atomicity=").$(atomicity).$(", partitionBy=").$(PartitionBy.toString(partitionBy)).$(", timestamp=").$(timestampColumn).$(", timestampFormat=").$(timestampFormat).$(']').$();
    }

    public void configureDestination(CharSequence tableName, boolean overwrite, boolean durable, int atomicity, int partitionBy, CharSequence timestampColumn) {
        this.textWriter.of(tableName, overwrite, durable, atomicity, partitionBy, timestampColumn);
        this.tableName = tableName;
    }

    public byte getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public LongList getColumnErrorCounts() {
        return this.textWriter.getColumnErrorCounts();
    }

    public long getErrorLineCount() {
        return this.lexer != null ? this.lexer.getErrorCount() : 0L;
    }

    public RecordMetadata getMetadata() {
        return this.textWriter.getMetadata();
    }

    public long getParsedLineCount() {
        return this.lexer != null ? this.lexer.getLineCount() : 0L;
    }

    public int getPartitionBy() {
        return this.textWriter.getPartitionBy();
    }

    public CharSequence getTableName() {
        return this.textWriter.getTableName();
    }

    public CharSequence getTimestampCol() {
        return this.textWriter.getTimestampCol();
    }

    public int getWarnings() {
        return this.textWriter.getWarnings();
    }

    public long getWrittenLineCount() {
        return this.textWriter.getWrittenLineCount();
    }

    public boolean isForceHeaders() {
        return this.forceHeaders;
    }

    public void parse(long lo, long hi, int lineCountLimit, AbstractTextLexer.Listener textLexerListener) {
        this.lexer.parse(lo, hi, lineCountLimit, textLexerListener);
    }

    public void parse(long lo, long hi, int lineCountLimit) {
        this.lexer.parse(lo, hi, lineCountLimit, this.textWriter.getTextListener());
    }

    public void parse(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        this.parseMethods.getQuick(this.state).parse(lo, hi, cairoSecurityContext);
    }

    public void prepareTable(CairoSecurityContext ctx, ObjList<CharSequence> names, ObjList<TypeAdapter> types, Path path, TypeManager typeManager, TimestampAdapter timestampAdapter) throws TextException {
        this.textWriter.prepareTable(ctx, names, types, path, typeManager, timestampAdapter);
    }

    public final void restart(boolean header) {
        this.lexer.restart(header);
    }

    public void setDelimiter(byte delimiter) {
        this.lexer = this.tlw.getLexer(delimiter);
        this.lexer.setTableName(this.tableName);
        this.lexer.setSkipLinesWithExtraValues(this.skipLinesWithExtraValues);
    }

    public void setForceHeaders(boolean forceHeaders) {
        this.forceHeaders = forceHeaders;
    }

    public void setMaxUncommittedRows(int maxUncommittedRows) {
        this.textWriter.setMaxUncommittedRows(maxUncommittedRows);
    }

    public void setO3MaxLag(long o3MaxLagUs) {
        this.textWriter.setO3MaxLag(o3MaxLagUs);
    }

    public void setSkipLinesWithExtraValues(boolean skipLinesWithExtraValues) {
        this.skipLinesWithExtraValues = skipLinesWithExtraValues;
    }

    public void setState(int state) {
        LOG.debug().$("state change [old=").$(this.state).$(", new=").$(state).$(']').$();
        this.state = state;
        this.jsonLexer.clear();
    }

    public void wrapUp() throws TextException {
        switch (this.state) {
            case 0: {
                try {
                    this.jsonLexer.parseLast();
                    break;
                }
                catch (JsonException e) {
                    throw TextException.$(e.getFlyweightMessage());
                }
            }
            case 1: 
            case 2: {
                if (this.lexer != null) {
                    this.lexer.parseLast();
                }
                this.textWriter.commit();
                break;
            }
        }
    }

    private void parseData(long lo, long hi, CairoSecurityContext cairoSecurityContext) {
        this.parse(lo, hi, Integer.MAX_VALUE);
    }

    private void parseJsonMetadata(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        try {
            this.jsonLexer.parse(lo, hi, this.textMetadataParser);
        }
        catch (JsonException e) {
            throw TextException.$(e.getFlyweightMessage());
        }
    }

    private void parseStructure(long lo, long hi, CairoSecurityContext cairoSecurityContext) throws TextException {
        if (this.columnDelimiter > 0) {
            this.setDelimiter(this.columnDelimiter);
        } else {
            this.setDelimiter(this.textDelimiterScanner.scan(lo, hi));
        }
        if (this.timestampColumn != null && this.timestampAdapter != null) {
            this.textMetadataParser.getColumnNames().add(this.timestampColumn);
            this.textMetadataParser.getColumnTypes().add(this.timestampAdapter);
        }
        this.textMetadataDetector.of(this.getTableName(), this.textMetadataParser.getColumnNames(), this.textMetadataParser.getColumnTypes(), this.forceHeaders);
        this.parse(lo, hi, this.textAnalysisMaxLines, this.textMetadataDetector);
        this.textMetadataDetector.evaluateResults(this.getParsedLineCount(), this.getErrorLineCount());
        this.restart(this.textMetadataDetector.isHeader());
        this.prepareTable(cairoSecurityContext, this.textMetadataDetector.getColumnNames(), this.textMetadataDetector.getColumnTypes(), this.path, this.typeManager, this.timestampAdapter);
        this.parse(lo, hi, Integer.MAX_VALUE);
        this.state = 2;
    }

    @FunctionalInterface
    protected static interface ParserMethod {
        public void parse(long var1, long var3, CairoSecurityContext var5) throws TextException;
    }
}

