/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.std.Mutable;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.str.DirectByteCharSequence;

public class TimestampAdapter
extends AbstractTypeAdapter
implements Mutable {
    protected DateFormat format;
    protected DateLocale locale;

    @Override
    public void clear() {
        this.format = null;
        this.locale = null;
    }

    public long getTimestamp(DirectByteCharSequence value) throws Exception {
        return this.format.parse(value, this.locale);
    }

    @Override
    public int getType() {
        return 8;
    }

    public TimestampAdapter of(DateFormat format, DateLocale locale) {
        this.format = format;
        this.locale = locale;
        return this;
    }

    @Override
    public boolean probe(DirectByteCharSequence text) {
        try {
            this.format.parse(text, this.locale);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        row.putDate(column, this.format.parse(value, this.locale));
    }
}

