/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Uuid;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public final class CastUuidToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Zs)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function func = args.getQuick(0);
        if (func.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            if (SqlUtil.implicitCastUuidAsStr(func.getLong128Lo(null), func.getLong128Hi(null), sink)) {
                return new StrConstant(Chars.toString(sink));
            }
            return StrConstant.NULL;
        }
        return new Func(func);
    }

    public static class Func
    extends AbstractCastToStrFunction
    implements UnaryFunction {
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStr(Record rec) {
            this.sinkA.clear();
            return SqlUtil.implicitCastUuidAsStr(this.arg.getLong128Lo(rec), this.arg.getLong128Hi(rec), this.sinkA) ? this.sinkA : null;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            SqlUtil.implicitCastUuidAsStr(this.arg.getLong128Lo(rec), this.arg.getLong128Hi(rec), sink);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.sinkB.clear();
            return SqlUtil.implicitCastUuidAsStr(this.arg.getLong128Lo(rec), this.arg.getLong128Hi(rec), this.sinkB) ? this.sinkB : null;
        }

        @Override
        public int getStrLen(Record rec) {
            long hi;
            long lo = this.arg.getLong128Lo(rec);
            return Uuid.isNull(lo, hi = this.arg.getLong128Hi(rec)) ? -1 : 36;
        }
    }
}

