/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlNavigationProperty;
import org.apache.olingo.client.core.edm.xml.ClientCsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;

@JsonDeserialize(using=ComplexTypeDeserializer.class)
class ClientCsdlComplexType
extends CsdlComplexType
implements Serializable {
    private static final long serialVersionUID = 4076944306925840115L;

    ClientCsdlComplexType() {
    }

    static class ComplexTypeDeserializer
    extends AbstractClientCsdlEdmDeserializer<CsdlComplexType> {
        ComplexTypeDeserializer() {
        }

        @Override
        protected CsdlComplexType doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlComplexType complexType = new ClientCsdlComplexType();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        complexType.setName(jp.nextTextValue());
                    } else if ("Abstract".equals(jp.getCurrentName())) {
                        complexType.setAbstract(BooleanUtils.toBoolean(jp.nextTextValue()));
                    } else if ("BaseType".equals(jp.getCurrentName())) {
                        complexType.setBaseType(jp.nextTextValue());
                    } else if ("OpenType".equals(jp.getCurrentName())) {
                        complexType.setOpenType(BooleanUtils.toBoolean(jp.nextTextValue()));
                    } else if ("Property".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        complexType.getProperties().add(jp.readValueAs(ClientCsdlProperty.class));
                    } else if ("NavigationProperty".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        complexType.getNavigationProperties().add(jp.readValueAs(ClientCsdlNavigationProperty.class));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        complexType.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return complexType;
        }
    }
}

