/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;

@JsonDeserialize(using=ReturnTypeDeserializer.class)
class ClientCsdlReturnType
extends CsdlReturnType
implements Serializable {
    private static final long serialVersionUID = 6261092793901735110L;

    ClientCsdlReturnType() {
    }

    static class ReturnTypeDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlReturnType> {
        ReturnTypeDeserializer() {
        }

        @Override
        protected ClientCsdlReturnType doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlReturnType returnType = new ClientCsdlReturnType();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Type".equals(jp.getCurrentName())) {
                        String metadataTypeName = jp.nextTextValue();
                        if (metadataTypeName.startsWith("Collection(")) {
                            returnType.setType(metadataTypeName.substring(metadataTypeName.indexOf("(") + 1, metadataTypeName.length() - 1));
                            returnType.setCollection(true);
                        } else {
                            returnType.setType(metadataTypeName);
                            returnType.setCollection(false);
                        }
                    } else if ("Nullable".equals(jp.getCurrentName())) {
                        returnType.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("MaxLength".equals(jp.getCurrentName())) {
                        String maxLenght = jp.nextTextValue();
                        returnType.setMaxLength("max".equalsIgnoreCase(maxLenght) ? Integer.MAX_VALUE : Integer.valueOf(maxLenght));
                    } else if ("Precision".equals(jp.getCurrentName())) {
                        returnType.setPrecision(Integer.valueOf(jp.nextTextValue()));
                    } else if ("Scale".equals(jp.getCurrentName())) {
                        String scale = jp.nextTextValue();
                        returnType.setScale("variable".equalsIgnoreCase(scale) || "floating".equalsIgnoreCase(scale) ? 0 : Integer.valueOf(scale));
                    } else if ("SRID".equals(jp.getCurrentName())) {
                        String srid = jp.nextTextValue();
                        if (srid != null) {
                            returnType.setSrid(SRID.valueOf((String)srid));
                        }
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        returnType.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return returnType;
        }
    }
}

