/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.context.AttachedEntity;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.EntityUUID;

public class EntityContext
implements Iterable<AttachedEntity> {
    private final Map<EntityUUID, EntityInvocationHandler> searchableEntities = new HashMap<EntityUUID, EntityInvocationHandler>();
    private final Map<EntityInvocationHandler, AttachedEntityStatus> allAttachedEntities = new LinkedHashMap<EntityInvocationHandler, AttachedEntityStatus>();
    private final List<URI> furtherDeletes = new ArrayList<URI>();

    public void attachNew(EntityInvocationHandler entity) {
        if (this.allAttachedEntities.containsKey(entity)) {
            throw new IllegalStateException("An entity with the same key has already been attached");
        }
        this.allAttachedEntities.put(entity, AttachedEntityStatus.NEW);
    }

    public void attach(EntityInvocationHandler entity) {
        this.attach(entity, AttachedEntityStatus.ATTACHED);
    }

    public void attach(EntityInvocationHandler entity, AttachedEntityStatus status) {
        this.attach(entity, status, false);
    }

    public void attach(EntityInvocationHandler entity, AttachedEntityStatus status, boolean force) {
        if (this.isAttached(entity)) {
            throw new IllegalStateException("An entity with the same profile has already been attached");
        }
        if (force || entity.getUUID().getEntitySetURI() != null) {
            this.allAttachedEntities.put(entity, status);
            if (entity.getUUID().getKey() != null) {
                this.searchableEntities.put(entity.getUUID(), entity);
            }
        }
    }

    public void detach(EntityInvocationHandler entity) {
        this.searchableEntities.remove(entity.getUUID());
        this.allAttachedEntities.remove(entity);
    }

    public void detachAll() {
        this.allAttachedEntities.clear();
        this.searchableEntities.clear();
        this.furtherDeletes.clear();
    }

    public EntityInvocationHandler getEntity(EntityUUID uuid) {
        return this.searchableEntities.get(uuid);
    }

    public AttachedEntityStatus getStatus(EntityInvocationHandler entity) {
        if (!this.isAttached(entity)) {
            throw new IllegalStateException("Entity is not in the context");
        }
        return this.allAttachedEntities.get(entity);
    }

    public void setStatus(EntityInvocationHandler entity, AttachedEntityStatus status) {
        if (!this.isAttached(entity)) {
            throw new IllegalStateException("Entity is not in the context");
        }
        AttachedEntityStatus current = this.allAttachedEntities.get(entity);
        if (current == AttachedEntityStatus.DELETED) {
            throw new IllegalStateException("Entity has been previously deleted");
        }
        if (status == AttachedEntityStatus.NEW || status == AttachedEntityStatus.ATTACHED) {
            throw new IllegalStateException("Entity status has already been initialized");
        }
        if (status == AttachedEntityStatus.LINKED && current == AttachedEntityStatus.ATTACHED || status == AttachedEntityStatus.CHANGED && current == AttachedEntityStatus.ATTACHED || status == AttachedEntityStatus.CHANGED && current == AttachedEntityStatus.LINKED || status == AttachedEntityStatus.DELETED) {
            this.allAttachedEntities.put(entity, status);
        }
    }

    public boolean isAttached(EntityInvocationHandler entity) {
        return entity == null || this.allAttachedEntities.containsKey(entity) || entity.getUUID().getKey() != null && this.searchableEntities.containsKey(entity.getUUID());
    }

    @Override
    public Iterator<AttachedEntity> iterator() {
        ArrayList<AttachedEntity> res = new ArrayList<AttachedEntity>();
        for (Map.Entry<EntityInvocationHandler, AttachedEntityStatus> entity : this.allAttachedEntities.entrySet()) {
            res.add(new AttachedEntity(entity.getKey(), entity.getValue()));
        }
        return res.iterator();
    }

    public List<URI> getFurtherDeletes() {
        return this.furtherDeletes;
    }

    public void addFurtherDeletes(URI uri) {
        this.furtherDeletes.add(uri);
    }
}

