/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;

public abstract class JavaMathOneArgumentFunction
extends ScalarFunction {
    public JavaMathOneArgumentFunction() {
    }

    public JavaMathOneArgumentFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    protected abstract double compute(double var1);

    static double getArg(Expression exp, ImmutableBytesWritable ptr) {
        if (exp.getDataType() == PDecimal.INSTANCE) {
            return ((BigDecimal)exp.getDataType().toObject(ptr, exp.getSortOrder())).doubleValue();
        }
        return exp.getDataType().getCodec().decodeDouble(ptr, exp.getSortOrder());
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        PDataType returnType = this.getDataType();
        Expression arg1Expr = (Expression)this.children.get(0);
        if (!arg1Expr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        double arg1 = JavaMathOneArgumentFunction.getArg(arg1Expr, ptr);
        ptr.set(new byte[returnType.getByteSize().intValue()]);
        returnType.getCodec().encodeDouble(this.compute(arg1), ptr);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDouble.INSTANCE;
    }
}

