/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;

public abstract class NumberSumAggregator
extends BaseAggregator {
    private long sum = 0L;
    private byte[] buffer;

    public NumberSumAggregator(SortOrder sortOrder) {
        super(sortOrder);
    }

    public NumberSumAggregator(SortOrder sortOrder, ImmutableBytesWritable ptr) {
        this(sortOrder);
        if (ptr != null) {
            this.initBuffer();
            this.sum = PLong.INSTANCE.getCodec().decodeLong(ptr, sortOrder);
        }
    }

    public long getSum() {
        return this.sum;
    }

    protected abstract PDataType getInputDataType();

    private int getBufferLength() {
        return this.getDataType().getByteSize();
    }

    private void initBuffer() {
        this.buffer = new byte[this.getBufferLength()];
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        long value = this.getInputDataType().getCodec().decodeLong(ptr, this.sortOrder);
        this.sum += value;
        if (this.buffer == null) {
            this.initBuffer();
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.buffer == null) {
            if (this.isNullable()) {
                return false;
            }
            this.initBuffer();
        }
        this.getDataType().getCodec().encodeLong(this.sum, this.buffer, 0);
        ptr.set(this.buffer);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PLong.INSTANCE;
    }

    @Override
    public void reset() {
        this.sum = 0L;
        this.buffer = null;
        super.reset();
    }

    public String toString() {
        return "SUM [sum=" + this.sum + "]";
    }

    @Override
    public int getSize() {
        return super.getSize() + 8 + 24 + this.getBufferLength();
    }
}

