/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase.txprune;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.tephra.hbase.txprune.DataJanitorState;
import org.apache.tephra.hbase.txprune.TimeRegions;
import org.apache.tephra.txprune.RegionPruneInfo;
import org.apache.tephra.txprune.hbase.InvalidListPruningDebug;
import org.apache.tephra.txprune.hbase.RegionsAtTime;
import org.apache.tephra.util.TimeMathParser;
import org.apache.tephra.util.TxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidListPruningDebugTool
implements InvalidListPruningDebug {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidListPruningDebugTool.class);
    private static final Gson GSON = new Gson();
    private static final String NOW = "now";
    @VisibleForTesting
    static final String DATE_FORMAT = "d-MMM-yyyy HH:mm:ss z";
    private DataJanitorState dataJanitorState;
    private Connection connection;
    private TableName tableName;

    @Override
    public void initialize(Configuration conf) throws IOException {
        LOG.debug("InvalidListPruningDebugMain : initialize method called");
        this.connection = ConnectionFactory.createConnection((Configuration)conf);
        this.tableName = TableName.valueOf((String)conf.get("data.tx.prune.state.table", "tephra.state"));
        this.dataJanitorState = new DataJanitorState(new DataJanitorState.TableSupplier(){

            @Override
            public Table get() throws IOException {
                return InvalidListPruningDebugTool.this.connection.getTable(InvalidListPruningDebugTool.this.tableName);
            }
        });
    }

    @Override
    public void destroy() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public Set<String> getRegionsToBeCompacted(Integer numRegions, String time) throws IOException {
        RegionsAtTime timeRegion = this.getRegionsOnOrBeforeTime(time);
        if (timeRegion.getRegions().isEmpty()) {
            return Collections.emptySet();
        }
        Long timestamp = timeRegion.getTime();
        TreeSet regions = timeRegion.getRegions();
        SortedSet<String> liveRegions = this.getRegionsOnOrBeforeTime(NOW).getRegions();
        regions = Sets.newTreeSet((Iterable)Sets.intersection(liveRegions, regions));
        SortedSet<byte[]> emptyRegions = this.dataJanitorState.getEmptyRegionsAfterTime(timestamp, null);
        TreeSet<String> emptyRegionNames = new TreeSet<String>();
        Iterable regionStrings = Iterables.transform(emptyRegions, TimeRegions.BYTE_ARR_TO_STRING_FN);
        for (String regionString : regionStrings) {
            emptyRegionNames.add(regionString);
        }
        HashSet nonEmptyRegions = Sets.newHashSet((Iterable)Sets.difference((Set)regions, emptyRegionNames));
        List<RegionPruneInfo> prunedRegions = this.dataJanitorState.getPruneInfoForRegions(null);
        for (RegionPruneInfo prunedRegion : prunedRegions) {
            if (!nonEmptyRegions.contains(prunedRegion.getRegionNameAsString())) continue;
            nonEmptyRegions.remove(prunedRegion.getRegionNameAsString());
        }
        if (numRegions < 0 || numRegions >= nonEmptyRegions.size()) {
            return nonEmptyRegions;
        }
        HashSet<String> subsetRegions = new HashSet<String>(numRegions);
        for (String regionName : nonEmptyRegions) {
            if (subsetRegions.size() == numRegions.intValue()) break;
            subsetRegions.add(regionName);
        }
        return subsetRegions;
    }

    public SortedSet<RegionPruneInfoPretty> getIdleRegions(Integer numRegions, String time) throws IOException {
        List<RegionPruneInfo> regionPruneInfos = this.dataJanitorState.getPruneInfoForRegions(null);
        if (regionPruneInfos.isEmpty()) {
            return new TreeSet<RegionPruneInfoPretty>();
        }
        HashSet<String> pruneRegionNameSet = new HashSet<String>();
        for (RegionPruneInfo regionPruneInfo : regionPruneInfos) {
            pruneRegionNameSet.add(regionPruneInfo.getRegionNameAsString());
        }
        RegionsAtTime latestRegions = this.getRegionsOnOrBeforeTime(NOW);
        RegionsAtTime timeRegions = this.getRegionsOnOrBeforeTime(time);
        Sets.SetView liveRegions = Sets.intersection(latestRegions.getRegions(), timeRegions.getRegions());
        Sets.SetView liveRegionsWithPruneInfo = Sets.intersection((Set)liveRegions, pruneRegionNameSet);
        ArrayList<RegionPruneInfo> liveRegionWithPruneInfoList = new ArrayList<RegionPruneInfo>();
        for (RegionPruneInfo regionPruneInfo : regionPruneInfos) {
            if (liveRegionsWithPruneInfo.contains(regionPruneInfo.getRegionNameAsString())) {
                liveRegionWithPruneInfoList.add(regionPruneInfo);
            }
            regionPruneInfos = liveRegionWithPruneInfoList;
        }
        if (numRegions < 0) {
            numRegions = regionPruneInfos.size();
        }
        Comparator<RegionPruneInfo> comparator = new Comparator<RegionPruneInfo>(){

            @Override
            public int compare(RegionPruneInfo o1, RegionPruneInfo o2) {
                int result = Long.compare(o1.getPruneUpperBound(), o2.getPruneUpperBound());
                if (result == 0) {
                    return o1.getRegionNameAsString().compareTo(o2.getRegionNameAsString());
                }
                return result;
            }
        };
        MinMaxPriorityQueue lowestPrunes = MinMaxPriorityQueue.orderedBy((Comparator)comparator).maximumSize(numRegions.intValue()).create();
        for (RegionPruneInfo pruneInfo : regionPruneInfos) {
            lowestPrunes.add((Object)new RegionPruneInfoPretty(pruneInfo));
        }
        TreeSet<RegionPruneInfo> regions = new TreeSet<RegionPruneInfo>(comparator);
        regions.addAll((Collection<RegionPruneInfo>)lowestPrunes);
        return regions;
    }

    @Override
    @Nullable
    public RegionPruneInfoPretty getRegionPruneInfo(String regionId) throws IOException {
        RegionPruneInfo pruneInfo = this.dataJanitorState.getPruneInfoForRegion(Bytes.toBytesBinary((String)regionId));
        return pruneInfo == null ? null : new RegionPruneInfoPretty(pruneInfo);
    }

    @Override
    public RegionsAtTime getRegionsOnOrBeforeTime(String timeString) throws IOException {
        long time = TimeMathParser.parseTime(timeString, TimeUnit.MILLISECONDS);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        TimeRegions timeRegions = this.dataJanitorState.getRegionsOnOrBeforeTime(time);
        if (timeRegions == null) {
            return new RegionsAtTime(time, new TreeSet<String>(), dateFormat);
        }
        TreeSet<String> regionNames = new TreeSet<String>();
        Iterable regionStrings = Iterables.transform(timeRegions.getRegions(), TimeRegions.BYTE_ARR_TO_STRING_FN);
        for (String regionString : regionStrings) {
            regionNames.add(regionString);
        }
        return new RegionsAtTime(timeRegions.getTime(), regionNames, dateFormat);
    }

    private void printUsage(PrintWriter pw) {
        pw.println();
        pw.println("Usage : org.apache.tephra.hbase.txprune.InvalidListPruning <command> <parameters>");
        pw.println();
        pw.println("Available commands");
        pw.println("------------------");
        pw.println("to-compact-regions limit [time]");
        pw.println("Desc: Prints out the regions that are active, but not empty, and have not registered a prune upper bound.");
        pw.println();
        pw.println("idle-regions limit [time]");
        pw.println("Desc: Prints out the regions that have the lowest prune upper bounds.");
        pw.println();
        pw.println("prune-info region-name-as-string");
        pw.println("Desc: Prints the prune upper bound and the time it was recorded for the given region.");
        pw.println();
        pw.println("time-region [time]");
        pw.println("Desc: Prints out the transactional regions present in HBase recorded at or before the given time.");
        pw.println();
        pw.println("Parameters");
        pw.println("----------");
        pw.println(" * limit - used to limit the number of regions returned, -1 to apply no limit");
        pw.println(" * time  - if time is not provided, the current time is used. ");
        pw.println("             When provided, the data recorded on or before the given time is returned.");
        pw.println("             Time can be provided in milliseconds, or can be provided as a relative time.");
        pw.println("             Examples for relative time -");
        pw.println("             now = current time,");
        pw.println("             now-1d = current time - 1 day,");
        pw.println("             now-1d+4h = 20 hours before now,");
        pw.println("             now+5s = current time + 5 seconds");
        pw.println();
    }

    @VisibleForTesting
    boolean execute(String[] args, PrintWriter out) throws IOException {
        String command;
        if (args.length < 1) {
            this.printUsage(out);
            return false;
        }
        switch (command = args[0]) {
            case "time-region": {
                if (args.length > 2) break;
                String time = args.length == 2 ? args[1] : NOW;
                RegionsAtTime timeRegion = this.getRegionsOnOrBeforeTime(time);
                out.println(GSON.toJson(timeRegion));
                return true;
            }
            case "idle-regions": {
                if (args.length > 3) break;
                Integer numRegions = Integer.parseInt(args[1]);
                String time = args.length == 3 ? args[2] : NOW;
                SortedSet<RegionPruneInfoPretty> regionPruneInfos = this.getIdleRegions(numRegions, time);
                out.println(GSON.toJson(regionPruneInfos));
                return true;
            }
            case "prune-info": {
                if (args.length != 2) break;
                String regionName = args[1];
                RegionPruneInfoPretty regionPruneInfo = this.getRegionPruneInfo(regionName);
                if (regionPruneInfo != null) {
                    out.println(GSON.toJson(regionPruneInfo));
                } else {
                    out.println(String.format("No prune info found for the region %s.", regionName));
                }
                return true;
            }
            case "to-compact-regions": {
                if (args.length > 3) break;
                Integer numRegions = Integer.parseInt(args[1]);
                String time = args.length == 3 ? args[2] : NOW;
                Set<String> toBeCompactedRegions = this.getRegionsToBeCompacted(numRegions, time);
                out.println(GSON.toJson(toBeCompactedRegions));
                return true;
            }
        }
        this.printUsage(out);
        return false;
    }

    public static void main(String[] args) {
        Configuration hConf = HBaseConfiguration.create();
        InvalidListPruningDebugTool pruningDebug = new InvalidListPruningDebugTool();
        try (PrintWriter out = new PrintWriter(System.out);){
            pruningDebug.initialize(hConf);
            boolean success = pruningDebug.execute(args, out);
            pruningDebug.destroy();
            if (!success) {
                System.exit(1);
            }
        }
        catch (IOException ex) {
            LOG.error("Received an exception while trying to execute the debug tool. ", (Throwable)ex);
        }
    }

    public static class RegionPruneInfoPretty
    extends RegionPruneInfo {
        private final transient SimpleDateFormat dateFormat = new SimpleDateFormat("d-MMM-yyyy HH:mm:ss z");
        private final String pruneUpperBoundAsString;
        private final String pruneRecordTimeAsString;

        public RegionPruneInfoPretty(RegionPruneInfo regionPruneInfo) {
            this(regionPruneInfo.getRegionName(), regionPruneInfo.getRegionNameAsString(), regionPruneInfo.getPruneUpperBound(), regionPruneInfo.getPruneRecordTime());
        }

        public RegionPruneInfoPretty(byte[] regionName, String regionNameAsString, long pruneUpperBound, long pruneRecordTime) {
            super(regionName, regionNameAsString, pruneUpperBound, pruneRecordTime);
            this.pruneUpperBoundAsString = this.dateFormat.format(TxUtils.getTimestamp(pruneUpperBound));
            this.pruneRecordTimeAsString = this.dateFormat.format(pruneRecordTime);
        }

        public String getPruneUpperBoundAsString() {
            return this.pruneUpperBoundAsString;
        }

        public String getPruneRecordTimeAsString() {
            return this.pruneRecordTimeAsString;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegionPruneInfoPretty that = (RegionPruneInfoPretty)o;
            return Objects.equals(this.pruneUpperBoundAsString, that.pruneUpperBoundAsString) && Objects.equals(this.pruneRecordTimeAsString, that.pruneRecordTimeAsString);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.pruneUpperBoundAsString, this.pruneRecordTimeAsString);
        }

        @Override
        public String toString() {
            return "RegionPruneInfoPretty{, pruneUpperBoundAsString='" + this.pruneUpperBoundAsString + '\'' + ", pruneRecordTimeAsString='" + this.pruneRecordTimeAsString + '\'' + "} " + super.toString();
        }
    }
}

