/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.GlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRepairRegionScanner
extends GlobalIndexRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexRepairRegionScanner.class);

    public IndexRepairRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver) throws IOException {
        super(innerScanner, region, scan, env, ungroupedAggregateRegionObserver);
        byte[] dataTableName = scan.getAttribute("_PhysicalDataTableName");
        this.dataHTable = this.hTableFactory.getTable(new ImmutableBytesPtr(dataTableName));
        this.indexTableTTL = region.getTableDesc().getColumnFamilies()[0].getTimeToLive();
        try (HConnection connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(env.getConfiguration());){
            this.regionEndKeys = connection.getRegionLocator(this.dataHTable.getName()).getEndKeys();
        }
    }

    @Override
    public byte[] getDataTableName() {
        return this.dataHTable.getName().toBytes();
    }

    public void prepareExpectedIndexMutations(Result dataRow, Map<byte[], List<Mutation>> expectedIndexMutationMap) throws IOException {
        Put put = null;
        Delete del = null;
        for (Cell cell : dataRow.rawCells()) {
            if (KeyValue.Type.codeToType((byte)cell.getTypeByte()) == KeyValue.Type.Put) {
                if (put == null) {
                    put = new Put(CellUtil.cloneRow((Cell)cell));
                }
                put.add(cell);
                continue;
            }
            if (del == null) {
                del = new Delete(CellUtil.cloneRow((Cell)cell));
            }
            del.addDeleteMarker(cell);
        }
        List<Mutation> indexMutations = IndexRepairRegionScanner.prepareIndexMutationsForRebuild(this.indexMaintainer, put, del);
        Collections.reverse(indexMutations);
        for (Mutation mutation : indexMutations) {
            byte[] indexRowKey = mutation.getRow();
            List<Mutation> mutationList = expectedIndexMutationMap.get(indexRowKey);
            if (mutationList == null) {
                mutationList = new ArrayList<Mutation>();
                mutationList.add(mutation);
                expectedIndexMutationMap.put(indexRowKey, mutationList);
                continue;
            }
            mutationList.add(mutation);
        }
    }

    @Override
    protected void commitBatch(List<Mutation> indexUpdates) throws IOException, InterruptedException {
        this.ungroupedAggregateRegionObserver.checkForRegionClosing();
        this.region.batchMutate(indexUpdates.toArray(new Mutation[indexUpdates.size()]), 0L, 0L);
    }

    protected void repairIndexRows(Map<byte[], List<Mutation>> indexMutationMap, List<Mutation> indexRowsToBeDeleted, IndexToolVerificationResult verificationResult) throws IOException {
        this.updateIndexRows(indexMutationMap, indexRowsToBeDeleted, verificationResult);
    }

    private Map<byte[], List<Mutation>> populateExpectedIndexMutationMap(Set<byte[]> dataRowKeys) throws IOException {
        TreeMap expectedIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        ArrayList<KeyRange> keys = new ArrayList<KeyRange>(dataRowKeys.size());
        for (byte[] indexKey : dataRowKeys) {
            keys.add(PVarbinary.INSTANCE.getKeyRange(indexKey));
        }
        ScanRanges scanRanges = ScanRanges.createPointLookup(keys);
        Scan dataScan = new Scan();
        dataScan.setTimeRange(this.scan.getTimeRange().getMin(), this.scan.getTimeRange().getMax());
        scanRanges.initializeScan(dataScan);
        SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
        dataScan.setFilter((Filter)new SkipScanFilter(skipScanFilter, true));
        dataScan.setRaw(true);
        dataScan.setMaxVersions();
        dataScan.setCacheBlocks(false);
        try (ResultScanner resultScanner = this.dataHTable.getScanner(dataScan);){
            Result result = resultScanner.next();
            while (result != null) {
                this.ungroupedAggregateRegionObserver.checkForRegionClosing();
                this.prepareExpectedIndexMutations(result, expectedIndexMutationMap);
                result = resultScanner.next();
            }
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(this.dataHTable.getName().toString(), t);
        }
        return expectedIndexMutationMap;
    }

    private Map<byte[], List<Mutation>> populateActualIndexMutationMap(Map<byte[], List<Mutation>> expectedIndexMutationMap) throws IOException {
        TreeMap actualIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        Scan indexScan = this.prepareIndexScan(expectedIndexMutationMap);
        try (RegionScanner regionScanner = this.region.getScanner(indexScan);){
            do {
                this.ungroupedAggregateRegionObserver.checkForRegionClosing();
                ArrayList<Cell> row = new ArrayList<Cell>();
                this.hasMore = regionScanner.nextRaw(row);
                if (row.isEmpty()) continue;
                this.populateIndexMutationFromIndexRow(row, actualIndexMutationMap);
            } while (this.hasMore);
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(this.region.getRegionInfo().getRegionNameAsString(), t);
        }
        return actualIndexMutationMap;
    }

    private Map<byte[], List<Mutation>> populateActualIndexMutationMap() throws IOException {
        TreeMap actualIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        Scan indexScan = new Scan();
        indexScan.setTimeRange(this.scan.getTimeRange().getMin(), this.scan.getTimeRange().getMax());
        indexScan.setRaw(true);
        indexScan.setMaxVersions();
        indexScan.setCacheBlocks(false);
        try (RegionScanner regionScanner = this.region.getScanner(indexScan);){
            do {
                this.ungroupedAggregateRegionObserver.checkForRegionClosing();
                ArrayList<Cell> row = new ArrayList<Cell>();
                this.hasMore = regionScanner.nextRaw(row);
                if (row.isEmpty()) continue;
                this.populateIndexMutationFromIndexRow(row, actualIndexMutationMap);
            } while (this.hasMore);
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(this.region.getRegionInfo().getRegionNameAsString(), t);
        }
        return actualIndexMutationMap;
    }

    private void repairAndOrVerifyIndexRows(Set<byte[]> dataRowKeys, Map<byte[], List<Mutation>> actualIndexMutationMap, IndexToolVerificationResult verificationResult) throws IOException {
        ArrayList<Mutation> indexRowsToBeDeleted = new ArrayList<Mutation>();
        Map<byte[], List<Mutation>> expectedIndexMutationMap = this.populateExpectedIndexMutationMap(dataRowKeys);
        if (this.verifyType == IndexTool.IndexVerifyType.NONE) {
            this.repairIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.ONLY) {
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, indexRowsToBeDeleted, verificationResult.getBefore(), true);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.BEFORE) {
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, indexRowsToBeDeleted, verificationResult.getBefore(), true);
            if (!expectedIndexMutationMap.isEmpty() || !indexRowsToBeDeleted.isEmpty()) {
                this.repairIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            }
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.AFTER) {
            this.repairIndexRows(expectedIndexMutationMap, Collections.EMPTY_LIST, verificationResult);
            actualIndexMutationMap = this.populateActualIndexMutationMap();
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, indexRowsToBeDeleted, verificationResult.getAfter(), false);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.BOTH) {
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, indexRowsToBeDeleted, verificationResult.getBefore(), true);
            if (!expectedIndexMutationMap.isEmpty() || !indexRowsToBeDeleted.isEmpty()) {
                this.repairIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            }
            if (!expectedIndexMutationMap.isEmpty()) {
                actualIndexMutationMap = this.populateActualIndexMutationMap(expectedIndexMutationMap);
                this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, Collections.EMPTY_LIST, verificationResult.getAfter(), false);
            }
        }
    }

    private void addRepairAndOrVerifyTask(TaskBatch<Boolean> tasks, final Set<byte[]> dataRowKeys, final Map<byte[], List<Mutation>> actualIndexMutationMap, final IndexToolVerificationResult verificationResult) {
        tasks.add(new Task<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (Thread.currentThread().isInterrupted() || IndexRepairRegionScanner.this.env.getRegionServerServices().isAborted() || IndexRepairRegionScanner.this.env.getRegionServerServices().isStopped()) {
                    IndexRepairRegionScanner.this.exceptionMessage = "Pool closed, not attempting to rebuild and/or verify index rows! " + IndexRepairRegionScanner.this.indexHTable.getName();
                    throw new IOException(IndexRepairRegionScanner.this.exceptionMessage);
                }
                IndexRepairRegionScanner.this.repairAndOrVerifyIndexRows(dataRowKeys, actualIndexMutationMap, verificationResult);
                return Boolean.TRUE;
            }
        });
    }

    public static List<Set<byte[]>> getPerTaskDataRowKeys(TreeSet<byte[]> dataRowKeys, byte[][] endKeys, int maxSetSize) {
        int regionIndex;
        ArrayList<Set<byte[]>> setList = new ArrayList<Set<byte[]>>();
        int regionCount = endKeys.length;
        byte[] indexKey = dataRowKeys.first();
        TreeSet<byte[]> perTaskDataRowKeys = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        setList.add(perTaskDataRowKeys);
        for (regionIndex = 0; regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0; ++regionIndex) {
        }
        for (byte[] dataRowKey : dataRowKeys) {
            if (perTaskDataRowKeys.size() == maxSetSize || regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0) {
                perTaskDataRowKeys = new TreeSet(Bytes.BYTES_COMPARATOR);
                setList.add(perTaskDataRowKeys);
                while (regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0) {
                    ++regionIndex;
                }
            }
            perTaskDataRowKeys.add(dataRowKey);
        }
        return setList;
    }

    private Set<byte[]> getDataRowKeys(Map<byte[], List<Mutation>> indexMutationMap) {
        TreeSet<byte[]> dataRowKeys = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (byte[] indexRowKey : indexMutationMap.keySet()) {
            byte[] dataRowKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexRowKey), this.viewConstants);
            dataRowKeys.add(dataRowKey);
        }
        return dataRowKeys;
    }

    private void verifyAndOrRepairIndex(Map<byte[], List<Mutation>> actualIndexMutationMap) throws IOException {
        if (actualIndexMutationMap.size() == 0) {
            return;
        }
        Set<byte[]> dataRowKeys = this.getDataRowKeys(actualIndexMutationMap);
        List<Set<byte[]>> setList = IndexRepairRegionScanner.getPerTaskDataRowKeys((TreeSet)dataRowKeys, this.regionEndKeys, this.rowCountPerTask);
        int taskCount = setList.size();
        TaskBatch<Boolean> tasks = new TaskBatch<Boolean>(taskCount);
        ArrayList<IndexToolVerificationResult> verificationResultList = new ArrayList<IndexToolVerificationResult>(taskCount);
        for (int i = 0; i < taskCount; ++i) {
            IndexToolVerificationResult perTaskVerificationResult = new IndexToolVerificationResult(this.scan);
            verificationResultList.add(perTaskVerificationResult);
            this.addRepairAndOrVerifyTask(tasks, setList.get(i), actualIndexMutationMap, perTaskVerificationResult);
        }
        this.submitTasks(tasks);
        if (this.verify) {
            for (IndexToolVerificationResult result : verificationResultList) {
                this.verificationResult.add(result);
            }
        }
    }

    private int populateIndexMutationFromIndexRow(List<Cell> row, Map<byte[], List<Mutation>> indexMutationMap) throws IOException {
        byte[] indexRowKey;
        Put put = null;
        Delete del = null;
        for (Cell cell : row) {
            if (KeyValue.Type.codeToType((byte)cell.getTypeByte()) == KeyValue.Type.Put) {
                if (put == null) {
                    put = new Put(CellUtil.cloneRow((Cell)cell));
                }
                put.add(cell);
                continue;
            }
            if (del == null) {
                del = new Delete(CellUtil.cloneRow((Cell)cell));
            }
            del.addDeleteMarker(cell);
        }
        if (put != null) {
            indexRowKey = put.getRow();
        } else if (del != null) {
            indexRowKey = del.getRow();
        } else {
            return 0;
        }
        List<Mutation> mutationList = IndexRepairRegionScanner.getMutationsWithSameTS(put, del, MUTATION_TS_DESC_COMPARATOR);
        indexMutationMap.put(indexRowKey, mutationList);
        return mutationList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(List<Cell> results) throws IOException {
        TreeMap indexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        Cell lastCell = null;
        int rowCount = 0;
        int indexMutationCount = 0;
        this.region.startRegionOperation();
        RegionScanner localScanner = null;
        try {
            localScanner = this.getLocalScanner();
            if (localScanner == null) {
                boolean bl = false;
                return bl;
            }
            RegionScanner regionScanner = localScanner;
            synchronized (regionScanner) {
                block17: {
                    if (this.shouldVerify()) break block17;
                    this.skipped = true;
                    boolean bl = false;
                    return bl;
                }
                do {
                    this.ungroupedAggregateRegionObserver.checkForRegionClosing();
                    ArrayList<Cell> row = new ArrayList<Cell>();
                    this.hasMore = localScanner.nextRaw(row);
                    if (row.isEmpty()) continue;
                    lastCell = (Cell)row.get(0);
                    if (ScanUtil.isDummy(row)) break;
                    indexMutationCount += this.populateIndexMutationFromIndexRow(row, indexMutationMap);
                    ++rowCount;
                } while (this.hasMore && (long)indexMutationCount < this.pageSizeInRows);
                if (!indexMutationMap.isEmpty()) {
                    this.verifyAndOrRepairIndex(indexMutationMap);
                }
                if (this.verify) {
                    this.verificationResult.setScannedDataRowCount(this.verificationResult.getScannedDataRowCount() + (long)rowCount);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception in IndexRepairRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
            throw e;
        }
        finally {
            this.region.closeRegionOperation();
            if (localScanner != null && localScanner != this.innerScanner) {
                localScanner.close();
            }
        }
        if (this.minTimestamp != 0L) {
            this.nextStartKey = ByteUtil.calculateTheClosestNextRowKeyForPrefix(lastCell.getRow());
        }
        byte[] rowCountBytes = PLong.INSTANCE.toBytes(rowCount);
        KeyValue aggKeyValue = lastCell == null ? KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length) : KeyValueUtil.newKeyValue(CellUtil.cloneRow((Cell)lastCell), QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, rowCountBytes, 0, rowCountBytes.length);
        results.add((Cell)aggKeyValue);
        return this.hasMore || this.hasMoreIncr;
    }
}

