/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;

public class SchemaNotFoundException
extends MetaDataEntityNotFoundException {
    private static final long serialVersionUID = 1L;
    private static SQLExceptionCode code = SQLExceptionCode.SCHEMA_NOT_FOUND;
    private final long timestamp;

    public SchemaNotFoundException(SchemaNotFoundException e, long timestamp) {
        this(e.getSchemaName(), timestamp);
    }

    public SchemaNotFoundException(String schemaName) {
        this(schemaName, Long.MAX_VALUE);
    }

    public SchemaNotFoundException(String schemaName, long timestamp) {
        super(new SQLExceptionInfo.Builder(code).setSchemaName(schemaName).build().toString(), code.getSQLState(), code.getErrorCode(), schemaName, null, null);
        this.timestamp = timestamp;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }
}

