/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.IOException;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.stats.DefaultStatisticsCollector;
import org.apache.phoenix.schema.stats.NoOpStatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.stats.StatisticsWriter;
import org.apache.phoenix.util.SchemaUtil;

public class StatisticsCollectorFactory {
    public static StatisticsCollector createStatisticsCollector(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp, byte[] guidepostWidthBytes, byte[] guidepostsPerRegionBytes) throws IOException {
        return StatisticsCollectorFactory.createStatisticsCollector(env, tableName, clientTimeStamp, null, guidepostWidthBytes, guidepostsPerRegionBytes);
    }

    public static StatisticsCollector createStatisticsCollector(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp, byte[] storeName) throws IOException {
        return StatisticsCollectorFactory.createStatisticsCollector(env, tableName, clientTimeStamp, storeName, null, null);
    }

    public static StatisticsCollector createStatisticsCollector(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp, byte[] storeName, byte[] guidepostWidthBytes, byte[] guidepostsPerRegionBytes) throws IOException {
        if (StatisticsCollectorFactory.statisticsEnabled(env)) {
            StatisticsWriter statsWriter = StatisticsWriter.newWriter(env, tableName, clientTimeStamp);
            HTableInterface table = env.getTable(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, env.getConfiguration()));
            return new DefaultStatisticsCollector(env.getConfiguration(), env.getRegion(), tableName, storeName, guidepostWidthBytes, guidepostsPerRegionBytes, statsWriter, (Table)table);
        }
        return new NoOpStatisticsCollector();
    }

    private static boolean statisticsEnabled(RegionCoprocessorEnvironment env) {
        return env.getConfiguration().getBoolean("phoenix.stats.collection.enabled", true) && StatisticsUtil.isStatsEnabled(env.getRegionInfo().getTable());
    }
}

