/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import org.apache.twill.internal.JvmOptions;

public class JvmOptionsCodec
implements JsonSerializer<JvmOptions>,
JsonDeserializer<JvmOptions> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)JvmOptions.class), new JvmOptionsCodec()).registerTypeAdapter((Type)((Object)JvmOptions.DebugOptions.class), new DebugOptionsCodec()).create();

    public static void encode(JvmOptions jvmOptions, OutputSupplier<? extends Writer> writerSupplier) throws IOException {
        try (Writer writer = (Writer)writerSupplier.getOutput();){
            GSON.toJson((Object)jvmOptions, (Appendable)writer);
        }
    }

    public static JvmOptions decode(InputSupplier<? extends Reader> readerSupplier) throws IOException {
        try (Reader reader = (Reader)readerSupplier.getInput();){
            JvmOptions jvmOptions = GSON.fromJson(reader, JvmOptions.class);
            return jvmOptions;
        }
    }

    @Override
    public JvmOptions deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        String extraOptions = (String)context.deserialize(jsonObj.get("extraOptions"), (Type)((Object)String.class));
        JvmOptions.DebugOptions debugOptions = (JvmOptions.DebugOptions)context.deserialize(jsonObj.get("debugOptions"), (Type)((Object)JvmOptions.DebugOptions.class));
        return new JvmOptions(extraOptions, debugOptions);
    }

    @Override
    public JsonElement serialize(JvmOptions jvmOptions, Type type, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.add("extraOptions", context.serialize(jvmOptions.getExtraOptions()));
        json.add("debugOptions", context.serialize(jvmOptions.getDebugOptions()));
        return json;
    }

    private static class DebugOptionsCodec
    implements JsonSerializer<JvmOptions.DebugOptions>,
    JsonDeserializer<JvmOptions.DebugOptions> {
        private DebugOptionsCodec() {
        }

        @Override
        public JvmOptions.DebugOptions deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            Boolean doDebug = (Boolean)context.deserialize(jsonObj.get("doDebug"), (Type)((Object)Boolean.class));
            if (!doDebug.booleanValue()) {
                return JvmOptions.DebugOptions.NO_DEBUG;
            }
            Boolean doSuspend = (Boolean)context.deserialize(jsonObj.get("doSuspend"), (Type)((Object)Boolean.class));
            Set runnables = (Set)context.deserialize(jsonObj.get("runnables"), new TypeToken<Set<String>>(){}.getType());
            return new JvmOptions.DebugOptions(true, doSuspend, (Iterable<String>)(runnables == null ? null : ImmutableSet.copyOf((Collection)runnables)));
        }

        @Override
        public JsonElement serialize(JvmOptions.DebugOptions src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.add("doDebug", context.serialize(src.doDebug()));
            json.add("doSuspend", context.serialize(src.doSuspend()));
            if (src.getRunnables() != null) {
                json.add("runnables", context.serialize(src.getRunnables()));
            }
            return json;
        }
    }
}

