/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.CreateSchemaStatement;
import org.apache.phoenix.schema.MetaDataClient;

public class CreateSchemaCompiler {
    private final PhoenixStatement statement;

    public CreateSchemaCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    public MutationPlan compile(CreateSchemaStatement create) throws SQLException {
        PhoenixConnection connection = this.statement.getConnection();
        StatementContext context = new StatementContext(this.statement);
        MetaDataClient client = new MetaDataClient(connection);
        return new CreateSchemaMutationPlan(context, create, client, connection);
    }

    private static class CreateSchemaMutationPlan
    extends BaseMutationPlan {
        private final StatementContext context;
        private final CreateSchemaStatement create;
        private final MetaDataClient client;
        private final PhoenixConnection connection;

        private CreateSchemaMutationPlan(StatementContext context, CreateSchemaStatement create, MetaDataClient client, PhoenixConnection connection) {
            super(context, create.getOperation());
            this.context = context;
            this.create = create;
            this.client = client;
            this.connection = connection;
        }

        @Override
        public MutationState execute() throws SQLException {
            try {
                MutationState mutationState = this.client.createSchema(this.create);
                return mutationState;
            }
            finally {
                if (this.client.getConnection() != this.connection) {
                    this.client.getConnection().close();
                }
            }
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            return new ExplainPlan(Collections.singletonList("CREATE SCHEMA"));
        }

        @Override
        public StatementContext getContext() {
            return this.context;
        }
    }
}

