/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import java.io.IOException;
import org.apache.phoenix.transaction.OmidTransactionProvider;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TephraTransactionProvider;

public class TransactionFactory {
    public static PhoenixTransactionProvider getTransactionProvider(Provider provider) {
        return provider.getTransactionProvider();
    }

    public static PhoenixTransactionProvider getTransactionProvider(byte[] txState, int clientVersion) {
        if (txState == null || txState.length == 0) {
            return null;
        }
        Provider provider = (long)clientVersion < 28L ? Provider.TEPHRA : Provider.fromCode(txState[txState.length - 1]);
        return provider.getTransactionProvider();
    }

    public static PhoenixTransactionContext getTransactionContext(byte[] txState, int clientVersion) throws IOException {
        PhoenixTransactionProvider provider = TransactionFactory.getTransactionProvider(txState, clientVersion);
        if (provider == null) {
            return null;
        }
        return provider.getTransactionContext(txState);
    }

    public static enum Provider {
        TEPHRA(1, TephraTransactionProvider.getInstance(), true),
        OMID(2, OmidTransactionProvider.getInstance(), true);

        private final byte code;
        private final PhoenixTransactionProvider provider;
        private final boolean runTests;

        private Provider(byte code, PhoenixTransactionProvider provider, boolean runTests) {
            this.code = code;
            this.provider = provider;
            this.runTests = runTests;
        }

        public byte getCode() {
            return this.code;
        }

        public static Provider fromCode(int code) {
            if (code < 1 || code > Provider.values().length) {
                throw new IllegalArgumentException("Invalid TransactionFactory.Provider " + code);
            }
            return Provider.values()[code - 1];
        }

        public static Provider getDefault() {
            return OMID;
        }

        public PhoenixTransactionProvider getTransactionProvider() {
            return this.provider;
        }

        public boolean runTests() {
            return this.runTests;
        }
    }
}

