/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server.customizers;

import java.io.File;
import java.util.Arrays;
import org.apache.calcite.avatica.server.ServerCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostedClientJarsServerCustomizer
implements ServerCustomizer<Server> {
    private static final Logger LOG = LoggerFactory.getLogger(HostedClientJarsServerCustomizer.class);
    private final File repoRoot;
    private final String contextPath;

    public HostedClientJarsServerCustomizer(File localMavenRepoRoot, String contextPath) {
        this.repoRoot = localMavenRepoRoot;
        this.contextPath = contextPath;
    }

    @Override
    public void customize(Server server) {
        Object[] handlers = server.getHandlers();
        if (handlers.length != 1) {
            LOG.warn("Observed handlers on server {}", (Object)Arrays.toString(handlers));
            throw new IllegalStateException("Expected to find one handler");
        }
        HandlerList list = (HandlerList)handlers[0];
        ContextHandler ctx = new ContextHandler(this.contextPath);
        ResourceHandler resource = new ResourceHandler();
        resource.setDirAllowed(true);
        resource.setDirectoriesListed(false);
        resource.setResourceBase(this.repoRoot.getAbsolutePath());
        ctx.setHandler(resource);
        Handler[] realHandlers = list.getChildHandlers();
        Handler[] newHandlers = new Handler[realHandlers.length + 1];
        newHandlers[0] = ctx;
        System.arraycopy(realHandlers, 0, newHandlers, 1, realHandlers.length);
        server.setHandler(new HandlerList(newHandlers));
    }
}

