/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetHostAddress is the corresponding interface of BACnetHostAddress
type BACnetHostAddress interface {
	BACnetHostAddressContract
	BACnetHostAddressRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetHostAddress is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetHostAddress()
	// CreateBuilder creates a BACnetHostAddressBuilder
	CreateBACnetHostAddressBuilder() BACnetHostAddressBuilder
}

// BACnetHostAddressContract provides a set of functions which can be overwritten by a sub struct
type BACnetHostAddressContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// IsBACnetHostAddress is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetHostAddress()
	// CreateBuilder creates a BACnetHostAddressBuilder
	CreateBACnetHostAddressBuilder() BACnetHostAddressBuilder
}

// BACnetHostAddressRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetHostAddressRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetHostAddress is the data-structure of this message
type _BACnetHostAddress struct {
	_SubType interface {
		BACnetHostAddressContract
		BACnetHostAddressRequirements
	}
	PeekedTagHeader BACnetTagHeader
}

var _ BACnetHostAddressContract = (*_BACnetHostAddress)(nil)

// NewBACnetHostAddress factory function for _BACnetHostAddress
func NewBACnetHostAddress(peekedTagHeader BACnetTagHeader) *_BACnetHostAddress {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetHostAddress must not be nil")
	}
	return &_BACnetHostAddress{PeekedTagHeader: peekedTagHeader}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetHostAddressBuilder is a builder for BACnetHostAddress
type BACnetHostAddressBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetHostAddressBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetHostAddressBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetHostAddressBuilder
	// AsBACnetHostAddressNull converts this build to a subType of BACnetHostAddress. It is always possible to return to current builder using Done()
	AsBACnetHostAddressNull() BACnetHostAddressNullBuilder
	// AsBACnetHostAddressIpAddress converts this build to a subType of BACnetHostAddress. It is always possible to return to current builder using Done()
	AsBACnetHostAddressIpAddress() BACnetHostAddressIpAddressBuilder
	// AsBACnetHostAddressName converts this build to a subType of BACnetHostAddress. It is always possible to return to current builder using Done()
	AsBACnetHostAddressName() BACnetHostAddressNameBuilder
	// Build builds the BACnetHostAddress or returns an error if something is wrong
	PartialBuild() (BACnetHostAddressContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetHostAddressContract
	// Build builds the BACnetHostAddress or returns an error if something is wrong
	Build() (BACnetHostAddress, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetHostAddress
}

// NewBACnetHostAddressBuilder() creates a BACnetHostAddressBuilder
func NewBACnetHostAddressBuilder() BACnetHostAddressBuilder {
	return &_BACnetHostAddressBuilder{_BACnetHostAddress: new(_BACnetHostAddress)}
}

type _BACnetHostAddressChildBuilder interface {
	utils.Copyable
	setParent(BACnetHostAddressContract)
	buildForBACnetHostAddress() (BACnetHostAddress, error)
}

type _BACnetHostAddressBuilder struct {
	*_BACnetHostAddress

	childBuilder _BACnetHostAddressChildBuilder

	collectedErr []error
}

var _ (BACnetHostAddressBuilder) = (*_BACnetHostAddressBuilder)(nil)

func (b *_BACnetHostAddressBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetHostAddressBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetHostAddressBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetHostAddressBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetHostAddressBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetHostAddressBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetHostAddressBuilder) PartialBuild() (BACnetHostAddressContract, error) {
	if b.PeekedTagHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetHostAddress.deepCopy(), nil
}

func (b *_BACnetHostAddressBuilder) PartialMustBuild() BACnetHostAddressContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetHostAddressBuilder) AsBACnetHostAddressNull() BACnetHostAddressNullBuilder {
	if cb, ok := b.childBuilder.(BACnetHostAddressNullBuilder); ok {
		return cb
	}
	cb := NewBACnetHostAddressNullBuilder().(*_BACnetHostAddressNullBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetHostAddressBuilder) AsBACnetHostAddressIpAddress() BACnetHostAddressIpAddressBuilder {
	if cb, ok := b.childBuilder.(BACnetHostAddressIpAddressBuilder); ok {
		return cb
	}
	cb := NewBACnetHostAddressIpAddressBuilder().(*_BACnetHostAddressIpAddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetHostAddressBuilder) AsBACnetHostAddressName() BACnetHostAddressNameBuilder {
	if cb, ok := b.childBuilder.(BACnetHostAddressNameBuilder); ok {
		return cb
	}
	cb := NewBACnetHostAddressNameBuilder().(*_BACnetHostAddressNameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetHostAddressBuilder) Build() (BACnetHostAddress, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetHostAddress()
}

func (b *_BACnetHostAddressBuilder) MustBuild() BACnetHostAddress {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetHostAddressBuilder) DeepCopy() any {
	_copy := b.CreateBACnetHostAddressBuilder().(*_BACnetHostAddressBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetHostAddressChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetHostAddressBuilder creates a BACnetHostAddressBuilder
func (b *_BACnetHostAddress) CreateBACnetHostAddressBuilder() BACnetHostAddressBuilder {
	if b == nil {
		return NewBACnetHostAddressBuilder()
	}
	return &_BACnetHostAddressBuilder{_BACnetHostAddress: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetHostAddress) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetHostAddress) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetHostAddress(structType any) BACnetHostAddress {
	if casted, ok := structType.(BACnetHostAddress); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetHostAddress); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetHostAddress) GetTypeName() string {
	return "BACnetHostAddress"
}

func (m *_BACnetHostAddress) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetHostAddress) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetHostAddress) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetHostAddressParse[T BACnetHostAddress](ctx context.Context, theBytes []byte) (T, error) {
	return BACnetHostAddressParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetHostAddressParseWithBufferProducer[T BACnetHostAddress]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetHostAddressParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetHostAddressParseWithBuffer[T BACnetHostAddress](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BACnetHostAddress{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetHostAddress) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetHostAddress BACnetHostAddress, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetHostAddress"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetHostAddress")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetHostAddress
	switch {
	case peekedTagNumber == uint8(0): // BACnetHostAddressNull
		if _child, err = new(_BACnetHostAddressNull).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetHostAddressNull for type-switch of BACnetHostAddress")
		}
	case peekedTagNumber == uint8(1): // BACnetHostAddressIpAddress
		if _child, err = new(_BACnetHostAddressIpAddress).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetHostAddressIpAddress for type-switch of BACnetHostAddress")
		}
	case peekedTagNumber == uint8(2): // BACnetHostAddressName
		if _child, err = new(_BACnetHostAddressName).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetHostAddressName for type-switch of BACnetHostAddress")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	if closeErr := readBuffer.CloseContext("BACnetHostAddress"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetHostAddress")
	}

	return _child, nil
}

func (pm *_BACnetHostAddress) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetHostAddress, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetHostAddress"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetHostAddress")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetHostAddress"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetHostAddress")
	}
	return nil
}

func (m *_BACnetHostAddress) IsBACnetHostAddress() {}

func (m *_BACnetHostAddress) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetHostAddress) deepCopy() *_BACnetHostAddress {
	if m == nil {
		return nil
	}
	_BACnetHostAddressCopy := &_BACnetHostAddress{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
	}
	return _BACnetHostAddressCopy
}
