/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.outcome;

import java.time.Duration;
import org.apache.qpid.server.security.limit.ConnectionLimitException;
import org.apache.qpid.server.user.connection.limits.logging.ConnectionLimitEventLogger;

public final class RejectRegistration
extends ConnectionLimitException {
    private static final String USER_COUNT_BREAKS_LIMIT_ON_PORT = "User %s breaks connection count limit %d on port %s";
    private static final String USER_FREQUENCY_BREAKS_LIMIT_ON_PORT = "User %s breaks connection frequency limit %d per %d s on port %s";
    private static final String USER_BLOCKED_ON_PORT = "User %s is blocked on port %s";
    private final String _userId;

    public static RejectRegistration breakingConnectionCount(String userId, int limit, String port) {
        return new RejectRegistration(userId, String.format(USER_COUNT_BREAKS_LIMIT_ON_PORT, userId, limit, port));
    }

    public static RejectRegistration breakingConnectionFrequency(String userId, int limit, Duration frequencyPeriod, String port) {
        return new RejectRegistration(userId, String.format(USER_FREQUENCY_BREAKS_LIMIT_ON_PORT, userId, limit, frequencyPeriod.getSeconds(), port));
    }

    public static RejectRegistration blockedUser(String userId, String port) {
        return new RejectRegistration(userId, String.format(USER_BLOCKED_ON_PORT, userId, port));
    }

    public String logMessage(ConnectionLimitEventLogger logger) {
        String message = this.getMessage();
        logger.logRejectConnection(this._userId, message);
        return message;
    }

    private RejectRegistration(String userId, String message) {
        super(message);
        this._userId = userId;
    }
}

