/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.qpid.AMQChannelClosedException;
import org.apache.qpid.AMQInvalidArgumentException;
import org.apache.qpid.AMQInvalidRoutingKeyException;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQNoConsumersException;
import org.apache.qpid.client.AMQNoRouteException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelCloseMethodHandler
implements StateAwareMethodListener<ChannelCloseBody> {
    private static final Logger _logger = LoggerFactory.getLogger(ChannelCloseMethodHandler.class);
    private static ChannelCloseMethodHandler _handler = new ChannelCloseMethodHandler();

    public static ChannelCloseMethodHandler getInstance() {
        return _handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void methodReceived(AMQProtocolSession session, ChannelCloseBody method, int channelId) throws QpidException {
        _logger.debug("ChannelClose method received");
        int replyCode = method.getReplyCode();
        AMQShortString reason = method.getReplyText();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Channel close reply code: " + replyCode + ", reason: " + reason);
        }
        ChannelCloseOkBody body = session.getMethodRegistry().createChannelCloseOkBody();
        AMQFrame frame = body.generateFrame(channelId);
        session.writeFrame(frame);
        try {
            if (replyCode != 200) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Channel close received with errorCode " + replyCode + ", and reason " + reason);
                }
                if (replyCode == 313) {
                    throw new AMQNoConsumersException("Error: " + reason, null, null);
                }
                if (replyCode == 312) {
                    throw new AMQNoRouteException("Error: " + reason, null, null);
                }
                if (replyCode == 409) {
                    _logger.debug("Broker responded with Invalid Argument.");
                    throw new AMQInvalidArgumentException(String.valueOf(reason), null);
                }
                if (replyCode == 407) {
                    _logger.debug("Broker responded with Invalid Routing Key.");
                    throw new AMQInvalidRoutingKeyException(String.valueOf(reason), null);
                }
                throw new AMQChannelClosedException(replyCode, "Error: " + reason, null);
            }
        }
        finally {
            session.channelClosed(channelId, replyCode, String.valueOf(reason));
        }
    }
}

