/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.LinkOptions;

public class ReceiverOptions
extends LinkOptions<ReceiverOptions>
implements Cloneable {
    private long drainTimeout = 60000L;
    private boolean autoAccept = true;
    private int creditWindow = 10;

    public ReceiverOptions() {
    }

    public ReceiverOptions(ReceiverOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public ReceiverOptions autoAccept(boolean autoAccept) {
        this.autoAccept = autoAccept;
        return this;
    }

    public boolean autoAccept() {
        return this.autoAccept;
    }

    public int creditWindow() {
        return this.creditWindow;
    }

    public ReceiverOptions creditWindow(int creditWindow) {
        this.creditWindow = creditWindow;
        return this;
    }

    public long drainTimeout() {
        return this.drainTimeout;
    }

    public ReceiverOptions drainTimeout(long drainTimeout) {
        return this.drainTimeout(drainTimeout, TimeUnit.MILLISECONDS);
    }

    public ReceiverOptions drainTimeout(long timeout, TimeUnit units) {
        this.drainTimeout = units.toMillis(timeout);
        return this;
    }

    public ReceiverOptions clone() {
        return this.copyInto(new ReceiverOptions());
    }

    protected ReceiverOptions copyInto(ReceiverOptions other) {
        super.copyInto(other);
        other.autoAccept(this.autoAccept);
        other.creditWindow(this.creditWindow);
        other.drainTimeout(this.drainTimeout);
        return other;
    }

    @Override
    protected ReceiverOptions self() {
        return this;
    }
}

