/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.engine.EventHandler;
import org.apache.qpid.protonj2.engine.Link;
import org.apache.qpid.protonj2.engine.LinkState;
import org.apache.qpid.protonj2.engine.Receiver;
import org.apache.qpid.protonj2.engine.Sender;
import org.apache.qpid.protonj2.engine.exceptions.EngineShutdownException;
import org.apache.qpid.protonj2.engine.impl.ProtonConnection;
import org.apache.qpid.protonj2.engine.impl.ProtonEndpoint;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.ProtonIncomingDelivery;
import org.apache.qpid.protonj2.engine.impl.ProtonLinkCreditState;
import org.apache.qpid.protonj2.engine.impl.ProtonOutgoingDelivery;
import org.apache.qpid.protonj2.engine.impl.ProtonReceiver;
import org.apache.qpid.protonj2.engine.impl.ProtonSession;
import org.apache.qpid.protonj2.engine.impl.ProtonTransactionManager;
import org.apache.qpid.protonj2.logging.ProtonLogger;
import org.apache.qpid.protonj2.logging.ProtonLoggerFactory;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Source;
import org.apache.qpid.protonj2.types.messaging.Target;
import org.apache.qpid.protonj2.types.messaging.Terminus;
import org.apache.qpid.protonj2.types.transactions.Coordinator;
import org.apache.qpid.protonj2.types.transport.Attach;
import org.apache.qpid.protonj2.types.transport.Detach;
import org.apache.qpid.protonj2.types.transport.Disposition;
import org.apache.qpid.protonj2.types.transport.Flow;
import org.apache.qpid.protonj2.types.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.types.transport.Role;
import org.apache.qpid.protonj2.types.transport.SenderSettleMode;
import org.apache.qpid.protonj2.types.transport.Transfer;

public abstract class ProtonLink<L extends Link<L>>
extends ProtonEndpoint<L>
implements Link<L> {
    private static final ProtonLogger LOG = ProtonLoggerFactory.getLogger(ProtonLink.class);
    protected final ProtonConnection connection;
    protected final ProtonSession session;
    protected final Attach localAttach = new Attach();
    protected Attach remoteAttach;
    private boolean localAttachSent;
    private boolean localDetachSent;
    private final ProtonLinkCreditState creditState;
    private LinkOperabilityState operability = LinkOperabilityState.OK;
    private LinkState localState = LinkState.IDLE;
    private LinkState remoteState = LinkState.IDLE;
    private EventHandler<L> localDetachHandler;
    private EventHandler<L> remoteDetachHandler;
    private EventHandler<L> parentEndpointClosedEventHandler;

    protected ProtonLink(ProtonSession session, String name, ProtonLinkCreditState creditState) {
        super(session.getEngine());
        this.session = session;
        this.connection = session.getConnection();
        this.creditState = creditState;
        this.localAttach.setName(name);
        this.localAttach.setRole(this.getRole());
    }

    @Override
    public ProtonConnection getConnection() {
        return this.connection;
    }

    @Override
    public ProtonSession getSession() {
        return this.session;
    }

    @Override
    public ProtonSession getParent() {
        return this.session;
    }

    @Override
    public String getName() {
        return this.localAttach.getName();
    }

    @Override
    public boolean isSender() {
        return this.getRole() == Role.SENDER;
    }

    @Override
    public boolean isReceiver() {
        return this.getRole() == Role.RECEIVER;
    }

    @Override
    protected abstract L self();

    long getHandle() {
        return this.localAttach.getHandle();
    }

    @Override
    public LinkState getState() {
        return this.localState;
    }

    @Override
    public LinkState getRemoteState() {
        return this.remoteState;
    }

    @Override
    public L open() {
        if (this.getState() == LinkState.IDLE) {
            this.checkLinkOperable("Cannot open Link");
            this.localState = LinkState.ACTIVE;
            long localHandle = this.session.findFreeLocalHandle(this);
            this.localAttach.setHandle(localHandle);
            this.transitionedToLocallyOpened();
            try {
                this.trySyncLocalStateWithRemote();
            }
            finally {
                this.fireLocalOpen();
            }
        }
        return (L)this.self();
    }

    @Override
    public L detach() {
        if (this.getState() == LinkState.ACTIVE) {
            this.localState = LinkState.DETACHED;
            if (this.operability.ordinal() < LinkOperabilityState.LINK_LOCALLY_DETACHED.ordinal()) {
                this.operability = LinkOperabilityState.LINK_LOCALLY_DETACHED;
            }
            this.getCreditState().clearCredit();
            this.transitionedToLocallyDetached();
            try {
                this.engine.checkFailed("Closed called on already failed connection");
                this.trySyncLocalStateWithRemote();
            }
            finally {
                this.fireLocalDetach();
            }
        }
        return (L)this.self();
    }

    @Override
    public L close() {
        if (this.getState() == LinkState.ACTIVE) {
            this.localState = LinkState.CLOSED;
            if (this.operability.ordinal() < LinkOperabilityState.LINK_LOCALLY_CLOSED.ordinal()) {
                this.operability = LinkOperabilityState.LINK_LOCALLY_CLOSED;
            }
            this.getCreditState().clearCredit();
            this.transitionedToLocallyClosed();
            try {
                this.engine.checkFailed("Detached called on already failed connection");
                this.trySyncLocalStateWithRemote();
            }
            finally {
                this.fireLocalClose();
            }
        }
        return (L)this.self();
    }

    @Override
    public L setSenderSettleMode(SenderSettleMode senderSettleMode) {
        this.checkNotOpened("Cannot set Sender settlement mode on already opened Link");
        this.localAttach.setSenderSettleMode(senderSettleMode);
        return (L)this.self();
    }

    @Override
    public SenderSettleMode getSenderSettleMode() {
        return this.localAttach.getSenderSettleMode();
    }

    @Override
    public L setReceiverSettleMode(ReceiverSettleMode receiverSettleMode) {
        this.checkNotOpened("Cannot set Receiver settlement mode already opened Link");
        this.localAttach.setReceiverSettleMode(receiverSettleMode);
        return (L)this.self();
    }

    @Override
    public ReceiverSettleMode getReceiverSettleMode() {
        return this.localAttach.getReceiverSettleMode();
    }

    @Override
    public L setSource(Source source) {
        this.checkNotOpened("Cannot set Source on already opened Link");
        this.localAttach.setSource(source);
        return (L)this.self();
    }

    @Override
    public Source getSource() {
        return this.localAttach.getSource();
    }

    @Override
    public L setTarget(Target target) {
        this.checkNotOpened("Cannot set Target on already opened Link");
        this.localAttach.setTarget(target);
        return (L)this.self();
    }

    @Override
    public L setTarget(Coordinator coordinator) throws IllegalStateException {
        this.checkNotOpened("Cannot set Coordinator on already opened Link");
        this.localAttach.setTarget(coordinator);
        return (L)this.self();
    }

    @Override
    public <T extends Terminus> T getTarget() {
        return this.localAttach.getTarget();
    }

    @Override
    public L setProperties(Map<Symbol, Object> properties) {
        this.checkNotOpened("Cannot set Properties on already opened Link");
        if (properties != null) {
            this.localAttach.setProperties(new LinkedHashMap<Symbol, Object>(properties));
        } else {
            this.localAttach.setProperties(properties);
        }
        return (L)this.self();
    }

    @Override
    public Map<Symbol, Object> getProperties() {
        if (this.localAttach.getProperties() != null) {
            return Collections.unmodifiableMap(this.localAttach.getProperties());
        }
        return null;
    }

    @Override
    public L setOfferedCapabilities(Symbol ... capabilities) {
        this.checkNotOpened("Cannot set Offered Capabilities on already opened Link");
        if (capabilities != null) {
            this.localAttach.setOfferedCapabilities(Arrays.copyOf(capabilities, capabilities.length));
        } else {
            this.localAttach.setOfferedCapabilities(capabilities);
        }
        return (L)this.self();
    }

    @Override
    public Symbol[] getOfferedCapabilities() {
        if (this.localAttach.getOfferedCapabilities() != null) {
            return Arrays.copyOf(this.localAttach.getOfferedCapabilities(), this.localAttach.getOfferedCapabilities().length);
        }
        return null;
    }

    @Override
    public L setDesiredCapabilities(Symbol ... capabilities) {
        this.checkNotOpened("Cannot set Desired Capabilities on already opened Link");
        if (capabilities != null) {
            this.localAttach.setDesiredCapabilities(Arrays.copyOf(capabilities, capabilities.length));
        } else {
            this.localAttach.setDesiredCapabilities(capabilities);
        }
        return (L)this.self();
    }

    @Override
    public Symbol[] getDesiredCapabilities() {
        if (this.localAttach.getDesiredCapabilities() != null) {
            return Arrays.copyOf(this.localAttach.getDesiredCapabilities(), this.localAttach.getDesiredCapabilities().length);
        }
        return null;
    }

    @Override
    public L setMaxMessageSize(UnsignedLong maxMessageSize) {
        this.checkNotOpened("Cannot set Max Message Size on already opened Link");
        this.localAttach.setMaxMessageSize(maxMessageSize);
        return (L)this.self();
    }

    @Override
    public UnsignedLong getMaxMessageSize() {
        return this.localAttach.getMaxMessageSize();
    }

    @Override
    public boolean isLocallyOpen() {
        return this.getState() == LinkState.ACTIVE;
    }

    @Override
    public boolean isLocallyClosed() {
        return this.getState() == LinkState.CLOSED;
    }

    @Override
    public boolean isLocallyDetached() {
        return this.getState() == LinkState.DETACHED;
    }

    @Override
    public boolean isLocallyClosedOrDetached() {
        return this.getState().ordinal() > LinkState.ACTIVE.ordinal();
    }

    @Override
    public boolean isRemotelyOpen() {
        return this.getRemoteState() == LinkState.ACTIVE;
    }

    @Override
    public boolean isRemotelyClosed() {
        return this.getRemoteState() == LinkState.CLOSED;
    }

    @Override
    public boolean isRemotelyDetached() {
        return this.getRemoteState() == LinkState.DETACHED;
    }

    @Override
    public boolean isRemotelyClosedOrDetached() {
        return this.getRemoteState().ordinal() > LinkState.ACTIVE.ordinal();
    }

    @Override
    public SenderSettleMode getRemoteSenderSettleMode() {
        if (this.remoteAttach != null) {
            return this.remoteAttach.getSenderSettleMode();
        }
        return null;
    }

    @Override
    public ReceiverSettleMode getRemoteReceiverSettleMode() {
        if (this.remoteAttach != null) {
            return this.remoteAttach.getReceiverSettleMode();
        }
        return null;
    }

    @Override
    public Source getRemoteSource() {
        if (this.remoteAttach != null && this.remoteAttach.getSource() != null) {
            return this.remoteAttach.getSource().copy();
        }
        return null;
    }

    @Override
    public <T extends Terminus> T getRemoteTarget() {
        if (this.remoteAttach != null && this.remoteAttach.getTarget() != null) {
            return (T)this.remoteAttach.getTarget().copy();
        }
        return null;
    }

    @Override
    public Symbol[] getRemoteOfferedCapabilities() {
        if (this.remoteAttach != null && this.remoteAttach.getOfferedCapabilities() != null) {
            return Arrays.copyOf(this.remoteAttach.getOfferedCapabilities(), this.remoteAttach.getOfferedCapabilities().length);
        }
        return null;
    }

    @Override
    public Symbol[] getRemoteDesiredCapabilities() {
        if (this.remoteAttach != null && this.remoteAttach.getDesiredCapabilities() != null) {
            return Arrays.copyOf(this.remoteAttach.getDesiredCapabilities(), this.remoteAttach.getDesiredCapabilities().length);
        }
        return null;
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        if (this.remoteAttach != null && this.remoteAttach.getProperties() != null) {
            return Collections.unmodifiableMap(this.remoteAttach.getProperties());
        }
        return null;
    }

    @Override
    public UnsignedLong getRemoteMaxMessageSize() {
        if (this.remoteAttach != null && this.remoteAttach.getMaxMessageSize() != null) {
            return this.remoteAttach.getMaxMessageSize();
        }
        return null;
    }

    @Override
    public L localDetachHandler(EventHandler<L> localDetachHandler) {
        this.localDetachHandler = localDetachHandler;
        return (L)this.self();
    }

    EventHandler<L> localDetachHandler() {
        return this.localDetachHandler;
    }

    L fireLocalDetach() {
        if (this.localDetachHandler != null) {
            this.localDetachHandler.handle(this.self());
        } else {
            this.fireLocalClose();
        }
        return (L)this.self();
    }

    @Override
    public L detachHandler(EventHandler<L> remoteDetachHandler) {
        this.remoteDetachHandler = remoteDetachHandler;
        return (L)this.self();
    }

    EventHandler<L> detachHandler() {
        return this.remoteDetachHandler;
    }

    L fireRemoteDetach() {
        if (this.remoteDetachHandler != null) {
            this.remoteDetachHandler.handle(this.self());
        } else {
            this.fireRemoteClose();
        }
        return (L)this.self();
    }

    @Override
    public L parentEndpointClosedHandler(EventHandler<L> handler) {
        this.parentEndpointClosedEventHandler = handler;
        return (L)this.self();
    }

    EventHandler<L> parentEndpointClosedHandler() {
        return this.parentEndpointClosedEventHandler;
    }

    L fireParentEndpointClosed() {
        if (this.parentEndpointClosedEventHandler != null && this.isLocallyOpen()) {
            this.parentEndpointClosedEventHandler.handle(this.self());
        }
        return (L)this.self();
    }

    protected void transitionedToLocallyOpened() {
    }

    protected void transitionedToLocallyDetached() {
    }

    protected void transitionedToLocallyClosed() {
    }

    protected void transitionToRemotelyOpenedState() {
    }

    protected void transitionToRemotelyDetached() {
    }

    protected void transitionToRemotelyClosed() {
    }

    protected void transitionToParentLocallyClosed() {
    }

    protected void transitionToParentRemotelyClosed() {
    }

    final void handleSessionLocallyClosed(ProtonSession session) {
        if (this.isSender()) {
            this.getCreditState().clearCredit();
        }
        if (this.operability.ordinal() < LinkOperabilityState.SESSION_LOCALLY_CLOSED.ordinal()) {
            this.operability = LinkOperabilityState.SESSION_LOCALLY_CLOSED;
            this.transitionToParentLocallyClosed();
            this.fireParentEndpointClosed();
        }
    }

    final void handleSessionRemotelyClosed(ProtonSession session) {
        if (this.isSender()) {
            this.getCreditState().clearCredit();
        }
        if (this.operability.ordinal() < LinkOperabilityState.SESSION_REMOTELY_CLOSED.ordinal()) {
            this.operability = LinkOperabilityState.SESSION_REMOTELY_CLOSED;
            this.transitionToParentRemotelyClosed();
        }
    }

    final void handleConnectionLocallyClosed(ProtonConnection connection) {
        if (this.isSender()) {
            this.getCreditState().clearCredit();
        }
        if (this.operability.ordinal() < LinkOperabilityState.CONNECTION_LOCALLY_CLOSED.ordinal()) {
            this.operability = LinkOperabilityState.CONNECTION_LOCALLY_CLOSED;
            this.transitionToParentLocallyClosed();
            this.fireParentEndpointClosed();
        }
    }

    final void handleConnectionRemotelyClosed(ProtonConnection connection) {
        if (this.isSender()) {
            this.getCreditState().clearCredit();
        }
        if (this.operability.ordinal() < LinkOperabilityState.CONNECTION_REMOTELY_CLOSED.ordinal()) {
            this.operability = LinkOperabilityState.CONNECTION_REMOTELY_CLOSED;
            this.transitionToParentRemotelyClosed();
        }
    }

    final void handleEngineShutdown(ProtonEngine protonEngine) {
        if (this.isSender()) {
            this.getCreditState().clearCredit();
        }
        if (this.operability.ordinal() < LinkOperabilityState.ENGINE_SHUTDOWN.ordinal()) {
            this.operability = LinkOperabilityState.ENGINE_SHUTDOWN;
        }
        try {
            this.fireEngineShutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void remoteAttach(Attach attach) {
        LOG.trace("Link:{} Received remote Attach:{}", (Object)this.self(), (Object)attach);
        this.remoteAttach = attach;
        this.remoteState = LinkState.ACTIVE;
        this.handleRemoteAttach(attach);
        this.transitionToRemotelyOpenedState();
        if (this.openHandler() != null) {
            this.fireRemoteOpen();
        } else if (this.getRole() == Role.RECEIVER) {
            if (attach.getTarget() instanceof Coordinator) {
                if (this.session.transactionManagerOpenHandler() != null) {
                    this.session.transactionManagerOpenHandler().handle(new ProtonTransactionManager((ProtonReceiver)this));
                } else if (this.connection.transactionManagerOpenHandler() != null) {
                    this.connection.transactionManagerOpenHandler().handle(new ProtonTransactionManager((ProtonReceiver)this));
                }
            }
            if (this.session.receiverOpenEventHandler() != null) {
                this.session.receiverOpenEventHandler().handle((Receiver)((Object)this));
            } else if (this.connection.receiverOpenEventHandler() != null) {
                this.connection.receiverOpenEventHandler().handle((Receiver)((Object)this));
            } else {
                LOG.info("Receiver opened but no event handler registered to inform: {}", (Object)this);
            }
        } else if (this.session.senderOpenEventHandler() != null) {
            this.session.senderOpenEventHandler().handle((Sender)((Object)this));
        } else if (this.connection.senderOpenEventHandler() != null) {
            this.connection.senderOpenEventHandler().handle((Sender)((Object)this));
        } else {
            LOG.info("Sender opened but no event handler registered to inform: {}", (Object)this);
        }
    }

    final ProtonLink<?> remoteDetach(Detach detach) {
        LOG.trace("Link:{} Received remote Detach:{}", (Object)this.self(), (Object)detach);
        this.setRemoteCondition(detach.getError());
        if (this.isSender()) {
            this.getCreditState().clearCredit();
        }
        this.handleRemoteDetach(detach);
        if (detach.getClosed()) {
            this.remoteState = LinkState.CLOSED;
            this.operability = LinkOperabilityState.LINK_REMOTELY_CLOSED;
            this.transitionToRemotelyClosed();
            this.fireRemoteClose();
        } else {
            this.remoteState = LinkState.DETACHED;
            this.operability = LinkOperabilityState.LINK_REMOTELY_DETACHED;
            this.transitionToRemotelyDetached();
            this.fireRemoteDetach();
        }
        return this;
    }

    final ProtonIncomingDelivery remoteTransfer(Transfer transfer, ProtonBuffer payload) {
        LOG.trace("Link:{} Received new Transfer:{}", (Object)this.self(), (Object)transfer);
        return this.handleRemoteTransfer(transfer, payload);
    }

    final L remoteFlow(Flow flow) {
        LOG.trace("Link:{} Received new Flow:{}", (Object)this.self(), (Object)flow);
        return this.handleRemoteFlow(flow);
    }

    final L remoteDisposition(Disposition disposition, ProtonOutgoingDelivery delivery) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Link:{} Received remote disposition:{} for sent delivery:{}", this.self(), disposition, delivery);
        }
        return this.handleRemoteDisposition(disposition, delivery);
    }

    final L remoteDisposition(Disposition disposition, ProtonIncomingDelivery delivery) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Link:{} Received remote disposition:{} for received delivery:{}", this.self(), disposition, delivery);
        }
        return this.handleRemoteDisposition(disposition, delivery);
    }

    protected abstract L handleRemoteAttach(Attach var1);

    protected abstract L handleRemoteDetach(Detach var1);

    protected abstract L handleRemoteFlow(Flow var1);

    protected abstract L handleRemoteDisposition(Disposition var1, ProtonOutgoingDelivery var2);

    protected abstract L handleRemoteDisposition(Disposition var1, ProtonIncomingDelivery var2);

    protected abstract ProtonIncomingDelivery handleRemoteTransfer(Transfer var1, ProtonBuffer var2);

    protected abstract L decorateOutgoingFlow(Flow var1);

    ProtonLinkCreditState getCreditState() {
        return this.creditState;
    }

    boolean wasLocalAttachSent() {
        return this.localAttachSent;
    }

    boolean wasLocalDetachSent() {
        return this.localDetachSent;
    }

    void trySyncLocalStateWithRemote() {
        switch (this.getState()) {
            case IDLE: {
                return;
            }
            case ACTIVE: {
                this.trySendLocalAttach();
                break;
            }
            case CLOSED: 
            case DETACHED: {
                this.trySendLocalAttach();
                this.trySendLocalDetach(this.isLocallyClosed());
                break;
            }
            default: {
                throw new IllegalStateException("Link is in unknown state and cannot proceed");
            }
        }
    }

    private void trySendLocalAttach() {
        if (!this.wasLocalAttachSent() && this.session.isLocallyOpen() && this.session.wasLocalBeginSent() && this.connection.isLocallyOpen() && this.connection.wasLocalOpenSent()) {
            this.session.getEngine().fireWrite(this.localAttach, this.session.getLocalChannel());
            this.localAttachSent = true;
            if (this.isLocallyOpen() && this.isReceiver() && this.getCreditState().hasCredit()) {
                this.session.writeFlow(this);
            }
        }
    }

    private void trySendLocalDetach(boolean closed) {
        if (!this.wasLocalDetachSent() && this.session.isLocallyOpen() && this.session.wasLocalBeginSent() && this.connection.isLocallyOpen() && this.connection.wasLocalOpenSent() && !this.engine.isShutdown()) {
            Detach detach = new Detach();
            detach.setHandle(this.localAttach.getHandle());
            detach.setClosed(closed);
            detach.setError(this.getCondition());
            this.session.getEngine().fireWrite(detach, this.session.getLocalChannel());
            this.session.freeLink(this);
            this.localDetachSent = true;
        }
    }

    protected void checkLinkOperable(String failurePrefix) {
        switch (this.operability) {
            case OK: {
                break;
            }
            case ENGINE_SHUTDOWN: {
                throw new EngineShutdownException(failurePrefix + ": " + this.operability.toString());
            }
            default: {
                throw new IllegalStateException(failurePrefix + ": " + this.operability.toString());
            }
        }
    }

    protected boolean areDeliveriesStillActive() {
        switch (this.operability) {
            case OK: 
            case LINK_REMOTELY_DETACHED: 
            case LINK_LOCALLY_DETACHED: {
                return true;
            }
        }
        return false;
    }

    protected void checkNotOpened(String errorMessage) {
        if (this.localState.ordinal() > LinkState.IDLE.ordinal()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    protected void checkNotClosed(String errorMessage) {
        if (this.localState.ordinal() > LinkState.ACTIVE.ordinal()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private static enum LinkOperabilityState {
        OK,
        LINK_REMOTELY_DETACHED,
        LINK_LOCALLY_DETACHED,
        LINK_REMOTELY_CLOSED,
        LINK_LOCALLY_CLOSED,
        SESSION_REMOTELY_CLOSED,
        SESSION_LOCALLY_CLOSED,
        CONNECTION_REMOTELY_CLOSED,
        CONNECTION_LOCALLY_CLOSED,
        ENGINE_SHUTDOWN;

    }
}

