/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.qpid.protonj2.client.Connection;
import org.apache.qpid.protonj2.client.ConnectionEvent;
import org.apache.qpid.protonj2.client.DisconnectionEvent;
import org.apache.qpid.protonj2.client.NextReceiverPolicy;
import org.apache.qpid.protonj2.client.ReconnectOptions;
import org.apache.qpid.protonj2.client.SaslOptions;
import org.apache.qpid.protonj2.client.SslOptions;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.apache.qpid.protonj2.types.UnsignedInteger;

public class ConnectionOptions
implements Cloneable {
    private static final String[] DEFAULT_DESIRED_CAPABILITIES_ARRAY = new String[]{"ANONYMOUS-RELAY"};
    public static final List<String> DEFAULT_DESIRED_CAPABILITIES = Collections.unmodifiableList(Arrays.asList(DEFAULT_DESIRED_CAPABILITIES_ARRAY));
    public static final long INFINITE = -1L;
    public static final long DEFAULT_OPEN_TIMEOUT = 15000L;
    public static final long DEFAULT_CLOSE_TIMEOUT = 60000L;
    public static final long DEFAULT_SEND_TIMEOUT = -1L;
    public static final long DEFAULT_REQUEST_TIMEOUT = -1L;
    public static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    public static final long DEFAULT_DRAIN_TIMEOUT = 60000L;
    public static final int DEFAULT_CHANNEL_MAX = 65535;
    public static final int DEFAULT_MAX_FRAME_SIZE = 65536;
    public static final NextReceiverPolicy DEFAULT_NEXT_RECEIVER_POLICY = NextReceiverPolicy.ROUND_ROBIN;
    private long sendTimeout = -1L;
    private long requestTimeout = -1L;
    private long openTimeout = 15000L;
    private long closeTimeout = 60000L;
    private long idleTimeout = 60000L;
    private long drainTimeout = 60000L;
    private final TransportOptions transport = new TransportOptions();
    private final ReconnectOptions reconnect = new ReconnectOptions();
    private final SslOptions ssl = new SslOptions();
    private final SaslOptions sasl = new SaslOptions();
    private String user;
    private String password;
    private int channelMax = 65535;
    private int maxFrameSize = 65536;
    private String[] offeredCapabilities;
    private String[] desiredCapabilities = DEFAULT_DESIRED_CAPABILITIES_ARRAY;
    private Map<String, Object> properties;
    private String virtualHost;
    private boolean traceFrames;
    private NextReceiverPolicy nextReceiverPolicy = DEFAULT_NEXT_RECEIVER_POLICY;
    private BiConsumer<Connection, ConnectionEvent> connectedHandler;
    private BiConsumer<Connection, DisconnectionEvent> disconnectedHandler;
    private BiConsumer<Connection, DisconnectionEvent> interruptedHandler;
    private BiConsumer<Connection, ConnectionEvent> reconnectedHandler;

    public ConnectionOptions() {
    }

    public ConnectionOptions(ConnectionOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public ConnectionOptions clone() {
        return this.copyInto(new ConnectionOptions());
    }

    protected ConnectionOptions copyInto(ConnectionOptions other) {
        other.closeTimeout(this.closeTimeout);
        other.openTimeout(this.openTimeout);
        other.sendTimeout(this.sendTimeout);
        other.requestTimeout(this.requestTimeout);
        other.idleTimeout(this.idleTimeout);
        other.drainTimeout(this.drainTimeout);
        other.channelMax(this.channelMax);
        other.maxFrameSize(this.maxFrameSize);
        other.user(this.user);
        other.password(this.password);
        other.traceFrames(this.traceFrames);
        other.connectedHandler(this.connectedHandler);
        other.interruptedHandler(this.interruptedHandler);
        other.reconnectedHandler(this.reconnectedHandler);
        other.disconnectedHandler(this.disconnectedHandler);
        other.defaultNextReceiverPolicy(this.nextReceiverPolicy);
        other.virtualHost(this.virtualHost);
        if (this.offeredCapabilities != null) {
            other.offeredCapabilities(Arrays.copyOf(this.offeredCapabilities, this.offeredCapabilities.length));
        }
        if (this.desiredCapabilities != null) {
            other.desiredCapabilities(Arrays.copyOf(this.desiredCapabilities, this.desiredCapabilities.length));
        }
        if (this.properties != null) {
            other.properties(new HashMap<String, Object>(this.properties));
        }
        this.transport.copyInto(other.transportOptions());
        this.ssl.copyInto(other.sslOptions());
        this.sasl.copyInto(other.saslOptions());
        this.reconnect.copyInto(other.reconnectOptions());
        return other;
    }

    public long closeTimeout() {
        return this.closeTimeout;
    }

    public ConnectionOptions closeTimeout(long closeTimeout) {
        return this.closeTimeout(closeTimeout, TimeUnit.MILLISECONDS);
    }

    public ConnectionOptions closeTimeout(long timeout, TimeUnit units) {
        this.closeTimeout = units.toMillis(timeout);
        return this;
    }

    public long openTimeout() {
        return this.openTimeout;
    }

    public ConnectionOptions openTimeout(long openTimeout) {
        return this.openTimeout(openTimeout, TimeUnit.MILLISECONDS);
    }

    public ConnectionOptions openTimeout(long timeout, TimeUnit units) {
        this.openTimeout = units.toMillis(timeout);
        return this;
    }

    public long sendTimeout() {
        return this.sendTimeout;
    }

    public ConnectionOptions sendTimeout(long sendTimeout) {
        return this.sendTimeout(sendTimeout, TimeUnit.MILLISECONDS);
    }

    public ConnectionOptions sendTimeout(long timeout, TimeUnit units) {
        this.sendTimeout = units.toMillis(timeout);
        return this;
    }

    public long requestTimeout() {
        return this.requestTimeout;
    }

    public ConnectionOptions requestTimeout(long requestTimeout) {
        return this.requestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
    }

    public ConnectionOptions requestTimeout(long timeout, TimeUnit units) {
        this.requestTimeout = units.toMillis(timeout);
        return this;
    }

    public int channelMax() {
        return this.channelMax;
    }

    public ConnectionOptions channelMax(int channelMax) {
        if (channelMax < 0 || channelMax > 65535) {
            throw new IllegalArgumentException("Cannot set a channel max less than zero or greater than 65535");
        }
        this.channelMax = channelMax;
        return this;
    }

    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    public ConnectionOptions maxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public long idleTimeout() {
        return this.idleTimeout;
    }

    public ConnectionOptions idleTimeout(long idleTimeout) {
        return this.idleTimeout(idleTimeout, TimeUnit.MILLISECONDS);
    }

    public ConnectionOptions idleTimeout(long timeout, TimeUnit units) {
        this.idleTimeout = UnsignedInteger.valueOf((long)units.toMillis(timeout)).longValue();
        return this;
    }

    public long drainTimeout() {
        return this.drainTimeout;
    }

    public ConnectionOptions drainTimeout(long drainTimeout) {
        return this.drainTimeout(drainTimeout, TimeUnit.MILLISECONDS);
    }

    public ConnectionOptions drainTimeout(long timeout, TimeUnit units) {
        this.drainTimeout = units.toMillis(timeout);
        return this;
    }

    public String[] offeredCapabilities() {
        return this.offeredCapabilities;
    }

    public ConnectionOptions offeredCapabilities(String ... offeredCapabilities) {
        this.offeredCapabilities = offeredCapabilities;
        return this;
    }

    public String[] desiredCapabilities() {
        return this.desiredCapabilities;
    }

    public ConnectionOptions desiredCapabilities(String ... desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public ConnectionOptions properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public String virtualHost() {
        return this.virtualHost;
    }

    public ConnectionOptions virtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    public String user() {
        return this.user;
    }

    public ConnectionOptions user(String user) {
        this.user = user;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ConnectionOptions password(String password) {
        this.password = password;
        return this;
    }

    public TransportOptions transportOptions() {
        return this.transport;
    }

    public SslOptions sslOptions() {
        return this.ssl;
    }

    public SaslOptions saslOptions() {
        return this.sasl;
    }

    public boolean reconnectEnabled() {
        return this.reconnect.reconnectEnabled();
    }

    public ConnectionOptions reconnectEnabled(boolean reconnectEnabled) {
        this.reconnect.reconnectEnabled(reconnectEnabled);
        return this;
    }

    public ReconnectOptions reconnectOptions() {
        return this.reconnect;
    }

    public ConnectionOptions traceFrames(boolean traceFrames) {
        this.traceFrames = traceFrames;
        return this;
    }

    public boolean traceFrames() {
        return this.traceFrames;
    }

    public boolean sslEnabled() {
        return this.ssl.sslEnabled();
    }

    public ConnectionOptions sslEnabled(boolean sslEnabled) {
        this.ssl.sslEnabled(sslEnabled);
        return this;
    }

    public NextReceiverPolicy defaultNextReceiverPolicy() {
        return this.nextReceiverPolicy;
    }

    public ConnectionOptions defaultNextReceiverPolicy(NextReceiverPolicy policy) {
        this.nextReceiverPolicy = policy;
        return this;
    }

    public BiConsumer<Connection, DisconnectionEvent> disconnectedHandler() {
        return this.disconnectedHandler;
    }

    public ConnectionOptions disconnectedHandler(BiConsumer<Connection, DisconnectionEvent> disconnectedHandler) {
        this.disconnectedHandler = disconnectedHandler;
        return this;
    }

    public BiConsumer<Connection, ConnectionEvent> connectedHandler() {
        return this.connectedHandler;
    }

    public ConnectionOptions connectedHandler(BiConsumer<Connection, ConnectionEvent> connectedHandler) {
        this.connectedHandler = connectedHandler;
        return this;
    }

    public BiConsumer<Connection, DisconnectionEvent> interruptedHandler() {
        return this.interruptedHandler;
    }

    public ConnectionOptions interruptedHandler(BiConsumer<Connection, DisconnectionEvent> interruptedHandler) {
        this.interruptedHandler = interruptedHandler;
        return this;
    }

    public BiConsumer<Connection, ConnectionEvent> reconnectedHandler() {
        return this.reconnectedHandler;
    }

    public ConnectionOptions reconnectedHandler(BiConsumer<Connection, ConnectionEvent> reconnectedHandler) {
        this.reconnectedHandler = reconnectedHandler;
        return this;
    }
}

