/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public abstract class SolrRequest<T extends SolrResponse>
implements Serializable {
    private Principal userPrincipal;
    public static final Set<String> SUPPORTED_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(METHOD.GET.toString(), METHOD.POST.toString(), METHOD.PUT.toString(), METHOD.DELETE.toString())));
    private METHOD method = METHOD.GET;
    private String path = null;
    private Map<String, String> headers;
    private List<String> preferredNodes;
    private ResponseParser responseParser;
    private StreamingResponseCallback callback;
    private Set<String> queryParams;
    protected boolean usev2;
    protected boolean useBinaryV2;
    private String basicAuthUser;
    private String basicAuthPwd;
    private String basePath;

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public SolrRequest setUseV2(boolean flag) {
        this.usev2 = flag;
        return this;
    }

    public SolrRequest setUseBinaryV2(boolean flag) {
        this.useBinaryV2 = flag;
        return this;
    }

    public SolrRequest<T> setPreferredNodes(List<String> nodes) {
        this.preferredNodes = nodes;
        return this;
    }

    public List<String> getPreferredNodes() {
        return this.preferredNodes;
    }

    public SolrRequest setBasicAuthCredentials(String user, String password) {
        this.basicAuthUser = user;
        this.basicAuthPwd = password;
        return this;
    }

    public String getBasicAuthUser() {
        return this.basicAuthUser;
    }

    public String getBasicAuthPassword() {
        return this.basicAuthPwd;
    }

    public SolrRequest(METHOD m, String path) {
        this.method = m;
        this.path = path;
    }

    public METHOD getMethod() {
        return this.method;
    }

    public void setMethod(METHOD method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ResponseParser getResponseParser() {
        return this.responseParser;
    }

    public void setResponseParser(ResponseParser responseParser) {
        this.responseParser = responseParser;
    }

    public StreamingResponseCallback getStreamingResponseCallback() {
        return this.callback;
    }

    public void setStreamingResponseCallback(StreamingResponseCallback callback) {
        this.callback = callback;
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Set<String> queryParams) {
        this.queryParams = queryParams;
    }

    public abstract SolrParams getParams();

    @Deprecated
    public Collection<ContentStream> getContentStreams() throws IOException {
        return null;
    }

    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
        return null;
    }

    protected abstract T createResponse(SolrClient var1);

    public final T process(SolrClient client, String collection) throws SolrServerException, IOException {
        long startNanos = System.nanoTime();
        T res = this.createResponse(client);
        ((SolrResponse)res).setResponse(client.request(this, collection));
        long endNanos = System.nanoTime();
        ((SolrResponse)res).setElapsedTime(TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos));
        return res;
    }

    public final T process(SolrClient client) throws SolrServerException, IOException {
        return this.process(client, null);
    }

    public String getCollection() {
        return this.getParams() == null ? null : this.getParams().get("collection");
    }

    public void setBasePath(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.basePath = path;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.headers);
    }

    public static enum METHOD {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

