/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.math3.distribution.EnumeratedIntegerDistribution;
import org.apache.commons.math3.util.MathArrays;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MarkovChainEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public MarkovChainEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 < this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting no more then two parameters but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        int state = -1;
        if (values.length == 2) {
            state = ((Number)values[1]).intValue();
        }
        if (values[0] instanceof Matrix) {
            Matrix matrix = (Matrix)values[0];
            return new MarkovChain(matrix, state);
        }
        throw new IOException("matrix parameter expected for markovChain function");
    }

    public static class MarkovChain {
        private int state;
        private EnumeratedIntegerDistribution[] distributions;

        public MarkovChain(Matrix matrix, int state) throws IOException {
            double[][] data = matrix.getData();
            if (data.length != data[0].length) {
                throw new IOException("markovChain must be initialized with a square matrix.");
            }
            this.distributions = new EnumeratedIntegerDistribution[data.length];
            this.state = state > -1 ? state : new Random().nextInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                double[] probabilities = data[i];
                int[] states = MathArrays.sequence((int)data.length, (int)0, (int)1);
                this.distributions[i] = new EnumeratedIntegerDistribution(states, probabilities);
            }
        }

        public Number sample() {
            this.state = this.distributions[this.state].sample();
            return this.state;
        }

        public int[] sample(int size) {
            int[] sample = new int[size];
            for (int i = 0; i < size; ++i) {
                sample[i] = this.sample().intValue();
            }
            return sample;
        }
    }
}

