/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.storage.BlobContainersCreateOrUpdateImmutabilityPolicyHeaders;
import com.microsoft.azure.management.storage.BlobContainersDeleteImmutabilityPolicyHeaders;
import com.microsoft.azure.management.storage.BlobContainersExtendImmutabilityPolicyHeaders;
import com.microsoft.azure.management.storage.BlobContainersGetImmutabilityPolicyHeaders;
import com.microsoft.azure.management.storage.BlobContainersLockImmutabilityPolicyHeaders;
import com.microsoft.azure.management.storage.PublicAccess;
import com.microsoft.azure.management.storage.implementation.BlobContainerInner;
import com.microsoft.azure.management.storage.implementation.ImmutabilityPolicyInner;
import com.microsoft.azure.management.storage.implementation.LegalHoldInner;
import com.microsoft.azure.management.storage.implementation.ListContainerItemsInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class BlobContainersInner {
    private BlobContainersService service;
    private StorageManagementClientImpl client;

    public BlobContainersInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (BlobContainersService)retrofit.create(BlobContainersService.class);
        this.client = client;
    }

    public ListContainerItemsInner list(String resourceGroupName, String accountName) {
        return (ListContainerItemsInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<ListContainerItemsInner> listAsync(String resourceGroupName, String accountName, ServiceCallback<ListContainerItemsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<ListContainerItemsInner> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<ListContainerItemsInner>, ListContainerItemsInner>(){

            public ListContainerItemsInner call(ServiceResponse<ListContainerItemsInner> response) {
                return (ListContainerItemsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ListContainerItemsInner>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ListContainerItemsInner>>>(){

            public Observable<ServiceResponse<ListContainerItemsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ListContainerItemsInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ListContainerItemsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BlobContainerInner create(String resourceGroupName, String accountName, String containerName) {
        return (BlobContainerInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, containerName).toBlocking().single()).body());
    }

    public ServiceFuture<BlobContainerInner> createAsync(String resourceGroupName, String accountName, String containerName, ServiceCallback<BlobContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, containerName), serviceCallback);
    }

    public Observable<BlobContainerInner> createAsync(String resourceGroupName, String accountName, String containerName) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, containerName).map((Func1)new Func1<ServiceResponse<BlobContainerInner>, BlobContainerInner>(){

            public BlobContainerInner call(ServiceResponse<BlobContainerInner> response) {
                return (BlobContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BlobContainerInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object publicAccess = null;
        Object metadata = null;
        BlobContainerInner blobContainer = new BlobContainerInner();
        blobContainer.withPublicAccess(null);
        blobContainer.withMetadata(null);
        return this.service.create(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), blobContainer, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BlobContainerInner>>>(){

            public Observable<ServiceResponse<BlobContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public BlobContainerInner create(String resourceGroupName, String accountName, String containerName, PublicAccess publicAccess, Map<String, String> metadata) {
        return (BlobContainerInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, containerName, publicAccess, metadata).toBlocking().single()).body());
    }

    public ServiceFuture<BlobContainerInner> createAsync(String resourceGroupName, String accountName, String containerName, PublicAccess publicAccess, Map<String, String> metadata, ServiceCallback<BlobContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, containerName, publicAccess, metadata), serviceCallback);
    }

    public Observable<BlobContainerInner> createAsync(String resourceGroupName, String accountName, String containerName, PublicAccess publicAccess, Map<String, String> metadata) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, containerName, publicAccess, metadata).map((Func1)new Func1<ServiceResponse<BlobContainerInner>, BlobContainerInner>(){

            public BlobContainerInner call(ServiceResponse<BlobContainerInner> response) {
                return (BlobContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BlobContainerInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, PublicAccess publicAccess, Map<String, String> metadata) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(metadata);
        BlobContainerInner blobContainer = new BlobContainerInner();
        blobContainer.withPublicAccess(publicAccess);
        blobContainer.withMetadata(metadata);
        return this.service.create(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), blobContainer, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BlobContainerInner>>>(){

            public Observable<ServiceResponse<BlobContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BlobContainerInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<BlobContainerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BlobContainerInner update(String resourceGroupName, String accountName, String containerName) {
        return (BlobContainerInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, containerName).toBlocking().single()).body());
    }

    public ServiceFuture<BlobContainerInner> updateAsync(String resourceGroupName, String accountName, String containerName, ServiceCallback<BlobContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, containerName), serviceCallback);
    }

    public Observable<BlobContainerInner> updateAsync(String resourceGroupName, String accountName, String containerName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, containerName).map((Func1)new Func1<ServiceResponse<BlobContainerInner>, BlobContainerInner>(){

            public BlobContainerInner call(ServiceResponse<BlobContainerInner> response) {
                return (BlobContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BlobContainerInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object publicAccess = null;
        Object metadata = null;
        BlobContainerInner blobContainer = new BlobContainerInner();
        blobContainer.withPublicAccess(null);
        blobContainer.withMetadata(null);
        return this.service.update(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), blobContainer, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BlobContainerInner>>>(){

            public Observable<ServiceResponse<BlobContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public BlobContainerInner update(String resourceGroupName, String accountName, String containerName, PublicAccess publicAccess, Map<String, String> metadata) {
        return (BlobContainerInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, containerName, publicAccess, metadata).toBlocking().single()).body());
    }

    public ServiceFuture<BlobContainerInner> updateAsync(String resourceGroupName, String accountName, String containerName, PublicAccess publicAccess, Map<String, String> metadata, ServiceCallback<BlobContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, containerName, publicAccess, metadata), serviceCallback);
    }

    public Observable<BlobContainerInner> updateAsync(String resourceGroupName, String accountName, String containerName, PublicAccess publicAccess, Map<String, String> metadata) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, containerName, publicAccess, metadata).map((Func1)new Func1<ServiceResponse<BlobContainerInner>, BlobContainerInner>(){

            public BlobContainerInner call(ServiceResponse<BlobContainerInner> response) {
                return (BlobContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BlobContainerInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, PublicAccess publicAccess, Map<String, String> metadata) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(metadata);
        BlobContainerInner blobContainer = new BlobContainerInner();
        blobContainer.withPublicAccess(publicAccess);
        blobContainer.withMetadata(metadata);
        return this.service.update(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), blobContainer, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BlobContainerInner>>>(){

            public Observable<ServiceResponse<BlobContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BlobContainerInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BlobContainerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BlobContainerInner get(String resourceGroupName, String accountName, String containerName) {
        return (BlobContainerInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, containerName).toBlocking().single()).body());
    }

    public ServiceFuture<BlobContainerInner> getAsync(String resourceGroupName, String accountName, String containerName, ServiceCallback<BlobContainerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, containerName), serviceCallback);
    }

    public Observable<BlobContainerInner> getAsync(String resourceGroupName, String accountName, String containerName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, containerName).map((Func1)new Func1<ServiceResponse<BlobContainerInner>, BlobContainerInner>(){

            public BlobContainerInner call(ServiceResponse<BlobContainerInner> response) {
                return (BlobContainerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BlobContainerInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BlobContainerInner>>>(){

            public Observable<ServiceResponse<BlobContainerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BlobContainerInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BlobContainerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName, String containerName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, containerName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String containerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, containerName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String containerName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, containerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LegalHoldInner setLegalHold(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        return (LegalHoldInner)((ServiceResponse)this.setLegalHoldWithServiceResponseAsync(resourceGroupName, accountName, containerName, tags).toBlocking().single()).body();
    }

    public ServiceFuture<LegalHoldInner> setLegalHoldAsync(String resourceGroupName, String accountName, String containerName, List<String> tags, ServiceCallback<LegalHoldInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setLegalHoldWithServiceResponseAsync(resourceGroupName, accountName, containerName, tags), serviceCallback);
    }

    public Observable<LegalHoldInner> setLegalHoldAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        return this.setLegalHoldWithServiceResponseAsync(resourceGroupName, accountName, containerName, tags).map((Func1)new Func1<ServiceResponse<LegalHoldInner>, LegalHoldInner>(){

            public LegalHoldInner call(ServiceResponse<LegalHoldInner> response) {
                return (LegalHoldInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LegalHoldInner>> setLegalHoldWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (tags == null) {
            throw new IllegalArgumentException("Parameter tags is required and cannot be null.");
        }
        Validator.validate(tags);
        LegalHoldInner legalHold = new LegalHoldInner();
        legalHold.withTags(tags);
        return this.service.setLegalHold(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), legalHold, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LegalHoldInner>>>(){

            public Observable<ServiceResponse<LegalHoldInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.setLegalHoldDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LegalHoldInner> setLegalHoldDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LegalHoldInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public LegalHoldInner clearLegalHold(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        return (LegalHoldInner)((ServiceResponse)this.clearLegalHoldWithServiceResponseAsync(resourceGroupName, accountName, containerName, tags).toBlocking().single()).body();
    }

    public ServiceFuture<LegalHoldInner> clearLegalHoldAsync(String resourceGroupName, String accountName, String containerName, List<String> tags, ServiceCallback<LegalHoldInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.clearLegalHoldWithServiceResponseAsync(resourceGroupName, accountName, containerName, tags), serviceCallback);
    }

    public Observable<LegalHoldInner> clearLegalHoldAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        return this.clearLegalHoldWithServiceResponseAsync(resourceGroupName, accountName, containerName, tags).map((Func1)new Func1<ServiceResponse<LegalHoldInner>, LegalHoldInner>(){

            public LegalHoldInner call(ServiceResponse<LegalHoldInner> response) {
                return (LegalHoldInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<LegalHoldInner>> clearLegalHoldWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (tags == null) {
            throw new IllegalArgumentException("Parameter tags is required and cannot be null.");
        }
        Validator.validate(tags);
        LegalHoldInner legalHold = new LegalHoldInner();
        legalHold.withTags(tags);
        return this.service.clearLegalHold(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), legalHold, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<LegalHoldInner>>>(){

            public Observable<ServiceResponse<LegalHoldInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobContainersInner.this.clearLegalHoldDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<LegalHoldInner> clearLegalHoldDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<LegalHoldInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ImmutabilityPolicyInner createOrUpdateImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, int immutabilityPeriodSinceCreationInDays) {
        return (ImmutabilityPolicyInner)((Object)((ServiceResponseWithHeaders)this.createOrUpdateImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, immutabilityPeriodSinceCreationInDays).toBlocking().single()).body());
    }

    public ServiceFuture<ImmutabilityPolicyInner> createOrUpdateImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, int immutabilityPeriodSinceCreationInDays, ServiceCallback<ImmutabilityPolicyInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.createOrUpdateImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, immutabilityPeriodSinceCreationInDays), serviceCallback);
    }

    public Observable<ImmutabilityPolicyInner> createOrUpdateImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, int immutabilityPeriodSinceCreationInDays) {
        return this.createOrUpdateImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, immutabilityPeriodSinceCreationInDays).map((Func1)new Func1<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders>, ImmutabilityPolicyInner>(){

            public ImmutabilityPolicyInner call(ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders> response) {
                return (ImmutabilityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders>> createOrUpdateImmutabilityPolicyWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, int immutabilityPeriodSinceCreationInDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String immutabilityPolicyName = "default";
        String ifMatch = null;
        ImmutabilityPolicyInner parameters = new ImmutabilityPolicyInner();
        parameters.withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
        return this.service.createOrUpdateImmutabilityPolicy(resourceGroupName, accountName, containerName, "default", this.client.subscriptionId(), this.client.apiVersion(), ifMatch, this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = BlobContainersInner.this.createOrUpdateImmutabilityPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ImmutabilityPolicyInner createOrUpdateImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, int immutabilityPeriodSinceCreationInDays, String ifMatch) {
        return (ImmutabilityPolicyInner)((Object)((ServiceResponseWithHeaders)this.createOrUpdateImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, immutabilityPeriodSinceCreationInDays, ifMatch).toBlocking().single()).body());
    }

    public ServiceFuture<ImmutabilityPolicyInner> createOrUpdateImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, int immutabilityPeriodSinceCreationInDays, String ifMatch, ServiceCallback<ImmutabilityPolicyInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.createOrUpdateImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, immutabilityPeriodSinceCreationInDays, ifMatch), serviceCallback);
    }

    public Observable<ImmutabilityPolicyInner> createOrUpdateImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, int immutabilityPeriodSinceCreationInDays, String ifMatch) {
        return this.createOrUpdateImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, immutabilityPeriodSinceCreationInDays, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders>, ImmutabilityPolicyInner>(){

            public ImmutabilityPolicyInner call(ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders> response) {
                return (ImmutabilityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders>> createOrUpdateImmutabilityPolicyWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, int immutabilityPeriodSinceCreationInDays, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String immutabilityPolicyName = "default";
        ImmutabilityPolicyInner parameters = new ImmutabilityPolicyInner();
        parameters.withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
        return this.service.createOrUpdateImmutabilityPolicy(resourceGroupName, accountName, containerName, "default", this.client.subscriptionId(), this.client.apiVersion(), ifMatch, this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = BlobContainersInner.this.createOrUpdateImmutabilityPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders> createOrUpdateImmutabilityPolicyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImmutabilityPolicyInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, BlobContainersCreateOrUpdateImmutabilityPolicyHeaders.class);
    }

    public ImmutabilityPolicyInner getImmutabilityPolicy(String resourceGroupName, String accountName, String containerName) {
        return (ImmutabilityPolicyInner)((Object)((ServiceResponseWithHeaders)this.getImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName).toBlocking().single()).body());
    }

    public ServiceFuture<ImmutabilityPolicyInner> getImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, ServiceCallback<ImmutabilityPolicyInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName), serviceCallback);
    }

    public Observable<ImmutabilityPolicyInner> getImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName) {
        return this.getImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName).map((Func1)new Func1<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders>, ImmutabilityPolicyInner>(){

            public ImmutabilityPolicyInner call(ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders> response) {
                return (ImmutabilityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders>> getImmutabilityPolicyWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String immutabilityPolicyName = "default";
        String ifMatch = null;
        return this.service.getImmutabilityPolicy(resourceGroupName, accountName, containerName, "default", this.client.subscriptionId(), this.client.apiVersion(), ifMatch, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = BlobContainersInner.this.getImmutabilityPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ImmutabilityPolicyInner getImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return (ImmutabilityPolicyInner)((Object)((ServiceResponseWithHeaders)this.getImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch).toBlocking().single()).body());
    }

    public ServiceFuture<ImmutabilityPolicyInner> getImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, ServiceCallback<ImmutabilityPolicyInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch), serviceCallback);
    }

    public Observable<ImmutabilityPolicyInner> getImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return this.getImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders>, ImmutabilityPolicyInner>(){

            public ImmutabilityPolicyInner call(ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders> response) {
                return (ImmutabilityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders>> getImmutabilityPolicyWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String immutabilityPolicyName = "default";
        return this.service.getImmutabilityPolicy(resourceGroupName, accountName, containerName, "default", this.client.subscriptionId(), this.client.apiVersion(), ifMatch, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = BlobContainersInner.this.getImmutabilityPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersGetImmutabilityPolicyHeaders> getImmutabilityPolicyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImmutabilityPolicyInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, BlobContainersGetImmutabilityPolicyHeaders.class);
    }

    public ImmutabilityPolicyInner deleteImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return (ImmutabilityPolicyInner)((Object)((ServiceResponseWithHeaders)this.deleteImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch).toBlocking().single()).body());
    }

    public ServiceFuture<ImmutabilityPolicyInner> deleteImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, ServiceCallback<ImmutabilityPolicyInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch), serviceCallback);
    }

    public Observable<ImmutabilityPolicyInner> deleteImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return this.deleteImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersDeleteImmutabilityPolicyHeaders>, ImmutabilityPolicyInner>(){

            public ImmutabilityPolicyInner call(ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersDeleteImmutabilityPolicyHeaders> response) {
                return (ImmutabilityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersDeleteImmutabilityPolicyHeaders>> deleteImmutabilityPolicyWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (ifMatch == null) {
            throw new IllegalArgumentException("Parameter ifMatch is required and cannot be null.");
        }
        String immutabilityPolicyName = "default";
        return this.service.deleteImmutabilityPolicy(resourceGroupName, accountName, containerName, "default", this.client.subscriptionId(), this.client.apiVersion(), ifMatch, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersDeleteImmutabilityPolicyHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersDeleteImmutabilityPolicyHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = BlobContainersInner.this.deleteImmutabilityPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersDeleteImmutabilityPolicyHeaders> deleteImmutabilityPolicyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImmutabilityPolicyInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, BlobContainersDeleteImmutabilityPolicyHeaders.class);
    }

    public ImmutabilityPolicyInner lockImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return (ImmutabilityPolicyInner)((Object)((ServiceResponseWithHeaders)this.lockImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch).toBlocking().single()).body());
    }

    public ServiceFuture<ImmutabilityPolicyInner> lockImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, ServiceCallback<ImmutabilityPolicyInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.lockImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch), serviceCallback);
    }

    public Observable<ImmutabilityPolicyInner> lockImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return this.lockImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch).map((Func1)new Func1<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersLockImmutabilityPolicyHeaders>, ImmutabilityPolicyInner>(){

            public ImmutabilityPolicyInner call(ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersLockImmutabilityPolicyHeaders> response) {
                return (ImmutabilityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersLockImmutabilityPolicyHeaders>> lockImmutabilityPolicyWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (ifMatch == null) {
            throw new IllegalArgumentException("Parameter ifMatch is required and cannot be null.");
        }
        return this.service.lockImmutabilityPolicy(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), ifMatch, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersLockImmutabilityPolicyHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersLockImmutabilityPolicyHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = BlobContainersInner.this.lockImmutabilityPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersLockImmutabilityPolicyHeaders> lockImmutabilityPolicyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImmutabilityPolicyInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, BlobContainersLockImmutabilityPolicyHeaders.class);
    }

    public ImmutabilityPolicyInner extendImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, String ifMatch, int immutabilityPeriodSinceCreationInDays) {
        return (ImmutabilityPolicyInner)((Object)((ServiceResponseWithHeaders)this.extendImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays).toBlocking().single()).body());
    }

    public ServiceFuture<ImmutabilityPolicyInner> extendImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, int immutabilityPeriodSinceCreationInDays, ServiceCallback<ImmutabilityPolicyInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.extendImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays), serviceCallback);
    }

    public Observable<ImmutabilityPolicyInner> extendImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, int immutabilityPeriodSinceCreationInDays) {
        return this.extendImmutabilityPolicyWithServiceResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays).map((Func1)new Func1<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersExtendImmutabilityPolicyHeaders>, ImmutabilityPolicyInner>(){

            public ImmutabilityPolicyInner call(ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersExtendImmutabilityPolicyHeaders> response) {
                return (ImmutabilityPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersExtendImmutabilityPolicyHeaders>> extendImmutabilityPolicyWithServiceResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, int immutabilityPeriodSinceCreationInDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (ifMatch == null) {
            throw new IllegalArgumentException("Parameter ifMatch is required and cannot be null.");
        }
        ImmutabilityPolicyInner parameters = new ImmutabilityPolicyInner();
        parameters.withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
        return this.service.extendImmutabilityPolicy(resourceGroupName, accountName, containerName, this.client.subscriptionId(), this.client.apiVersion(), ifMatch, this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersExtendImmutabilityPolicyHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersExtendImmutabilityPolicyHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = BlobContainersInner.this.extendImmutabilityPolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<ImmutabilityPolicyInner, BlobContainersExtendImmutabilityPolicyHeaders> extendImmutabilityPolicyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImmutabilityPolicyInner>(){}.getType()).registerError(CloudException.class).buildWithHeaders(response, BlobContainersExtendImmutabilityPolicyHeaders.class);
    }

    static interface BlobContainersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body BlobContainerInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body BlobContainerInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers setLegalHold"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/setLegalHold")
        public Observable<Response<ResponseBody>> setLegalHold(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body LegalHoldInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers clearLegalHold"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/clearLegalHold")
        public Observable<Response<ResponseBody>> clearLegalHold(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body LegalHoldInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers createOrUpdateImmutabilityPolicy"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdateImmutabilityPolicy(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="immutabilityPolicyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="If-Match") String var7, @Header(value="accept-language") String var8, @Body ImmutabilityPolicyInner var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers getImmutabilityPolicy"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}")
        public Observable<Response<ResponseBody>> getImmutabilityPolicy(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="immutabilityPolicyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="If-Match") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers deleteImmutabilityPolicy"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteImmutabilityPolicy(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="immutabilityPolicyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="If-Match") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers lockImmutabilityPolicy"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/lock")
        public Observable<Response<ResponseBody>> lockImmutabilityPolicy(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="If-Match") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobContainers extendImmutabilityPolicy"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/extend")
        public Observable<Response<ResponseBody>> extendImmutabilityPolicy(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="containerName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="If-Match") String var6, @Header(value="accept-language") String var7, @Body ImmutabilityPolicyInner var8, @Header(value="User-Agent") String var9);
    }
}

