/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.utils;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.OMS;
import io.openmessaging.producer.SendResult;
import io.openmessaging.rocketmq.domain.BytesMessageImpl;
import io.openmessaging.rocketmq.domain.SendResultImpl;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;

public class OMSUtil {
    public static String buildInstanceName() {
        return Integer.toString(UtilAll.getPid()) + "%OpenMessaging%" + System.nanoTime();
    }

    public static Message msgConvert(BytesMessage omsMessage) {
        long deliverTime;
        Message rmqMessage = new Message();
        rmqMessage.setBody((byte[])omsMessage.getBody(byte[].class));
        KeyValue sysHeaders = omsMessage.sysHeaders();
        KeyValue userHeaders = omsMessage.userHeaders();
        rmqMessage.setTopic(sysHeaders.getString("DESTINATION"));
        if (sysHeaders.containsKey("START_TIME") && (deliverTime = sysHeaders.getLong("START_TIME", 0L)) > 0L) {
            rmqMessage.putUserProperty("__STARTDELIVERTIME", String.valueOf(deliverTime));
        }
        for (String key : userHeaders.keySet()) {
            MessageAccessor.putProperty((Message)rmqMessage, (String)key, (String)userHeaders.getString(key));
        }
        for (String key : sysHeaders.keySet()) {
            MessageAccessor.putProperty((Message)rmqMessage, (String)key, (String)sysHeaders.getString(key));
        }
        return rmqMessage;
    }

    public static BytesMessage msgConvert(MessageExt rmqMsg) {
        BytesMessageImpl omsMsg = new BytesMessageImpl();
        omsMsg.setBody(rmqMsg.getBody());
        KeyValue headers = omsMsg.sysHeaders();
        KeyValue properties = omsMsg.userHeaders();
        Set entries = rmqMsg.getProperties().entrySet();
        for (Map.Entry entry : entries) {
            if (OMSUtil.isOMSHeader((String)entry.getKey())) {
                headers.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            properties.put((String)entry.getKey(), (String)entry.getValue());
        }
        omsMsg.putSysHeaders("MESSAGE_ID", rmqMsg.getMsgId());
        omsMsg.putSysHeaders("DESTINATION", rmqMsg.getTopic());
        omsMsg.putSysHeaders("SEARCH_KEYS", rmqMsg.getKeys());
        omsMsg.putSysHeaders("BORN_HOST", String.valueOf(rmqMsg.getBornHost()));
        omsMsg.putSysHeaders("BORN_TIMESTAMP", rmqMsg.getBornTimestamp());
        omsMsg.putSysHeaders("STORE_HOST", String.valueOf(rmqMsg.getStoreHost()));
        omsMsg.putSysHeaders("STORE_TIMESTAMP", rmqMsg.getStoreTimestamp());
        return omsMsg;
    }

    public static boolean isOMSHeader(String value) {
        for (Field field : Message.BuiltinKeys.class.getDeclaredFields()) {
            try {
                if (!field.get(Message.BuiltinKeys.class).equals(value)) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return false;
    }

    public static SendResult sendResultConvert(org.apache.rocketmq.client.producer.SendResult rmqResult) {
        assert (rmqResult.getSendStatus().equals((Object)SendStatus.SEND_OK));
        return new SendResultImpl(rmqResult.getMsgId(), OMS.newKeyValue());
    }

    public static KeyValue buildKeyValue(KeyValue ... keyValues) {
        KeyValue keyValue = OMS.newKeyValue();
        for (KeyValue properties : keyValues) {
            for (String key : properties.keySet()) {
                keyValue.put(key, properties.getString(key));
            }
        }
        return keyValue;
    }

    public static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        return new Iterator<T>(){
            Iterator<T> iterator = new Iterator<T>(){

                @Override
                public synchronized boolean hasNext() {
                    return false;
                }

                @Override
                public synchronized T next() {
                    throw new NoSuchElementException();
                }

                @Override
                public synchronized void remove() {
                }
            };

            @Override
            public synchronized boolean hasNext() {
                return this.iterator.hasNext() || iterable.iterator().hasNext();
            }

            @Override
            public synchronized T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                    if (!this.iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                return this.iterator.next();
            }

            @Override
            public synchronized void remove() {
                this.iterator.remove();
            }
        };
    }
}

