/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.transaction;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.client.ProducerManager;
import org.apache.rocketmq.client.impl.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.thread.ThreadPoolMonitor;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.route.MessageQueueView;
import org.apache.rocketmq.proxy.service.route.TopicRouteService;
import org.apache.rocketmq.proxy.service.transaction.AbstractTransactionService;
import org.apache.rocketmq.remoting.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.remoting.protocol.heartbeat.ProducerData;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;

public class ClusterTransactionService
extends AbstractTransactionService {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private static final String TRANS_HEARTBEAT_CLIENT_ID = "rmq-proxy-producer-client";
    private final MQClientAPIFactory mqClientAPIFactory;
    private final TopicRouteService topicRouteService;
    private final ProducerManager producerManager;
    private ThreadPoolExecutor heartbeatExecutors;
    private final Map<String, Set<ClusterData>> groupClusterData = new ConcurrentHashMap<String, Set<ClusterData>>();
    private final AtomicReference<Map<String, String>> brokerAddrNameMapRef = new AtomicReference();
    private TxHeartbeatServiceThread txHeartbeatServiceThread;

    public ClusterTransactionService(TopicRouteService topicRouteService, ProducerManager producerManager, MQClientAPIFactory mqClientAPIFactory) {
        this.topicRouteService = topicRouteService;
        this.producerManager = producerManager;
        this.mqClientAPIFactory = mqClientAPIFactory;
    }

    @Override
    public void addTransactionSubscription(String group, List<String> topicList) {
        for (String topic : topicList) {
            this.addTransactionSubscription(group, topic);
        }
    }

    @Override
    public void addTransactionSubscription(String group, String topic) {
        try {
            this.groupClusterData.compute(group, (groupName, clusterDataSet) -> {
                if (clusterDataSet == null) {
                    clusterDataSet = Sets.newHashSet();
                }
                clusterDataSet.addAll(this.getClusterDataFromTopic(topic));
                return clusterDataSet;
            });
        }
        catch (Exception e) {
            log.error("add producer group err in txHeartBeat. groupId: {}, err: {}", (Object)group, (Object)e);
        }
    }

    @Override
    public void replaceTransactionSubscription(String group, List<String> topicList) {
        HashSet<ClusterData> clusterDataSet = new HashSet<ClusterData>();
        for (String topic : topicList) {
            clusterDataSet.addAll(this.getClusterDataFromTopic(topic));
        }
        this.groupClusterData.put(group, clusterDataSet);
    }

    private Set<ClusterData> getClusterDataFromTopic(String topic) {
        try {
            MessageQueueView messageQueue = this.topicRouteService.getAllMessageQueueView(topic);
            List brokerDataList = messageQueue.getTopicRouteData().getBrokerDatas();
            if (brokerDataList == null) {
                return Collections.emptySet();
            }
            HashSet res = Sets.newHashSet();
            for (BrokerData brokerData : brokerDataList) {
                res.add(new ClusterData(brokerData.getCluster()));
            }
            return res;
        }
        catch (Throwable t) {
            log.error("get cluster data failed in txHeartBeat. topic: {}, err: {}", (Object)topic, (Object)t);
            return Collections.emptySet();
        }
    }

    @Override
    public void unSubscribeAllTransactionTopic(String group) {
        this.groupClusterData.remove(group);
    }

    public void scanProducerHeartBeat() {
        Set<String> groupSet = this.groupClusterData.keySet();
        HashMap clusterHeartbeatData = new HashMap();
        for (String group : groupSet) {
            this.groupClusterData.computeIfPresent(group, (groupName, clusterDataSet) -> {
                if (clusterDataSet.isEmpty()) {
                    return null;
                }
                if (!this.producerManager.groupOnline(groupName)) {
                    return null;
                }
                ProducerData producerData = new ProducerData();
                producerData.setGroupName(groupName);
                for (ClusterData clusterData : clusterDataSet) {
                    HeartbeatData heartbeatData;
                    ArrayList<HeartbeatData> heartbeatDataList = (ArrayList<HeartbeatData>)clusterHeartbeatData.get(clusterData.cluster);
                    if (heartbeatDataList == null) {
                        heartbeatDataList = new ArrayList<HeartbeatData>();
                    }
                    if (heartbeatDataList.isEmpty()) {
                        heartbeatData = new HeartbeatData();
                        heartbeatData.setClientID(TRANS_HEARTBEAT_CLIENT_ID);
                        heartbeatDataList.add(heartbeatData);
                    } else {
                        heartbeatData = (HeartbeatData)heartbeatDataList.get(heartbeatDataList.size() - 1);
                        if (heartbeatData.getProducerDataSet().size() >= ConfigurationManager.getProxyConfig().getTransactionHeartbeatBatchNum()) {
                            heartbeatData = new HeartbeatData();
                            heartbeatData.setClientID(TRANS_HEARTBEAT_CLIENT_ID);
                            heartbeatDataList.add(heartbeatData);
                        }
                    }
                    heartbeatData.getProducerDataSet().add(producerData);
                    clusterHeartbeatData.put(clusterData.cluster, heartbeatDataList);
                }
                if (clusterDataSet.isEmpty()) {
                    return null;
                }
                return clusterDataSet;
            });
        }
        if (clusterHeartbeatData.isEmpty()) {
            return;
        }
        ConcurrentHashMap<String, String> brokerAddrNameMap = new ConcurrentHashMap<String, String>();
        Set clusterEntry = clusterHeartbeatData.entrySet();
        for (Map.Entry entry : clusterEntry) {
            this.sendHeartBeatToCluster((String)entry.getKey(), (List)entry.getValue(), brokerAddrNameMap);
        }
        this.brokerAddrNameMapRef.set(brokerAddrNameMap);
    }

    public Map<String, Set<ClusterData>> getGroupClusterData() {
        return this.groupClusterData;
    }

    protected void sendHeartBeatToCluster(String clusterName, List<HeartbeatData> heartbeatDataList, Map<String, String> brokerAddrNameMap) {
        if (heartbeatDataList == null) {
            return;
        }
        for (HeartbeatData heartbeatData : heartbeatDataList) {
            this.sendHeartBeatToCluster(clusterName, heartbeatData, brokerAddrNameMap);
        }
        this.brokerAddrNameMapRef.set(brokerAddrNameMap);
    }

    protected void sendHeartBeatToCluster(String clusterName, HeartbeatData heartbeatData, Map<String, String> brokerAddrNameMap) {
        try {
            MessageQueueView messageQueue = this.topicRouteService.getAllMessageQueueView(clusterName);
            List brokerDataList = messageQueue.getTopicRouteData().getBrokerDatas();
            if (brokerDataList == null) {
                return;
            }
            for (BrokerData brokerData : brokerDataList) {
                brokerAddrNameMap.put(brokerData.selectBrokerAddr(), brokerData.getBrokerName());
                this.heartbeatExecutors.submit(() -> {
                    String brokerAddr = brokerData.selectBrokerAddr();
                    this.mqClientAPIFactory.getClient().sendHeartbeatOneway(brokerAddr, heartbeatData, Duration.ofSeconds(3L).toMillis()).exceptionally(t -> {
                        log.error("Send transactionHeartbeat to broker err. brokerAddr: {}", (Object)brokerAddr, t);
                        return null;
                    });
                });
            }
        }
        catch (Exception e) {
            log.error("get broker add in cluster failed in tx. clusterName: {}", (Object)clusterName, (Object)e);
        }
    }

    @Override
    protected String getBrokerNameByAddr(String brokerAddr) {
        if (StringUtils.isBlank((CharSequence)brokerAddr)) {
            return null;
        }
        return this.brokerAddrNameMapRef.get().get(brokerAddr);
    }

    @Override
    public void start() throws Exception {
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        this.txHeartbeatServiceThread = new TxHeartbeatServiceThread();
        super.start();
        this.txHeartbeatServiceThread.start();
        this.heartbeatExecutors = ThreadPoolMonitor.createAndMonitor((int)proxyConfig.getTransactionHeartbeatThreadPoolNums(), (int)proxyConfig.getTransactionHeartbeatThreadPoolNums(), (long)0L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"TransactionHeartbeatRegisterThread", (int)proxyConfig.getTransactionHeartbeatThreadPoolQueueCapacity());
    }

    @Override
    public void shutdown() throws Exception {
        this.txHeartbeatServiceThread.shutdown();
        this.heartbeatExecutors.shutdown();
        super.shutdown();
    }

    class TxHeartbeatServiceThread
    extends ServiceThread {
        TxHeartbeatServiceThread() {
        }

        public String getServiceName() {
            return TxHeartbeatServiceThread.class.getName();
        }

        public void run() {
            while (!this.isStopped()) {
                this.waitForRunning(TimeUnit.SECONDS.toMillis(ConfigurationManager.getProxyConfig().getTransactionHeartbeatPeriodSecond()));
            }
        }

        protected void onWaitEnd() {
            ClusterTransactionService.this.scanProducerHeartBeat();
        }
    }

    static class ClusterData {
        private final String cluster;

        public ClusterData(String cluster) {
            this.cluster = cluster;
        }

        public String getCluster() {
            return this.cluster;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClusterData)) {
                return super.equals(obj);
            }
            ClusterData other = (ClusterData)obj;
            return this.cluster.equals(other.cluster);
        }

        public int hashCode() {
            return this.cluster.hashCode();
        }
    }
}

