/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.FileOutputSignalHandler;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDescribeSignalHandler
extends FileOutputSignalHandler {
    private static Logger LOG = LoggerFactory.getLogger(NodeDescribeSignalHandler.class);
    private static final String DIR = SystemPropertyUtil.get("jraft.signal.node.describe.dir", "");
    private static final String BASE_NAME = "node_describe.log";

    @Override
    public void handle(String signalName) {
        List<Node> nodes = NodeManager.getInstance().getAllNodes();
        if (nodes.isEmpty()) {
            return;
        }
        try {
            File file = this.getOutputFile(DIR, BASE_NAME);
            LOG.info("Describing raft nodes with signal: {} to file: {}.", (Object)signalName, (Object)file);
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));){
                Describer.DefaultPrinter printer = new Describer.DefaultPrinter(out);
                for (Node node : nodes) {
                    node.describe(printer);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Fail to describe nodes: {}.", nodes, (Object)e);
        }
    }
}

