/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.raft;

import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.RaftServiceFactory;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.CliServiceImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.Task;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.InvokeCallback;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.rpc.impl.GrpcRaftRpcFactory;
import com.alipay.sofa.jraft.rpc.impl.MarshallerRegistry;
import com.alipay.sofa.jraft.rpc.impl.cli.CliClientServiceImpl;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.meta.RaftUtil;
import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.common.model.consistency.WriteRequest;
import org.apache.rocketmq.mqtt.meta.config.MetaConf;
import org.apache.rocketmq.mqtt.meta.raft.FailoverClosure;
import org.apache.rocketmq.mqtt.meta.raft.MqttClosure;
import org.apache.rocketmq.mqtt.meta.raft.MqttStateMachine;
import org.apache.rocketmq.mqtt.meta.raft.processor.RetainedMsgStateProcessor;
import org.apache.rocketmq.mqtt.meta.raft.processor.StateProcessor;
import org.apache.rocketmq.mqtt.meta.raft.processor.WillMsgStateProcessor;
import org.apache.rocketmq.mqtt.meta.raft.rpc.MqttReadRpcProcessor;
import org.apache.rocketmq.mqtt.meta.raft.rpc.MqttWriteRpcProcessor;
import org.apache.rocketmq.mqtt.meta.rocksdb.RocksDBEngine;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MqttRaftServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttRaftServer.class);
    @Resource
    private MetaConf metaConf;
    private static ExecutorService raftExecutor;
    private static ExecutorService requestExecutor;
    private static ScheduledExecutorService scheduler;
    private PeerId localPeerId;
    private RpcServer rpcServer;
    private CliClientServiceImpl cliClientService;
    private CliService cliService;
    private Map<String, StateProcessor> stateProcessors = new ConcurrentHashMap<String, StateProcessor>();
    private Map<String, MqttStateMachine> bizStateMachineMap = new ConcurrentHashMap<String, MqttStateMachine>();
    public String[] raftGroups;
    private RouteTable rt;

    @PostConstruct
    void init() throws IOException, RocksDBException {
        raftExecutor = new ThreadPoolExecutor(8, 16, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10000), (ThreadFactory)new ThreadFactoryImpl("RaftExecutor_"));
        requestExecutor = new ThreadPoolExecutor(8, 16, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10000), (ThreadFactory)new ThreadFactoryImpl("requestExecutor_"));
        this.registerStateProcessor(new RetainedMsgStateProcessor(this, this.metaConf.getMaxRetainedTopicNum()));
        this.registerStateProcessor(new WillMsgStateProcessor(this));
        this.rt = RouteTable.getInstance();
        this.localPeerId = PeerId.parsePeer((String)this.metaConf.getSelfAddress());
        this.rpcServer = this.createRpcServer(this, this.localPeerId);
        NodeManager.getInstance().addAddress(this.localPeerId.getEndpoint());
        if (!this.rpcServer.init(null)) {
            LOGGER.error("Fail to init [BaseRpcServer].");
            throw new RuntimeException("Fail to init [BaseRpcServer].");
        }
        for (String group : this.raftGroups = RaftUtil.LIST_RAFT_GROUPS()) {
            String rdbPath = RaftUtil.RAFT_BASE_DIR((String)group) + File.separator + "rdb";
            FileUtils.forceMkdir((File)new File(rdbPath));
            RocksDBEngine rocksDBEngine = new RocksDBEngine(rdbPath);
            rocksDBEngine.init();
            MqttStateMachine sm = new MqttStateMachine(this);
            sm.setRocksDBEngine(rocksDBEngine);
            this.createRaftNode(group, sm);
        }
        scheduler.scheduleAtFixedRate(() -> this.refreshLeader(), 3L, 3L, TimeUnit.SECONDS);
        CliOptions cliOptions = new CliOptions();
        this.cliService = RaftServiceFactory.createAndInitCliService((CliOptions)cliOptions);
        this.cliClientService = (CliClientServiceImpl)((CliServiceImpl)this.cliService).getCliClientService();
    }

    private void refreshLeader() {
        for (String groupId : this.raftGroups) {
            try {
                this.rt.refreshLeader((CliClientService)this.cliClientService, groupId, 1000);
            }
            catch (Exception e) {
                LOGGER.error("refreshLeader failed {}", (Object)groupId, (Object)e);
            }
        }
    }

    public Node createRaftNode(String groupId, MqttStateMachine sm) throws IOException {
        if (StringUtils.isBlank((CharSequence)groupId) || sm == null) {
            throw new IllegalArgumentException("groupId or sm is null");
        }
        String dataPath = RaftUtil.RAFT_BASE_DIR((String)groupId);
        FileUtils.forceMkdir((File)new File(dataPath));
        NodeOptions nodeOptions = new NodeOptions();
        nodeOptions.setElectionTimeoutMs(this.metaConf.getElectionTimeoutMs());
        nodeOptions.setDisableCli(false);
        nodeOptions.setSnapshotIntervalSecs(this.metaConf.getSnapshotIntervalSecs());
        Configuration initConf = new Configuration();
        String initConfStr = this.metaConf.getMembersAddress();
        if (!initConf.parse(initConfStr)) {
            throw new IllegalArgumentException("Fail to parse initConf:" + initConfStr);
        }
        this.rt.updateConfiguration(groupId, initConfStr);
        nodeOptions.setInitialConf(initConf);
        nodeOptions.setFsm((StateMachine)sm);
        nodeOptions.setLogUri(dataPath + File.separator + "log");
        nodeOptions.setRaftMetaUri(dataPath + File.separator + "raft_meta");
        nodeOptions.setSnapshotUri(dataPath + File.separator + "snapshot");
        Node node = RaftServiceFactory.createAndInitRaftNode((String)groupId, (PeerId)this.localPeerId, (NodeOptions)nodeOptions);
        sm.setNode(node);
        this.registerBizStateMachine(groupId, sm);
        LOGGER.warn("createdRaftNode {}", (Object)groupId);
        return node;
    }

    private void registerBizStateMachine(String groupId, MqttStateMachine sm) {
        MqttStateMachine prv = this.bizStateMachineMap.putIfAbsent(groupId, sm);
        if (prv != null) {
            throw new RuntimeException("dup register BizStateMachine:" + groupId);
        }
    }

    public Node getNode(String groupId) {
        return this.bizStateMachineMap.get(groupId).getNode();
    }

    public MqttStateMachine getMqttStateMachine(String groupId) {
        return this.bizStateMachineMap.get(groupId);
    }

    public RpcServer createRpcServer(MqttRaftServer server, PeerId peerId) {
        GrpcRaftRpcFactory raftRpcFactory = (GrpcRaftRpcFactory)RpcFactoryHelper.rpcFactory();
        raftRpcFactory.registerProtobufSerializer(WriteRequest.class.getName(), new Object[]{WriteRequest.getDefaultInstance()});
        raftRpcFactory.registerProtobufSerializer(ReadRequest.class.getName(), new Object[]{ReadRequest.getDefaultInstance()});
        raftRpcFactory.registerProtobufSerializer(Response.class.getName(), new Object[]{Response.getDefaultInstance()});
        MarshallerRegistry registry = raftRpcFactory.getMarshallerRegistry();
        registry.registerResponseInstance(WriteRequest.class.getName(), (Message)Response.getDefaultInstance());
        registry.registerResponseInstance(ReadRequest.class.getName(), (Message)Response.getDefaultInstance());
        RpcServer rpcServer = raftRpcFactory.createRpcServer(peerId.getEndpoint());
        RaftRpcServerFactory.addRaftRequestProcessors((RpcServer)rpcServer, (Executor)raftExecutor, (Executor)requestExecutor);
        rpcServer.registerProcessor((RpcProcessor)new MqttWriteRpcProcessor(server));
        rpcServer.registerProcessor((RpcProcessor)new MqttReadRpcProcessor(server));
        return rpcServer;
    }

    public void registerStateProcessor(StateProcessor processor) {
        this.stateProcessors.put(processor.groupCategory(), processor);
    }

    public StateProcessor getProcessor(String category) {
        return this.stateProcessors.get(category);
    }

    public void applyOperation(Node node, Message data, FailoverClosure closure) {
        Task task = new Task();
        MqttClosure mqttClosure = new MqttClosure(data, status -> {
            MqttClosure.MqttStatus mqttStatus = (MqttClosure.MqttStatus)status;
            closure.setThrowable(mqttStatus.getThrowable());
            closure.setResponse(mqttStatus.getResponse());
            closure.run(mqttStatus);
        });
        task.setData(ByteBuffer.wrap(data.toByteArray()));
        task.setDone((Closure)mqttClosure);
        node.apply(task);
    }

    protected PeerId getLeader(String raftGroupId) {
        return this.rt.selectLeader(raftGroupId);
    }

    public void invokeToLeader(String group, Message request, int timeoutMillis, final FailoverClosure closure) {
        try {
            PeerId peerId = this.getLeader(group);
            Endpoint leaderIp = peerId.getEndpoint();
            this.cliClientService.getRpcClient().invokeAsync(leaderIp, (Object)request, new InvokeCallback(){

                public void complete(Object o, Throwable ex) {
                    if (Objects.nonNull(ex)) {
                        closure.setThrowable(ex);
                        closure.run(new Status(RaftError.UNKNOWN, ex.getMessage(), new Object[0]));
                        return;
                    }
                    if (!((Response)o).getSuccess()) {
                        closure.setThrowable(new IllegalStateException(((Response)o).getErrMsg()));
                        closure.run(new Status(RaftError.UNKNOWN, ((Response)o).getErrMsg(), new Object[0]));
                        return;
                    }
                    closure.setResponse((Response)o);
                    closure.run(Status.OK());
                }

                public Executor executor() {
                    return requestExecutor;
                }
            }, (long)timeoutMillis);
        }
        catch (Exception e) {
            closure.setThrowable(e);
            closure.run(new Status(RaftError.UNKNOWN, e.toString(), new Object[0]));
        }
    }

    static {
        scheduler = Executors.newSingleThreadScheduledExecutor();
    }
}

