/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.mxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.royale.compiler.common.PrefixMap;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLTagDataDepth;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLTagDataPayload;
import org.apache.royale.compiler.mxml.IMXMLData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class BalancingMXMLProcessor {
    private ArrayList<MXMLTagDataDepth> depths = new ArrayList();
    private Collection<ICompilerProblem> problems;
    private IFileSpecification spec;
    private boolean wasRepaired = false;

    public BalancingMXMLProcessor(IFileSpecification specification, Collection<ICompilerProblem> problems) {
        this.setFileSpecification(specification);
        this.problems = problems;
    }

    public void initialize(IMXMLUnitData[] data) {
        int index = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] instanceof IMXMLTagData) || ((IMXMLTagData)data[i]).isEmptyTag()) continue;
            if (((IMXMLTagData)data[i]).isOpenTag()) {
                this.addOpenTag((IMXMLTagData)data[i], index);
                ++index;
                continue;
            }
            this.addCloseTag((IMXMLTagData)data[i], --index);
        }
    }

    public final void setFileSpecification(IFileSpecification specification) {
        this.spec = specification;
    }

    public IMXMLUnitData[] balance(IMXMLUnitData[] data, IMXMLData mxmlData, Map<IMXMLTagData, PrefixMap> map) {
        ArrayList<MXMLTagDataPayload> payload = new ArrayList<MXMLTagDataPayload>();
        for (int i = this.depths.size() - 1; i >= 0; --i) {
            boolean b = this.depths.get(i).balance(payload, map, mxmlData, data, this.problems, this.spec);
            if (!b) continue;
            this.wasRepaired = true;
        }
        Collections.sort(payload, Collections.reverseOrder());
        if (payload.size() > 0) {
            this.wasRepaired = true;
            ArrayList<IMXMLUnitData> newTags = new ArrayList<IMXMLUnitData>(Arrays.asList(data));
            for (int i = payload.size() - 1; i >= 0; --i) {
                MXMLTagDataPayload tokenPayload = payload.get(i);
                newTags.add(tokenPayload.getPosition(), tokenPayload.getTagData());
            }
            return newTags.toArray(new IMXMLUnitData[0]);
        }
        return data;
    }

    public boolean wasRepaired() {
        return this.wasRepaired;
    }

    private final MXMLTagDataDepth getDepth(int depth) {
        MXMLTagDataDepth dep = null;
        if (depth < 0) {
            depth *= -1;
        }
        if (this.depths.size() > depth) {
            dep = this.depths.get(depth);
        } else {
            dep = new MXMLTagDataDepth(depth);
            if (depth - 1 >= 0 && depth - 1 < this.depths.size()) {
                dep.setParent(this.depths.get(depth - 1));
            }
            this.depths.add(dep);
        }
        return dep;
    }

    public void addOpenTag(IMXMLTagData openTag, int depth) {
        MXMLTagDataDepth dep = this.getDepth(depth);
        dep.addOpenTag(openTag);
    }

    public void addCloseTag(IMXMLTagData closeTag, int depth) {
        MXMLTagDataDepth dep = this.getDepth(depth);
        dep.addCloseTag(closeTag);
    }
}

