/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.IncludeHandler;
import org.apache.royale.compiler.internal.parsing.as.MetaDataPayloadToken;
import org.apache.royale.compiler.internal.parsing.as.MetadataToken;
import org.apache.royale.compiler.internal.parsing.as.RepairingTokenBuffer;
import org.apache.royale.compiler.internal.parsing.as.StreamingASTokenizer;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLTokenizer;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.parsing.IMXMLToken;
import org.apache.royale.compiler.problems.CompilerProblemSeverity;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.formatter.config.CommandLineConfigurator;
import org.apache.royale.formatter.config.Configuration;
import org.apache.royale.formatter.config.ConfigurationBuffer;
import org.apache.royale.formatter.config.ConfigurationValue;
import org.apache.royale.formatter.config.Configurator;
import org.apache.royale.formatter.config.Semicolons;
import org.apache.royale.utils.FilenameNormalization;

public class FORMATTER {
    private static final int TOKEN_TYPE_EXTRA = 999999;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String DEFAULT_VAR = "files";
    private static final String L10N_CONFIG_PREFIX = "org.apache.royale.compiler.internal.config.configuration";
    private static final Pattern ASDOC_START_LINE_PATTERN = Pattern.compile("^\\*(\\s*)");
    private static final String FORMATTER_TAG_OFF = "@formatter:off";
    private static final String FORMATTER_TAG_ON = "@formatter:on";
    public int tabSize = 4;
    public boolean insertSpaces = false;
    public boolean insertFinalNewLine = false;
    public boolean placeOpenBraceOnNewLine = true;
    public boolean insertSpaceAfterSemicolonInForStatements = true;
    public boolean insertSpaceAfterKeywordsInControlFlowStatements = true;
    public boolean insertSpaceAfterFunctionKeywordForAnonymousFunctions = false;
    public boolean insertSpaceBeforeAndAfterBinaryOperators = true;
    public boolean insertSpaceAfterCommaDelimiter = true;
    public boolean insertSpaceBetweenMetadataAttributes = true;
    public boolean insertSpaceAtStartOfLineComment = true;
    public int maxPreserveNewLines = 2;
    public Semicolons semicolons = Semicolons.INSERT;
    public boolean ignoreProblems = false;
    public boolean collapseEmptyBlocks = false;
    public boolean mxmlAlignAttributes = false;
    public boolean mxmlInsertNewLineBetweenAttributes = false;
    private ProblemQuery problems;
    private List<File> inputFiles = new ArrayList<File>();
    private boolean writeBackToInputFiles = false;
    private boolean listChangedFiles = false;
    private Configuration configuration;
    private ConfigurationBuffer configBuffer;

    public static void main(String[] args) {
        FORMATTER formatter = new FORMATTER();
        int exitCode = formatter.execute(args);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] args) {
        ExitCode exitCode;
        block19: {
            exitCode = ExitCode.SUCCESS;
            this.problems = new ProblemQuery();
            try {
                boolean continueFormatting = this.configure(args);
                if (continueFormatting) {
                    if (this.inputFiles.size() == 0) {
                        String formattedText;
                        StringBuilder builder = new StringBuilder();
                        Scanner sysInScanner = new Scanner(System.in);
                        try {
                            while (sysInScanner.hasNext()) {
                                builder.append(sysInScanner.next());
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)sysInScanner);
                        }
                        String filePath = FilenameNormalization.normalize((String)"stdin.as");
                        String fileText = builder.toString();
                        if (!fileText.equals(formattedText = this.formatFileText(filePath, fileText)) && this.listChangedFiles) {
                            System.out.println(filePath);
                        }
                        if (!this.listChangedFiles) {
                            System.out.println(formattedText);
                        }
                        break block19;
                    }
                    for (File inputFile : this.inputFiles) {
                        String formattedText;
                        String filePath = FilenameNormalization.normalize((String)inputFile.getAbsolutePath());
                        String fileText = FileUtils.readFileToString((File)inputFile, (String)"utf8");
                        if (!fileText.equals(formattedText = this.formatFileText(filePath, fileText))) {
                            if (this.listChangedFiles) {
                                System.out.println(filePath);
                            }
                            if (this.writeBackToInputFiles) {
                                FileUtils.write((File)inputFile, (CharSequence)formattedText, (String)"utf8");
                            }
                        }
                        if (this.listChangedFiles || this.writeBackToInputFiles) continue;
                        System.out.println(formattedText);
                    }
                    break block19;
                }
                exitCode = this.problems.hasFilteredProblems() ? ExitCode.FAILED_WITH_CONFIG_PROBLEMS : ExitCode.PRINT_HELP;
            }
            catch (Exception e) {
                this.problems.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
                System.err.println(e.getMessage());
                exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
            }
            finally {
                if (this.problems.hasFilteredProblems()) {
                    ProblemPrinter printer = new ProblemPrinter(ProblemFormatter.DEFAULT_FORMATTER);
                    printer.printProblems(this.problems.getFilteredProblems());
                }
            }
        }
        return exitCode.code;
    }

    public String formatFile(File file, Collection<ICompilerProblem> problems) throws IOException {
        String fileText = FileUtils.readFileToString((File)file, (String)"utf8");
        String filePath = file.getAbsolutePath();
        return this.formatFileText(filePath, fileText, problems);
    }

    public String formatFile(File file) throws IOException {
        return this.formatFile(file, null);
    }

    public String formatFileText(String filePath, String text, Collection<ICompilerProblem> problems) {
        filePath = FilenameNormalization.normalize((String)filePath);
        String result = null;
        result = filePath.endsWith(".mxml") ? this.formatMXMLTextInternal(filePath, text, problems) : this.formatAS3TextInternal(filePath, text, problems);
        if (this.insertFinalNewLine && result.charAt(result.length() - 1) != '\n') {
            return result + '\n';
        }
        return result;
    }

    public String formatFileText(String filePath, String text) {
        return this.formatFileText(filePath, text, null);
    }

    public String formatActionScriptText(String text, Collection<ICompilerProblem> problems) {
        String filePath = FilenameNormalization.normalize((String)"stdin.as");
        return this.formatAS3TextInternal(filePath, text, problems);
    }

    public String formatActionScriptText(String text) {
        return this.formatActionScriptText(text, null);
    }

    public String formatMXMLText(String text, Collection<ICompilerProblem> problems) {
        String filePath = FilenameNormalization.normalize((String)"stdin.mxml");
        return this.formatMXMLTextInternal(filePath, text, problems);
    }

    public String formatMXMLText(String text) {
        return this.formatMXMLText(text, null);
    }

    protected String getStartMessage() {
        String message = "Apache Royale ActionScript Formatter (asformat)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    protected String getProgramName() {
        return "asformat";
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        if (helpVar != null) {
            for (ConfigurationValue val : helpVar) {
                Iterator<String> iterator = val.getArgs().iterator();
                while (iterator.hasNext()) {
                    String element;
                    String keyword = element = iterator.next();
                    while (keyword.startsWith("-")) {
                        keyword = keyword.substring(1);
                    }
                    keywords.add(keyword);
                }
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage(this.getProgramName(), DEFAULT_VAR, this.configBuffer, keywords, LocalizationManager.get(), L10N_CONFIG_PREFIX);
        System.out.println(this.getStartMessage());
        System.out.println(usages);
    }

    private boolean configure(String[] args) {
        try {
            this.problems = new ProblemQuery();
            Configurator configurator = new Configurator();
            configurator.setConfiguration(args, DEFAULT_VAR);
            this.configuration = configurator.getConfiguration();
            this.configBuffer = configurator.getConfigurationBuffer();
            this.problems.addAll(configurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                System.out.println(VersionInfo.buildMessage());
                return false;
            }
            List<ConfigurationValue> helpVar = this.configBuffer.getVar("help");
            if (helpVar != null || args.length == 0) {
                this.processHelp(helpVar);
                return false;
            }
            if (this.problems.hasErrors()) {
                return false;
            }
            this.collapseEmptyBlocks = this.configuration.getCollapseEmptyBlocks();
            this.ignoreProblems = this.configuration.getIgnoreParsingProblems();
            this.insertFinalNewLine = this.configuration.getInsertFinalNewLine();
            this.insertSpaceAfterCommaDelimiter = this.configuration.getInsertSpaceAfterCommaDelimiter();
            this.insertSpaceBetweenMetadataAttributes = this.configuration.getInsertSpaceBetweenMetadataAttributes();
            this.insertSpaceAfterFunctionKeywordForAnonymousFunctions = this.configuration.getInsertSpaceAfterFunctionKeywordForAnonymousFunctions();
            this.insertSpaceAfterKeywordsInControlFlowStatements = this.configuration.getInsertSpaceAfterKeywordsInControlFlowStatements();
            this.insertSpaceAfterSemicolonInForStatements = this.configuration.getInsertSpaceAfterSemicolonInForStatements();
            this.insertSpaceBeforeAndAfterBinaryOperators = this.configuration.getInsertSpaceBeforeAndAfterBinaryOperators();
            this.insertSpaceAtStartOfLineComment = this.configuration.getInsertSpaceAtStartOfLineComment();
            this.insertSpaces = this.configuration.getInsertSpaces();
            this.mxmlInsertNewLineBetweenAttributes = this.configuration.getMxmlInsertNewLineBetweenAttributes();
            this.mxmlAlignAttributes = this.configuration.getMxmlAlignAttributes();
            this.listChangedFiles = this.configuration.getListFiles();
            this.maxPreserveNewLines = this.configuration.getMaxPreserveNewLines();
            this.placeOpenBraceOnNewLine = this.configuration.getPlaceOpenBraceOnNewLine();
            this.semicolons = Semicolons.valueOf(this.configuration.getSemicolons().toUpperCase());
            this.tabSize = this.configuration.getTabSize();
            this.writeBackToInputFiles = this.configuration.getWriteFiles();
            for (String filePath : this.configuration.getFiles()) {
                File inputFile = new File(filePath);
                if (!inputFile.exists()) {
                    throw new ConfigurationException("Input file does not exist: " + filePath, null, -1);
                }
                if (inputFile.isDirectory()) {
                    this.addDirectory(inputFile);
                    continue;
                }
                this.inputFiles.add(inputFile);
            }
            if (this.inputFiles.size() == 0 && this.listChangedFiles) {
                throw new ConfigurationException("Cannot use -list-files with standard input", null, -1);
            }
            if (this.writeBackToInputFiles) {
                if (this.inputFiles.size() == 0) {
                    throw new ConfigurationException("Cannot use -write-files with standard input", null, -1);
                }
                for (File inputFile : this.inputFiles) {
                    if (inputFile.canWrite()) continue;
                    throw new ConfigurationException("File is read-only: " + inputFile.getPath(), null, -1);
                }
            }
            return true;
        }
        catch (ConfigurationException e) {
            ConfigurationProblem problem = new ConfigurationProblem(e);
            this.problems.add((ICompilerProblem)problem);
            return false;
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add((ICompilerProblem)problem);
            return false;
        }
    }

    private void addDirectory(File inputFile) {
        for (File file : inputFile.listFiles()) {
            String fileName = file.getName();
            if (fileName.startsWith(".")) continue;
            if (file.isDirectory()) {
                this.addDirectory(file);
                continue;
            }
            if (!fileName.endsWith(".as") && !fileName.endsWith(".mxml")) continue;
            this.inputFiles.add(file);
        }
    }

    private String formatMXMLScriptElement(String text, Collection<ICompilerProblem> problems) {
        String indent = "\t";
        if (this.insertSpaces) {
            indent = "";
            for (int i = 0; i < this.tabSize; ++i) {
                indent = indent + " ";
            }
        }
        StringBuilder builder = new StringBuilder();
        Pattern scriptPattern = Pattern.compile("^<((?:mx|fx):(\\w+))>\\s*(<!\\[CDATA\\[)?((?:.|\\n)*?)(?:\\]\\]>)?\\s*<\\/(?:mx|fx):(?:\\w+)>$");
        Matcher scriptMatcher = scriptPattern.matcher(text);
        if (!scriptMatcher.matches()) {
            return text;
        }
        if (problems == null) {
            problems = new ArrayList<ICompilerProblem>();
        }
        String scriptTagText = scriptMatcher.group(1);
        String scriptTagName = scriptMatcher.group(2);
        String cdataText = scriptMatcher.group(3);
        String scriptText = scriptMatcher.group(4);
        boolean requireCdata = cdataText != null || "Script".equals(scriptTagName);
        String formattedScriptText = this.formatAS3TextInternal("script.as", scriptText, problems);
        if (!this.ignoreProblems && this.hasErrors(problems)) {
            return text;
        }
        if (formattedScriptText.length() > 0) {
            CharSequence[] formattedLines = formattedScriptText.split("\n");
            String lineIndent = requireCdata ? indent + indent + indent : indent + indent;
            for (int i = 0; i < formattedLines.length; ++i) {
                formattedLines[i] = lineIndent + (String)formattedLines[i];
            }
            formattedScriptText = String.join((CharSequence)"\n", formattedLines);
        }
        builder.append(indent);
        builder.append("<");
        builder.append(scriptTagText);
        builder.append(">\n");
        if (requireCdata) {
            builder.append(indent);
            builder.append(indent);
            builder.append("<![CDATA[\n");
        }
        if (formattedScriptText.length() > 0) {
            builder.append(formattedScriptText);
            builder.append("\n");
        }
        if (requireCdata) {
            builder.append(indent);
            builder.append(indent);
            builder.append("]]>\n");
        }
        builder.append(indent);
        builder.append("</");
        builder.append(scriptTagText);
        builder.append(">");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatAS3TextInternal(String filePath, String text, Collection<ICompilerProblem> problems) {
        if (problems == null) {
            problems = new ArrayList<ICompilerProblem>();
        }
        StringReader textReader = new StringReader(text);
        StreamingASTokenizer tokenizer = null;
        ASToken[] streamingTokens = null;
        try {
            tokenizer = StreamingASTokenizer.createForRepairingASTokenizer(textReader, filePath, IncludeHandler.creatDefaultIncludeHandler());
            tokenizer.setCollectComments(true);
            tokenizer.setFollowIncludes(false);
            streamingTokens = tokenizer.getTokens(textReader);
        }
        finally {
            IOUtils.closeQuietly((Reader)textReader);
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
        if (tokenizer.hasTokenizationProblems()) {
            problems.addAll(tokenizer.getTokenizationProblems());
        }
        if (!this.ignoreProblems && this.hasErrors(problems)) {
            return text;
        }
        ArrayList<ASToken> comments = new ArrayList<ASToken>();
        ArrayList<ASToken> streamingTokensList = new ArrayList<ASToken>();
        for (ASToken token : streamingTokens) {
            if (token.getType() == 5 || token.getType() == 8) {
                comments.add(token);
                continue;
            }
            streamingTokensList.add(token);
        }
        Workspace workspace = new Workspace();
        RepairingTokenBuffer buffer = new RepairingTokenBuffer(streamingTokensList.toArray(new ASToken[0]));
        ASParser parser = new ASParser(workspace, buffer);
        FileNode node = new FileNode((IFileSpecificationGetter)workspace);
        try {
            parser.file(node);
        }
        catch (Exception e) {
            parser = null;
            problems.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
            return text;
        }
        if (tokenizer.hasTokenizationProblems()) {
            problems.addAll(tokenizer.getTokenizationProblems());
        }
        if (parser.getSyntaxProblems().size() > 0) {
            problems.addAll(parser.getSyntaxProblems());
        }
        if (!this.ignoreProblems && this.hasErrors(problems)) {
            return text;
        }
        ArrayList<IASToken> repairedTokensList = new ArrayList<IASToken>(Arrays.asList(buffer.getTokens(true)));
        IASToken nextComment = null;
        for (int i = 0; i < repairedTokensList.size(); ++i) {
            if (nextComment == null) {
                if (comments.size() == 0) break;
                nextComment = (IASToken)comments.get(0);
            }
            IASToken currentToken = (IASToken)repairedTokensList.get(i);
            if (nextComment.getAbsoluteStart() > currentToken.getAbsoluteStart()) continue;
            repairedTokensList.add(i, nextComment);
            nextComment = null;
            comments.remove(0);
        }
        repairedTokensList.addAll(comments);
        List<IASToken> tokens = this.insertExtraAS3Tokens(repairedTokensList, text);
        try {
            return this.parseTokens(filePath, tokens, node);
        }
        catch (Exception e) {
            if (problems != null) {
                System.err.println(e);
                e.printStackTrace(System.err);
                problems.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
            }
            return text;
        }
    }

    private List<IASToken> insertExtraAS3Tokens(List<IASToken> originalTokens, String text) {
        ArrayList<IASToken> tokens = new ArrayList<IASToken>();
        IASToken prevToken = null;
        for (IASToken token : originalTokens) {
            if (prevToken != null) {
                boolean skipSemicolon;
                boolean bl = skipSemicolon = token.getType() == 55 && token.isImplicit() && prevToken != null && (prevToken.getType() == 5 || prevToken.getType() == 22);
                if (skipSemicolon) continue;
                int start = prevToken.getAbsoluteEnd();
                int end = token.getAbsoluteStart();
                if (end > start) {
                    String tokenText = text.substring(start, end);
                    ASToken extraToken = new ASToken(999999, start, end, prevToken.getEndLine(), prevToken.getEndColumn(), tokenText);
                    extraToken.setEndLine(token.getLine());
                    extraToken.setEndLine(token.getColumn());
                    tokens.add(extraToken);
                }
            }
            tokens.add(token);
            prevToken = token;
        }
        if (prevToken != null) {
            int start = prevToken.getAbsoluteEnd();
            int end = text.length();
            if (end > start) {
                String tokenText = text.substring(start, end);
                ASToken extraToken = new ASToken(999999, start, end, prevToken.getEndLine(), prevToken.getEndColumn(), tokenText);
                extraToken.setEndLine(prevToken.getLine());
                extraToken.setEndLine(prevToken.getColumn());
                tokens.add(extraToken);
            }
        }
        return tokens;
    }

    private List<IMXMLToken> insertExtraMXMLTokens(IMXMLToken[] originalTokens, String text) {
        ArrayList<IMXMLToken> tokens = new ArrayList<IMXMLToken>();
        IMXMLToken prevToken = null;
        for (IMXMLToken token : originalTokens) {
            if (prevToken != null) {
                int start = prevToken.getEnd();
                int end = token.getStart();
                if (end > start) {
                    String tokenText = text.substring(start, end);
                    MXMLToken extraToken = new MXMLToken(999999, start, end, prevToken.getLine(), prevToken.getColumn() + end - start, tokenText);
                    extraToken.setEndLine(token.getLine());
                    extraToken.setEndLine(token.getColumn());
                    tokens.add(extraToken);
                }
            }
            tokens.add(token);
            prevToken = token;
        }
        if (prevToken != null) {
            int start = prevToken.getEnd();
            int end = text.length();
            if (end > start) {
                String tokenText = text.substring(start, end);
                MXMLToken extraToken = new MXMLToken(999999, start, end, prevToken.getLine(), prevToken.getColumn() + end - start, tokenText);
                extraToken.setEndLine(prevToken.getLine());
                extraToken.setEndLine(prevToken.getColumn());
                tokens.add(extraToken);
            }
        }
        return tokens;
    }

    private IASToken getNextTokenSkipExtra(List<IASToken> tokens, int startIndex) {
        for (int i = startIndex; i < tokens.size(); ++i) {
            IASToken token = tokens.get(i);
            if (token.getType() == 999999) continue;
            return token;
        }
        return null;
    }

    private IASToken getNextTokenSkipExtraAndComments(List<IASToken> tokens, int startIndex) {
        for (int i = startIndex; i < tokens.size(); ++i) {
            IASToken token = tokens.get(i);
            if (token.getType() == 999999 || token.getType() == 5 || token.getType() == 8 || token.getType() == 28) continue;
            return token;
        }
        return null;
    }

    private String parseTokens(String filePath, List<IASToken> tokens, FileNode node) throws Exception {
        int indent = 0;
        boolean inCaseOrDefaultClause = false;
        boolean inControlFlowStatement = false;
        boolean inVarOrConstDeclaration = false;
        boolean inFunctionDeclaration = false;
        boolean inPackageDeclaration = false;
        boolean inClassDeclaration = false;
        boolean inInterfaceDeclaration = false;
        boolean blockOpenPending = false;
        boolean indentedStatement = false;
        boolean caseOrDefaultBlockOpenPending = false;
        boolean skipFormatting = false;
        int varOrConstChainLevel = -1;
        ArrayList<BlockStackItem> blockStack = new ArrayList<BlockStackItem>();
        int controlFlowParenStack = 0;
        int ternaryStack = 0;
        int numRequiredNewLines = 0;
        boolean requiredSpace = false;
        IASToken prevTokenNotComment = null;
        IASToken prevToken = null;
        IASToken prevTokenOrExtra = null;
        IASToken token = null;
        IASToken nextToken = null;
        IASToken nextTokenOrExtra = null;
        IASToken nextTokenNotComment = null;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            boolean skipWhitespaceBeforeSemicolon;
            token = tokens.get(i);
            if (token.getType() == 999999) {
                if (skipFormatting) {
                    builder.append(token.getText());
                } else {
                    if (i == tokens.size() - 1) {
                        numRequiredNewLines = Math.max(0, this.countNewLinesInExtra(token));
                        this.appendNewLines(builder, numRequiredNewLines);
                        break;
                    }
                    if (!blockOpenPending) {
                        boolean oneLineBlock;
                        int newLinesInExtra = this.countNewLinesInExtra(token);
                        if (prevToken != null && prevToken.getType() == 5) {
                            ++newLinesInExtra;
                        }
                        boolean bl = oneLineBlock = prevToken != null && prevToken.getType() == 22 && nextToken != null && nextToken.getType() == 23;
                        if (oneLineBlock && this.collapseEmptyBlocks) {
                            newLinesInExtra = 0;
                        }
                        numRequiredNewLines = Math.max(numRequiredNewLines, newLinesInExtra);
                        if (!(indentedStatement || numRequiredNewLines <= 0 || prevTokenNotComment == null || prevTokenNotComment.getType() == 55 || prevTokenNotComment.getType() == 23 || caseOrDefaultBlockOpenPending && prevTokenNotComment.getType() == 24 || prevTokenNotComment instanceof MetaDataPayloadToken)) {
                            boolean needsIndent;
                            boolean bl2 = needsIndent = prevTokenNotComment.getType() != 22 || !blockStack.isEmpty() && blockStack.get(blockStack.size() - 1) instanceof ObjectLiteralBlockStackItem;
                            if (needsIndent) {
                                indentedStatement = true;
                                indent = this.increaseIndent(indent);
                            }
                        }
                    }
                }
                prevTokenOrExtra = token;
                continue;
            }
            nextTokenOrExtra = i + 1 < tokens.size() ? tokens.get(i + 1) : null;
            nextToken = this.getNextTokenSkipExtra(tokens, i + 1);
            nextTokenNotComment = this.getNextTokenSkipExtraAndComments(tokens, i + 1);
            boolean bl = skipWhitespaceBeforeSemicolon = nextToken == null || nextToken.getType() == 55;
            if (token instanceof MetaDataPayloadToken) {
                numRequiredNewLines = Math.max(numRequiredNewLines, 1);
            } else {
                switch (token.getType()) {
                    case 22: {
                        if (!blockOpenPending) {
                            boolean bl3 = blockOpenPending = prevTokenNotComment == null || prevTokenNotComment.getType() == 55 || prevTokenNotComment.getType() == 22 || prevTokenNotComment.getType() == 23;
                            if (!blockOpenPending && prevTokenNotComment.getType() == 24 && !blockStack.isEmpty()) {
                                IASToken blockToken = ((BlockStackItem)blockStack.get((int)(blockStack.size() - 1))).token;
                                boolean bl4 = blockOpenPending = blockToken.getType() == 70 || blockToken.getType() == 69;
                            }
                            if (blockOpenPending) {
                                blockStack.add(new BlockStackItem(token));
                            }
                        }
                        if (blockOpenPending) {
                            boolean needsNewLine;
                            if (indentedStatement) {
                                indentedStatement = false;
                                indent = this.decreaseIndent(indent);
                            }
                            boolean oneLineBlock = nextToken != null && nextToken.getType() == 23;
                            boolean bl5 = needsNewLine = this.placeOpenBraceOnNewLine && (!this.collapseEmptyBlocks || !oneLineBlock);
                            if (needsNewLine) {
                                numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                            } else {
                                if (oneLineBlock && this.collapseEmptyBlocks) {
                                    numRequiredNewLines = 0;
                                }
                                requiredSpace = true;
                            }
                        } else {
                            blockStack.add(new ObjectLiteralBlockStackItem(token));
                            indent = this.increaseIndent(indent);
                        }
                        requiredSpace = true;
                        break;
                    }
                    case 23: {
                        boolean skipSwitchDecrease = false;
                        if (!blockStack.isEmpty()) {
                            BlockStackItem stackItem = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                            if (stackItem.blockDepth <= 1) {
                                boolean oneLineBlock;
                                boolean bl6 = oneLineBlock = prevToken != null && prevToken.getType() == 22;
                                if (!this.collapseEmptyBlocks || !oneLineBlock) {
                                    indent = this.decreaseIndent(indent);
                                }
                                if (stackItem.token.getType() == 69 || stackItem.token.getType() == 70) {
                                    blockStack.remove(blockStack.size() - 1);
                                    indent = this.decreaseIndent(indent);
                                    skipSwitchDecrease = true;
                                }
                            }
                        }
                        if (skipSwitchDecrease || blockStack.isEmpty()) break;
                        BlockStackItem stackItem = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                        if (stackItem.token.getType() != 68) break;
                        SwitchBlockStackItem switchStackItem = (SwitchBlockStackItem)stackItem;
                        if (switchStackItem.clauseCount <= 0 || prevToken != null && prevToken.getType() == 23) break;
                        indent = this.decreaseIndent(indent);
                        break;
                    }
                    case 127: {
                        if (blockStack.isEmpty()) break;
                        BlockStackItem item = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                        if (item.token.getType() != 38) break;
                        indent = this.decreaseIndent(indent);
                        blockStack.remove(item);
                        break;
                    }
                    case 5: 
                    case 8: 
                    case 11: 
                    case 41: 
                    case 44: 
                    case 59: 
                    case 102: 
                    case 103: {
                        requiredSpace = true;
                        break;
                    }
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 109: 
                    case 110: {
                        if (!this.insertSpaceBeforeAndAfterBinaryOperators) break;
                        requiredSpace = true;
                        break;
                    }
                    case 111: {
                        boolean isAnyType = this.checkTokenBeforeAnyType(prevTokenNotComment);
                        boolean isAnyVectorType = this.checkTokensForAnyVectorType(prevTokenNotComment, nextTokenNotComment);
                        if (isAnyType || isAnyVectorType || !this.insertSpaceBeforeAndAfterBinaryOperators || skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 107: 
                    case 108: {
                        boolean isUnary = this.checkTokenBeforeUnaryOperator(prevTokenNotComment);
                        if (isUnary || !this.insertSpaceBeforeAndAfterBinaryOperators) break;
                        requiredSpace = true;
                        break;
                    }
                    case 53: {
                        inVarOrConstDeclaration = false;
                        if (!this.insertSpaceBeforeAndAfterBinaryOperators) break;
                        requiredSpace = true;
                        break;
                    }
                    case 88: {
                        ++ternaryStack;
                        if (!this.insertSpaceBeforeAndAfterBinaryOperators) break;
                        requiredSpace = true;
                        break;
                    }
                    case 50: {
                        boolean isFirstArg;
                        boolean bl7 = isFirstArg = prevToken == null || prevToken.getType() == 46;
                        if (isFirstArg) break;
                        requiredSpace = true;
                        break;
                    }
                    case 69: 
                    case 70: {
                        if (!blockStack.isEmpty()) {
                            BlockStackItem stackItem = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                            switch (stackItem.token.getType()) {
                                case 69: 
                                case 70: {
                                    blockStack.remove(blockStack.size() - 1);
                                    indent = this.decreaseIndent(indent);
                                }
                            }
                        }
                        if (blockStack.isEmpty()) break;
                        BlockStackItem stackItem = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                        if (stackItem.token.getType() != 68) break;
                        SwitchBlockStackItem switchStackItem = (SwitchBlockStackItem)stackItem;
                        ++switchStackItem.clauseCount;
                        inCaseOrDefaultClause = true;
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                        blockStack.add(new BlockStackItem(token));
                        break;
                    }
                    case 24: {
                        if (ternaryStack <= 0) break;
                        requiredSpace = true;
                        break;
                    }
                    case 55: {
                        if (indentedStatement) {
                            indentedStatement = false;
                            indent = this.decreaseIndent(indent);
                        }
                        inVarOrConstDeclaration = false;
                        varOrConstChainLevel = -1;
                        break;
                    }
                    case 28: {
                        numRequiredNewLines = prevToken != null && prevToken.getType() == 22 ? Math.max(numRequiredNewLines, 1) : Math.max(numRequiredNewLines, 2);
                    }
                }
            }
            if (!skipFormatting && prevToken != null) {
                if (numRequiredNewLines > 0) {
                    this.appendNewLines(builder, numRequiredNewLines);
                    this.appendIndent(builder, indent);
                } else if (requiredSpace) {
                    builder.append(' ');
                }
            }
            switch (token.getType()) {
                case 22: {
                    boolean oneLineBlock;
                    if (!blockOpenPending) break;
                    boolean bl8 = oneLineBlock = nextToken != null && nextToken.getType() == 23;
                    if (!this.placeOpenBraceOnNewLine || this.collapseEmptyBlocks && oneLineBlock) break;
                    indent = this.increaseIndent(indent);
                }
            }
            builder.append(this.getTokenText(token, indent, skipFormatting));
            if (token.getType() != 5 && token.getType() != 8 && token.getType() != 28 && token.getType() != 22) {
                blockOpenPending = false;
            }
            if (token.getType() != 5 && token.getType() != 8 && token.getType() != 28) {
                caseOrDefaultBlockOpenPending = false;
            }
            requiredSpace = false;
            numRequiredNewLines = 0;
            if (token instanceof MetaDataPayloadToken) {
                numRequiredNewLines = Math.max(numRequiredNewLines, 1);
            } else {
                switch (token.getType()) {
                    case 55: {
                        if (inControlFlowStatement && this.isInForStatement(blockStack)) {
                            if (this.insertSpaceAfterSemicolonInForStatements) {
                                requiredSpace = true;
                            }
                        } else {
                            boolean checkNext = true;
                            while (!blockStack.isEmpty() && checkNext) {
                                checkNext = false;
                                BlockStackItem prevStackItem = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                                if (prevStackItem.token.getType() == 69 || prevStackItem.token.getType() == 70 || prevStackItem.blockDepth > 0) continue;
                                blockStack.remove(blockStack.size() - 1);
                                if (prevStackItem.token.getType() == 43 || prevStackItem.token.getType() == 40 || prevStackItem.token.getType() == 45) continue;
                                checkNext = !prevStackItem.braces;
                                indent = this.decreaseIndent(indent);
                            }
                        }
                        if (inControlFlowStatement) break;
                        if (nextToken != null && (nextToken.getType() == 5 || nextToken.getType() == 8)) {
                            requiredSpace = true;
                            break;
                        }
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                        break;
                    }
                    case 22: {
                        boolean oneLineBlock;
                        if (!blockOpenPending) break;
                        blockOpenPending = false;
                        if (!blockStack.isEmpty()) {
                            BlockStackItem item = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                            ++item.blockDepth;
                        }
                        boolean bl9 = oneLineBlock = nextToken != null && nextToken.getType() == 23;
                        if (this.collapseEmptyBlocks && oneLineBlock) break;
                        if (!this.placeOpenBraceOnNewLine) {
                            indent = this.increaseIndent(indent);
                        }
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                        break;
                    }
                    case 23: {
                        if (blockStack.isEmpty()) break;
                        BlockStackItem item = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                        --item.blockDepth;
                        if (item.blockDepth <= 0) {
                            blockStack.remove(blockStack.size() - 1);
                        }
                        if (item instanceof ObjectLiteralBlockStackItem || nextToken != null && (nextToken.getType() == 55 || nextToken.getType() == 47 || nextToken.getType() == 42 || nextToken.getType() == 5 || nextToken.getType() == 8)) break;
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                        break;
                    }
                    case 38: {
                        indent = this.increaseIndent(indent);
                        blockStack.add(new BlockStackItem(token));
                        break;
                    }
                    case 113: 
                    case 114: {
                        if (inControlFlowStatement || prevToken == null || prevToken.getType() == 55 || nextToken == null || nextToken.getType() == 55) break;
                        requiredSpace = true;
                        break;
                    }
                    case 56: 
                    case 62: 
                    case 63: {
                        if (skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 39: {
                        blockStack.add(new BlockStackItem(token));
                        requiredSpace = true;
                        inPackageDeclaration = true;
                        break;
                    }
                    case 43: {
                        blockStack.add(new BlockStackItem(token));
                        requiredSpace = true;
                        inClassDeclaration = true;
                        break;
                    }
                    case 40: {
                        blockStack.add(new BlockStackItem(token));
                        requiredSpace = true;
                        inInterfaceDeclaration = true;
                        break;
                    }
                    case 45: {
                        boolean skipSpace;
                        blockStack.add(new BlockStackItem(token));
                        inFunctionDeclaration = true;
                        boolean bl10 = skipSpace = !this.insertSpaceAfterFunctionKeywordForAnonymousFunctions && nextToken != null && nextToken.getType() == 46;
                        if (skipSpace) break;
                        requiredSpace = true;
                        break;
                    }
                    case 51: 
                    case 52: {
                        inVarOrConstDeclaration = true;
                        requiredSpace = true;
                        varOrConstChainLevel = blockStack.size();
                        break;
                    }
                    case 17: 
                    case 58: 
                    case 61: 
                    case 64: 
                    case 66: {
                        inControlFlowStatement = true;
                        blockStack.add(new BlockStackItem(token));
                        if (!this.insertSpaceAfterKeywordsInControlFlowStatements || skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 68: {
                        inControlFlowStatement = true;
                        blockStack.add(new SwitchBlockStackItem(token));
                        if (!this.insertSpaceAfterKeywordsInControlFlowStatements || skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 65: {
                        blockStack.add(new BlockStackItem(token));
                        if (!skipWhitespaceBeforeSemicolon) {
                            requiredSpace = true;
                        }
                        blockOpenPending = true;
                        break;
                    }
                    case 67: {
                        if (nextTokenNotComment != null && nextTokenNotComment.getType() == 66) {
                            requiredSpace = true;
                            break;
                        }
                        blockStack.add(new BlockStackItem(token));
                        blockOpenPending = true;
                        if (nextToken != null && nextToken.getType() == 55) {
                            blockStack.remove(blockStack.size() - 1);
                            if (skipWhitespaceBeforeSemicolon) break;
                            numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                            break;
                        }
                        if (nextToken == null || nextToken.getType() == 22 || nextToken.getType() == 5 || skipWhitespaceBeforeSemicolon) break;
                        indent = this.increaseIndent(indent);
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                        break;
                    }
                    case 60: {
                        blockStack.add(new BlockStackItem(token));
                        blockOpenPending = true;
                        if (nextToken != null && nextToken.getType() == 55) {
                            blockStack.remove(blockStack.size() - 1);
                            if (skipWhitespaceBeforeSemicolon) break;
                            numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                            break;
                        }
                        if (nextToken == null || nextToken.getType() == 22 || nextToken.getType() == 5 || skipWhitespaceBeforeSemicolon) break;
                        indent = this.increaseIndent(indent);
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                        break;
                    }
                    case 24: {
                        if (inControlFlowStatement || inVarOrConstDeclaration || inFunctionDeclaration) break;
                        if (inCaseOrDefaultClause) {
                            inCaseOrDefaultClause = false;
                            caseOrDefaultBlockOpenPending = true;
                            indent = this.increaseIndent(indent);
                            if (nextToken != null && (nextToken.getType() == 5 || nextToken.getType() == 8)) {
                                requiredSpace = true;
                                break;
                            }
                            numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                            break;
                        }
                        if (ternaryStack > 0) {
                            --ternaryStack;
                            requiredSpace = true;
                            break;
                        }
                        requiredSpace = true;
                        break;
                    }
                    case 46: {
                        blockStack.add(new BlockStackItem(token));
                        if (!inControlFlowStatement) break;
                        ++controlFlowParenStack;
                        break;
                    }
                    case 47: {
                        if (!blockStack.isEmpty()) {
                            BlockStackItem item = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                            if (item.token.getType() == 46) {
                                blockStack.remove(item);
                            }
                        }
                        if (!inControlFlowStatement || --controlFlowParenStack > 0) break;
                        inControlFlowStatement = false;
                        controlFlowParenStack = 0;
                        blockOpenPending = true;
                        if (nextToken != null && nextToken.getType() == 55) {
                            blockStack.remove(blockStack.size() - 1);
                            if (skipWhitespaceBeforeSemicolon) break;
                            numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                            break;
                        }
                        if (nextToken == null || nextToken.getType() == 22 || nextToken.getType() == 5 || skipWhitespaceBeforeSemicolon) break;
                        indent = this.increaseIndent(indent);
                        BlockStackItem item = (BlockStackItem)blockStack.get(blockStack.size() - 1);
                        item.braces = false;
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                        break;
                    }
                    case 69: {
                        if (skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 70: {
                        if (inCaseOrDefaultClause || skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 21: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 41: 
                    case 44: 
                    case 48: 
                    case 49: 
                    case 57: 
                    case 59: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 112: 
                    case 116: 
                    case 153: {
                        if (skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 53: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 109: 
                    case 110: {
                        if (!this.insertSpaceBeforeAndAfterBinaryOperators || skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 111: {
                        boolean isAnyType = this.checkTokenBeforeAnyType(prevTokenNotComment);
                        boolean isAnyVectorType = this.checkTokensForAnyVectorType(prevTokenNotComment, nextTokenNotComment);
                        if (isAnyType || isAnyVectorType || !this.insertSpaceBeforeAndAfterBinaryOperators || skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 107: 
                    case 108: {
                        boolean isUnary = this.checkTokenBeforeUnaryOperator(prevTokenNotComment);
                        if (isUnary || !this.insertSpaceBeforeAndAfterBinaryOperators || skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 42: {
                        if (varOrConstChainLevel == blockStack.size()) {
                            inVarOrConstDeclaration = true;
                        }
                        if (!this.insertSpaceAfterCommaDelimiter || skipWhitespaceBeforeSemicolon) break;
                        requiredSpace = true;
                        break;
                    }
                    case 5: {
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                        String trimmed = token.getText().substring(2).trim();
                        if (!skipFormatting && FORMATTER_TAG_OFF.equals(trimmed)) {
                            skipFormatting = true;
                            this.appendNewLines(builder, 1);
                            break;
                        }
                        if (!skipFormatting || !FORMATTER_TAG_ON.equals(trimmed)) break;
                        skipFormatting = false;
                        numRequiredNewLines = 0;
                        break;
                    }
                    case 8: 
                    case 28: {
                        if (skipWhitespaceBeforeSemicolon || nextTokenOrExtra == null || nextTokenOrExtra.getType() != 999999) break;
                        requiredSpace = true;
                    }
                }
            }
            if ((inPackageDeclaration || inClassDeclaration || inInterfaceDeclaration || inFunctionDeclaration) && nextToken != null && nextToken.getType() == 22) {
                blockOpenPending = true;
                inPackageDeclaration = false;
                inClassDeclaration = false;
                inInterfaceDeclaration = false;
                inFunctionDeclaration = false;
            }
            prevTokenOrExtra = prevToken = token;
            if (prevToken.getType() == 5 || prevToken.getType() == 8 || prevToken.getType() == 28) continue;
            prevTokenNotComment = prevToken;
        }
        if (blockStack.size() > 0) {
            throw new Exception("Block stack size too large");
        }
        return builder.toString();
    }

    private int countNewLinesInExtra(IASToken tokenOrExtra) {
        if (tokenOrExtra == null || tokenOrExtra.getType() != 999999) {
            return 0;
        }
        int numNewLinesInWhitespace = 0;
        String whitespace = tokenOrExtra.getText();
        int index = -1;
        while ((index = whitespace.indexOf(10, index + 1)) != -1) {
            ++numNewLinesInWhitespace;
        }
        return numNewLinesInWhitespace;
    }

    private String formatSingleLineComment(String comment) {
        comment = comment.substring(2).trim();
        StringBuilder builder = new StringBuilder();
        builder.append("//");
        if (this.insertSpaceAtStartOfLineComment) {
            builder.append(" ");
        }
        builder.append(comment);
        return builder.toString();
    }

    private String formatMultiLineComment(String comment) {
        return comment;
    }

    private String formatLiteralString(String string) {
        String charsToEscape = "\b\t\n\f\r\\";
        String escapeChars = "btnfr\\";
        int escapeIndex = -1;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char currChar = string.charAt(i);
            if (i == 0) {
                charsToEscape = charsToEscape + currChar;
                escapeChars = escapeChars + currChar;
                builder.append(currChar);
                continue;
            }
            if (i == string.length() - 1) {
                builder.append(currChar);
                continue;
            }
            escapeIndex = charsToEscape.indexOf(currChar);
            if (escapeIndex != -1) {
                builder.append("\\");
                builder.append(escapeChars.charAt(escapeIndex));
                continue;
            }
            builder.append(currChar);
        }
        return builder.toString();
    }

    private boolean isInForStatement(List<BlockStackItem> blockStack) {
        block4: for (int i = blockStack.size() - 1; i >= 0; --i) {
            BlockStackItem item = blockStack.get(i);
            switch (item.token.getType()) {
                case 22: 
                case 38: 
                case 46: {
                    continue block4;
                }
                case 58: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isInListing(String lineText, boolean alreadyInListing) {
        boolean inListing = alreadyInListing;
        for (int searchIndex = 0; searchIndex < lineText.length(); searchIndex += 10) {
            if (!inListing) {
                if ((searchIndex = lineText.indexOf("<listing", searchIndex)) == -1) {
                    return false;
                }
                searchIndex += 8;
                inListing = true;
            }
            if ((searchIndex = lineText.indexOf("</listing>", searchIndex)) == -1) {
                return true;
            }
            inListing = false;
        }
        return inListing;
    }

    private String formatASDocComment(String comment, int indent) {
        String[] lines = comment.split("\n");
        StringBuilder builder = new StringBuilder();
        String lineText = lines[0].trim();
        builder.append(lineText);
        boolean inListing = this.isInListing(lineText, false);
        if (lines.length > 1) {
            builder.append('\n');
        }
        String listingIndent = null;
        for (int i = 1; i < lines.length - 1; ++i) {
            Matcher startMatcher;
            lineText = lines[i].trim();
            if (inListing && (startMatcher = ASDOC_START_LINE_PATTERN.matcher(lineText)).find()) {
                if (listingIndent == null) {
                    listingIndent = startMatcher.group(1);
                } else if (startMatcher.group().length() >= lineText.length()) {
                    lineText = "*" + listingIndent;
                }
            }
            this.appendIndent(builder, indent);
            builder.append(' ');
            builder.append(lineText);
            builder.append('\n');
            inListing = this.isInListing(lineText, inListing);
            if (inListing) continue;
            listingIndent = null;
        }
        if (lines.length > 1) {
            this.appendIndent(builder, indent);
            builder.append(' ');
            builder.append(lines[lines.length - 1].trim());
        }
        return builder.toString();
    }

    private String getTokenText(IASToken token, int indent, boolean skipFormatting) {
        if (token instanceof MetaDataPayloadToken) {
            MetaDataPayloadToken metaPlayloadToken = (MetaDataPayloadToken)token;
            return this.formatMetadataToken(metaPlayloadToken);
        }
        switch (token.getType()) {
            case 28: {
                if (skipFormatting) {
                    return token.getText();
                }
                return this.formatASDocComment(token.getText(), indent);
            }
            case 5: {
                if (skipFormatting) {
                    return token.getText();
                }
                return this.formatSingleLineComment(token.getText());
            }
            case 8: {
                if (skipFormatting) {
                    return token.getText();
                }
                return this.formatMultiLineComment(token.getText());
            }
            case 18: {
                return this.formatLiteralString(token.getText());
            }
            case 55: {
                boolean skipSemicolon;
                if (skipFormatting) {
                    return token.isImplicit() ? "" : token.getText();
                }
                boolean bl = skipSemicolon = Semicolons.REMOVE.equals((Object)this.semicolons) || Semicolons.IGNORE.equals((Object)this.semicolons) && token.isImplicit();
                if (!skipSemicolon) {
                    return token.getText();
                }
                return null;
            }
        }
        return token.getText();
    }

    private String formatMetadataToken(MetaDataPayloadToken token) {
        StringBuilder builder = new StringBuilder();
        boolean needsComma = false;
        List<MetadataToken> payload = token.getPayload();
        block4: for (int i = 0; i < payload.size(); ++i) {
            MetadataToken metaToken = payload.get(i);
            switch (metaToken.getType()) {
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 50: 
                case 51: 
                case 62: {
                    if (needsComma) {
                        builder.append(",");
                        if (this.insertSpaceBetweenMetadataAttributes) {
                            builder.append(" ");
                        }
                    }
                    needsComma = true;
                    builder.append(metaToken.getText());
                    MetadataToken nextToken = payload.get(i + 1);
                    if (nextToken.getType() != 8) continue block4;
                    builder.append("=");
                    builder.append("\"");
                    builder.append(nextToken.getText());
                    builder.append("\"");
                    ++i;
                    continue block4;
                }
                case 8: {
                    if (needsComma) {
                        builder.append(",");
                        if (this.insertSpaceBetweenMetadataAttributes) {
                            builder.append(" ");
                        }
                    }
                    builder.append("\"");
                    builder.append(metaToken.getText());
                    builder.append("\"");
                    needsComma = true;
                    continue block4;
                }
                default: {
                    builder.append(metaToken.getText());
                }
            }
        }
        return builder.toString();
    }

    private boolean checkTokenBeforeAnyType(IASToken token) {
        return token.getType() == 24;
    }

    private boolean checkTokensForAnyVectorType(IASToken prevToken, IASToken nextToken) {
        return prevToken != null && nextToken != null && (prevToken.getType() == 72 && nextToken.getType() == 73 || prevToken.getType() == 128 && nextToken.getType() == 129);
    }

    private boolean checkTokenBeforeUnaryOperator(IASToken token) {
        return token instanceof ASToken ? ((ASToken)token).isOperator() || token.getType() == 38 || token.getType() == 46 || token.getType() == 22 || token.getType() == 55 || token.getType() == 56 || token.getType() == 42 || token.getType() == 24 : token == null;
    }

    private int increaseIndent(int indent) {
        return indent + 1;
    }

    private int decreaseIndent(int indent) {
        return Math.max(0, indent - 1);
    }

    private String getIndent() {
        if (this.insertSpaces) {
            String result = "";
            for (int j = 0; j < this.tabSize; ++j) {
                result = result + " ";
            }
            return result;
        }
        return "\t";
    }

    private String getAttributeIndent(IMXMLToken openTagToken) {
        int indentSize;
        if (!this.mxmlAlignAttributes) {
            return this.getIndent();
        }
        String result = "";
        for (indentSize = openTagToken.getText().length() + 1; indentSize >= this.tabSize; indentSize -= this.tabSize) {
            result = result + this.getIndent();
        }
        for (int i = 0; i < indentSize; ++i) {
            result = result + " ";
        }
        return result;
    }

    private void appendIndent(StringBuilder builder, int indent) {
        String indentString = this.getIndent();
        for (int i = 0; i < indent; ++i) {
            builder.append(indentString);
        }
    }

    private void appendNewLines(StringBuilder builder, int numRequiredNewLines) {
        if (this.maxPreserveNewLines != 0) {
            numRequiredNewLines = Math.min(this.maxPreserveNewLines, numRequiredNewLines);
        }
        for (int j = 0; j < numRequiredNewLines; ++j) {
            builder.append('\n');
        }
    }

    private boolean hasErrors(Collection<ICompilerProblem> problems) {
        CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer(null);
        for (ICompilerProblem problem : problems) {
            CompilerProblemSeverity severity = categorizer.getProblemSeverity(problem);
            if (!CompilerProblemSeverity.ERROR.equals((Object)severity)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatMXMLTextInternal(String filePath, String text, Collection<ICompilerProblem> problems) {
        StringReader textReader = new StringReader(text);
        MXMLTokenizer mxmlTokenizer = new MXMLTokenizer();
        IMXMLToken[] originalTokens = null;
        try {
            originalTokens = mxmlTokenizer.getTokens(textReader);
        }
        finally {
            IOUtils.closeQuietly((Reader)textReader);
            IOUtils.closeQuietly((Closeable)mxmlTokenizer);
        }
        if (mxmlTokenizer.hasTokenizationProblems()) {
            return text;
        }
        Pattern scriptStartPattern = Pattern.compile("<((?:mx|fx):(Script|Metadata))");
        List<IMXMLToken> tokens = this.insertExtraMXMLTokens(originalTokens, text);
        int indent = 0;
        int numRequiredNewLines = 0;
        boolean requiredSpace = false;
        boolean inOpenTag = false;
        boolean inCloseTag = false;
        boolean skipFormatting = false;
        String attributeIndent = "";
        IMXMLToken prevToken = null;
        IMXMLToken prevTokenOrExtra = null;
        IMXMLToken token = null;
        IMXMLToken nextToken = null;
        ArrayList<ElementStackItem> elementStack = new ArrayList<ElementStackItem>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            token = tokens.get(i);
            nextToken = null;
            if (i < tokens.size() - 1) {
                nextToken = tokens.get(i + 1);
            }
            if (token.getType() == 999999) {
                if (skipFormatting) {
                    builder.append(token.getText());
                } else {
                    if (i == tokens.size() - 1) {
                        numRequiredNewLines = Math.max(0, this.countNewLinesInExtra(token));
                        this.appendNewLines(builder, numRequiredNewLines);
                        break;
                    }
                    numRequiredNewLines = Math.max(numRequiredNewLines, this.countNewLinesInExtra(token));
                }
                prevTokenOrExtra = token;
                continue;
            }
            if (token.getType() == 13) {
                if (skipFormatting) {
                    builder.append(token.getText());
                    continue;
                }
                if (elementStack.isEmpty() || !((ElementStackItem)elementStack.get((int)(elementStack.size() - 1))).containsText) {
                    numRequiredNewLines = Math.max(numRequiredNewLines, this.countNewLinesInExtra(token));
                } else {
                    builder.append(token.getText());
                }
                if (i != tokens.size() - 1) continue;
                this.appendNewLines(builder, numRequiredNewLines);
                continue;
            }
            if (token.getType() == 8 && scriptStartPattern.matcher(token.getText()).matches()) {
                if (prevToken != null && numRequiredNewLines > 0) {
                    this.appendNewLines(builder, numRequiredNewLines);
                }
                StringBuilder scriptBuilder = new StringBuilder();
                scriptBuilder.append(token.getText());
                boolean inScriptCloseTag = false;
                while (i < tokens.size() - 1) {
                    token = tokens.get(++i);
                    scriptBuilder.append(token.getText());
                    if (token.getType() == 3) {
                        inScriptCloseTag = true;
                        continue;
                    }
                    if (!inScriptCloseTag || token.getType() != 11) continue;
                }
                if (problems == null) {
                    problems = new ArrayList<ICompilerProblem>();
                }
                builder.append(this.formatMXMLScriptElement(scriptBuilder.toString(), problems));
                if (this.hasErrors(problems)) {
                    return text;
                }
                prevToken = token;
                prevTokenOrExtra = token;
                requiredSpace = false;
                numRequiredNewLines = 1;
                continue;
            }
            switch (token.getType()) {
                case 8: {
                    inOpenTag = true;
                    boolean containsText = !elementStack.isEmpty() && ((ElementStackItem)elementStack.get((int)(elementStack.size() - 1))).containsText;
                    elementStack.add(new ElementStackItem(token, token.getText().substring(1), containsText));
                    break;
                }
                case 3: {
                    if (elementStack.isEmpty() || !((ElementStackItem)elementStack.get((int)(elementStack.size() - 1))).containsText) {
                        indent = this.decreaseIndent(indent);
                    }
                    inCloseTag = true;
                    break;
                }
                case 7: {
                    requiredSpace = true;
                }
            }
            if (!skipFormatting && prevToken != null) {
                if (numRequiredNewLines > 0) {
                    this.appendNewLines(builder, numRequiredNewLines);
                    this.appendIndent(builder, indent);
                    if (attributeIndent.length() > 0) {
                        builder.append(attributeIndent);
                    }
                } else if (requiredSpace) {
                    builder.append(' ');
                }
            }
            builder.append(token.getText());
            requiredSpace = false;
            numRequiredNewLines = 0;
            switch (token.getType()) {
                case 9: {
                    numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                    break;
                }
                case 3: {
                    if (nextToken != null && nextToken.getType() != 11 && nextToken.getType() != 5 && nextToken.getType() != 999999) {
                        requiredSpace = true;
                    }
                    if (elementStack.isEmpty()) {
                        return text;
                    }
                    String elementName = token.getText().substring(2);
                    ElementStackItem elementItem = (ElementStackItem)elementStack.remove(elementStack.size() - 1);
                    if (elementName.equals(elementItem.elementName)) break;
                    return text;
                }
                case 8: {
                    if (nextToken == null || nextToken.getType() == 11 || nextToken.getType() == 5) break;
                    attributeIndent = this.getAttributeIndent(token);
                    if (nextToken.getType() == 999999) break;
                    requiredSpace = true;
                    break;
                }
                case 11: {
                    if (inOpenTag) {
                        ElementStackItem element = (ElementStackItem)elementStack.get(elementStack.size() - 1);
                        if (!element.containsText) {
                            element.containsText = this.elementContainsText(tokens, i + 1, element.token);
                        }
                        if (elementStack.isEmpty() || !((ElementStackItem)elementStack.get((int)(elementStack.size() - 1))).containsText) {
                            indent = this.increaseIndent(indent);
                        }
                    } else if (elementStack.isEmpty() || !((ElementStackItem)elementStack.get((int)(elementStack.size() - 1))).containsText) {
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                    }
                    inOpenTag = false;
                    attributeIndent = "";
                    inCloseTag = false;
                    break;
                }
                case 5: {
                    if (inOpenTag) {
                        elementStack.remove(elementStack.size() - 1);
                    } else if (elementStack.isEmpty() || !((ElementStackItem)elementStack.get((int)(elementStack.size() - 1))).containsText) {
                        numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                    }
                    inOpenTag = false;
                    attributeIndent = "";
                    inCloseTag = false;
                    break;
                }
                case 10: {
                    if (!inOpenTag || !this.mxmlInsertNewLineBetweenAttributes || nextToken == null || nextToken.getType() == 11 || nextToken.getType() == 5) break;
                    numRequiredNewLines = Math.max(numRequiredNewLines, 1);
                    break;
                }
                case 4: {
                    String tokenText = token.getText();
                    String trimmed = tokenText.substring(4, tokenText.length() - 3).trim();
                    if (!skipFormatting && FORMATTER_TAG_OFF.equals(trimmed)) {
                        skipFormatting = true;
                        break;
                    }
                    if (!skipFormatting || !FORMATTER_TAG_ON.equals(trimmed)) break;
                    skipFormatting = false;
                    break;
                }
            }
            prevToken = token;
            prevTokenOrExtra = token;
        }
        return builder.toString();
    }

    private boolean elementContainsText(List<IMXMLToken> tokens, int startIndex, IMXMLToken openTagToken) {
        ArrayList<IMXMLToken> elementStack = new ArrayList<IMXMLToken>();
        elementStack.add(openTagToken);
        block6: for (int i = startIndex; i < tokens.size(); ++i) {
            IMXMLToken token = tokens.get(i);
            switch (token.getType()) {
                case 12: {
                    if (elementStack.size() != 1) continue block6;
                    return true;
                }
                case 8: {
                    elementStack.add(token);
                    continue block6;
                }
                case 5: {
                    elementStack.remove(elementStack.size() - 1);
                    if (elementStack.size() != 0) continue block6;
                    return false;
                }
                case 3: {
                    elementStack.remove(elementStack.size() - 1);
                    if (elementStack.size() != 0) continue block6;
                    return false;
                }
            }
        }
        return false;
    }

    private int countNewLinesInExtra(IMXMLToken token) {
        if (token == null || token.getType() != 13 && token.getType() != 999999) {
            return 0;
        }
        int numNewLinesInWhitespace = 0;
        String whitespace = token.getText();
        int index = -1;
        while ((index = whitespace.indexOf(10, index + 1)) != -1) {
            ++numNewLinesInWhitespace;
        }
        return numNewLinesInWhitespace;
    }

    private static class ElementStackItem {
        public IMXMLToken token;
        public String elementName;
        public boolean containsText = false;

        public ElementStackItem(IMXMLToken token, String elementName, boolean containsText) {
            this.token = token;
            this.elementName = elementName;
            this.containsText = containsText;
        }
    }

    private static class SwitchBlockStackItem
    extends BlockStackItem {
        public int clauseCount = 0;

        public SwitchBlockStackItem(IASToken token) {
            super(token);
        }
    }

    private static class ObjectLiteralBlockStackItem
    extends BlockStackItem {
        public ObjectLiteralBlockStackItem(IASToken token) {
            super(token);
        }
    }

    private static class BlockStackItem {
        public IASToken token;
        public int blockDepth = 0;
        public boolean braces = true;

        public BlockStackItem(IASToken token) {
            this.token = token;
        }
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }
    }
}

