/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IConstantDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.as.codegen.BindableHelper;
import org.apache.royale.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLDatabindingSourceNotBindableProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;

public class WatcherInfoBase {
    protected List<BindingInfo> bindingInfoList = new LinkedList<BindingInfo>();
    protected int index = -1;
    protected WatcherType type = WatcherType.ERROR;
    List<String> eventNames;
    protected Map<Object, WatcherInfoBase> children = null;
    public boolean isRoot = false;

    public WatcherInfoBase(Collection<ICompilerProblem> problems, IASNode sourceNode, List<String> eventNames) {
        assert (eventNames != null);
        this.eventNames = eventNames;
    }

    public WatcherType getType() {
        return this.type;
    }

    public void addBinding(BindingInfo bindingInfo) {
        this.bindingInfoList.add(bindingInfo);
    }

    public int assignIndex(int i) {
        this.index = i++;
        if (this.children != null) {
            for (Map.Entry<Object, WatcherInfoBase> ent : this.children.entrySet()) {
                i = ent.getValue().assignIndex(i);
            }
        }
        return i;
    }

    public int getIndex() {
        return this.index;
    }

    public List<String> getEventNames() {
        return this.eventNames;
    }

    public List<BindingInfo> getBindings() {
        return this.bindingInfoList;
    }

    public String toString() {
        return this.dump("");
    }

    protected String dump(String leadingSpace) {
        String ret = " eventNames";
        for (String s : this.getEventNames()) {
            ret = ret + ":" + s;
        }
        ret = ret + " idx=" + this.index;
        boolean firstBinding = true;
        for (BindingInfo bindingInfo : this.bindingInfoList) {
            ret = firstBinding ? ret + " Binding Index(s): " : ret + ", ";
            ret = ret + bindingInfo.index;
            firstBinding = false;
        }
        if (this.children != null) {
            leadingSpace = leadingSpace + "   ";
            for (Map.Entry entry : this.children.entrySet()) {
                ret = ret + "\n   " + ((WatcherInfoBase)entry.getValue()).dump(leadingSpace);
            }
        }
        return ret;
    }

    static List<String> getEventNamesFromDefinition(IDefinition def, Collection<ICompilerProblem> problems, IIdentifierNode sourceNode, ICompilerProject project) {
        Collection<Object> defs;
        LinkedList<String> ret = new LinkedList<String>();
        assert (!(def instanceof IConstantDefinition));
        IDefinition parent = def.getParent();
        if (parent instanceof IClassDefinition) {
            defs = new ArrayList();
            while (parent != null) {
                Collection<IDefinition> moredefs = SemanticUtils.getPropertiesByNameForMemberAccess(((IClassDefinition)parent).getContainedScope(), def.getBaseName(), project);
                if (moredefs != null) {
                    defs.addAll(moredefs);
                }
                parent = ((IClassDefinition)parent).resolveBaseClass(project);
            }
        } else {
            defs = SemanticUtils.getPropertiesByNameForMemberAccess(((IdentifierNode)sourceNode).getASScope(), def.getBaseName(), project);
            if (defs.size() == 0) {
                defs.add(def);
            }
        }
        boolean wasBindable = false;
        for (IDefinition iDefinition : defs) {
            if (!iDefinition.isBindable()) continue;
            wasBindable = true;
            List<String> names = iDefinition.getBindableEventNames();
            if (names.isEmpty()) {
                if (ret.contains(BindableHelper.PROPERTY_CHANGE)) continue;
                ret.add(BindableHelper.PROPERTY_CHANGE);
                continue;
            }
            for (String name : names) {
                if (ret.contains(name)) continue;
                ret.add(name);
            }
        }
        if (!wasBindable) {
            String s = def.getBaseName();
            problems.add(new MXMLDatabindingSourceNotBindableProblem(sourceNode, s));
        }
        assert (WatcherInfoBase.noDupes(ret));
        return ret;
    }

    private static boolean noDupes(List<String> events) {
        HashSet<String> temp = new HashSet<String>(events);
        return temp.size() == events.size();
    }

    public Set<Map.Entry<Object, WatcherInfoBase>> getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children.entrySet();
    }

    protected Map<Object, WatcherInfoBase> getOrCreateChildren() {
        if (this.children == null) {
            this.children = new LinkedHashMap<Object, WatcherInfoBase>();
        }
        return this.children;
    }

    public static enum WatcherType {
        PROPERTY,
        STATIC_PROPERTY,
        FUNCTION,
        XML,
        ERROR;

    }
}

