/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t=b\u0001B\u000b\u0017\u0001\u0015B\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005\u001b\")Q\u000b\u0001C\u0001-\")Q\u000b\u0001C\u00013\")!\f\u0001C!7\")A\r\u0001C!K\")\u0011\u000e\u0001C\u0001U\")A\u000e\u0001C![\"9\u00111\u0006\u0001\u0005B\u00055\u0002bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\tI\u000b\u0001C!\u0003W;q!a-\u0017\u0011\u0003\t)L\u0002\u0004\u0016-!\u0005\u0011q\u0017\u0005\u0007+:!\t!!4\t\u000f\u0005=g\u0002\"\u0001\u0002R\"9\u00111\u001c\b\u0005\n\u0005u\u0007b\u0002B\u0005\u001d\u0011%!1\u0002\u0005\b\u0005+qA\u0011\u0002B\f\u0011%\u0011yBDA\u0001\n\u0013\u0011\tC\u0001\u000bHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003/a\tq\u0001]1scV,GO\u0003\u0002\u001a5\u0005YA-\u0019;bg>,(oY3t\u0015\tYB$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QDH\u0001\u0004gFd'BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M9\u0001A\n\u0016.c]j\u0004CA\u0014)\u001b\u00051\u0012BA\u0015\u0017\u0005E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003O-J!\u0001\f\f\u00031\u001d+w\u000eU1scV,GOR5mK\u001a{'/\\1u\u0005\u0006\u001cX\r\u0005\u0002/_5\t\u0001$\u0003\u000211\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005I*T\"A\u001a\u000b\u0005Qb\u0012aB:pkJ\u001cWm]\u0005\u0003mM\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011\u0001hO\u0007\u0002s)\u0011!HH\u0001\tS:$XM\u001d8bY&\u0011A(\u000f\u0002\b\u0019><w-\u001b8h!\tq\u0004J\u0004\u0002@\u000b:\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011\u000bQa]2bY\u0006L!AR$\u0002\u000fA\f7m[1hK*\tA)\u0003\u0002J\u0015\na1+\u001a:jC2L'0\u00192mK*\u0011aiR\u0001\u000egB\fG/[1m\r&dG/\u001a:\u0016\u00035\u00032AT(R\u001b\u00059\u0015B\u0001)H\u0005\u0019y\u0005\u000f^5p]B\u0011qEU\u0005\u0003'Z\u0011qcR3p!\u0006\u0014\u0018/^3u'B\fG/[1m\r&dG/\u001a:\u0002\u001dM\u0004\u0018\r^5bY\u001aKG\u000e^3sA\u00051A(\u001b8jiz\"\"a\u0016-\u0011\u0005\u001d\u0002\u0001\"B&\u0004\u0001\u0004iE#A,\u0002\r\u0015\fX/\u00197t)\tav\f\u0005\u0002O;&\u0011al\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001W\u00011\u0001b\u0003\u0015yG\u000f[3s!\tq%-\u0003\u0002d\u000f\n\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012A\u001a\t\u0003\u001d\u001eL!\u0001[$\u0003\u0007%sG/A\u000bxSRD7\u000b]1uS\u0006d\u0007K]3eS\u000e\fG/Z:\u0015\u0005][\u0007\"B&\b\u0001\u0004\t\u0016aC5oM\u0016\u00148k\u00195f[\u0006$RA\\;|\u0003#\u00012AT(p!\t\u00018/D\u0001r\u0015\t\u0011H$A\u0003usB,7/\u0003\u0002uc\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bYD\u0001\u0019A<\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005aLX\"\u0001\u000f\n\u0005id\"\u0001D*qCJ\\7+Z:tS>t\u0007\"\u0002?\t\u0001\u0004i\u0018A\u00039be\u0006lW\r^3sgB9a0!\u0002\u0002\f\u0005-abA@\u0002\u0002A\u0011\u0001iR\u0005\u0004\u0003\u00079\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0005%!aA'ba*\u0019\u00111A$\u0011\u0007y\fi!\u0003\u0003\u0002\u0010\u0005%!AB*ue&tw\rC\u0004\u0002\u0014!\u0001\r!!\u0006\u0002\u000b\u0019LG.Z:\u0011\u000by\n9\"a\u0007\n\u0007\u0005e!JA\u0002TKF\u0004B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0002gg*\u0019\u0011Q\u0005\u0011\u0002\r!\fGm\\8q\u0013\u0011\tI#a\b\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\r\u0006\u0006\u00020\u0005U\u0012qGA$\u0003\u0017\u00022ALA\u0019\u0013\r\t\u0019\u0004\u0007\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\u0006m&\u0001\ra\u001e\u0005\b\u0003sI\u0001\u0019AA\u001e\u0003\rQwN\u0019\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)!\u0011\u0011IA\u0012\u0003%i\u0017\r\u001d:fIV\u001cW-\u0003\u0003\u0002F\u0005}\"a\u0001&pE\"1\u0011\u0011J\u0005A\u0002u\fqa\u001c9uS>t7\u000f\u0003\u0004\u0002N%\u0001\ra\\\u0001\u000bI\u0006$\u0018mU2iK6\f\u0017A\b2vS2$'+Z1eKJ<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]Z\u000bG.^3t)A\t\u0019&!\u001d\u0002t\u0005U\u0014\u0011PA?\u0003\u0013\u000bY\tE\u0004O\u0003+\nI&a\u0018\n\u0007\u0005]sIA\u0005Gk:\u001cG/[8ocA\u0019a&a\u0017\n\u0007\u0005u\u0003DA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0015q\u0014\u0011MA3\u0013\r\t\u0019G\u0013\u0002\t\u0013R,'/\u0019;peB!\u0011qMA7\u001b\t\tIGC\u0002\u0002lq\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003_\nIGA\u0006J]R,'O\\1m%><\b\"\u0002<\u000b\u0001\u00049\bBBA'\u0015\u0001\u0007q\u000e\u0003\u0004\u0002x)\u0001\ra\\\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"1\u00111\u0010\u0006A\u0002=\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002\u0000)\u0001\r!!!\u0002\u000f\u0019LG\u000e^3sgB)a(a\u0006\u0002\u0004B\u0019!'!\"\n\u0007\u0005\u001d5G\u0001\u0004GS2$XM\u001d\u0005\u0007\u0003\u0013R\u0001\u0019A?\t\u000f\u00055%\u00021\u0001\u0002\u0010\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002$\u0005!1m\u001c8g\u0013\u0011\tI*a%\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,Gc\u0001/\u0002 \"9\u0011\u0011U\u0006A\u0002\u0005\r\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007A\f)+C\u0002\u0002(F\u0014\u0001\u0002R1uCRK\b/Z\u0001\rgV\u0004\bo\u001c:u\u0005\u0006$8\r\u001b\u000b\u00069\u00065\u0016q\u0016\u0005\u0006m2\u0001\ra\u001e\u0005\u0007\u0003cc\u0001\u0019A8\u0002\rM\u001c\u0007.Z7b\u0003Q9Um\u001c)beF,X\r\u001e$jY\u00164uN]7biB\u0011qED\n\u0007\u001d\u0005ev'a0\u0011\u00079\u000bY,C\u0002\u0002>\u001e\u0013a!\u00118z%\u00164\u0007\u0003BAa\u0003\u0017l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\u0003S>T!!!3\u0002\t)\fg/Y\u0005\u0004\u0013\u0006\rGCAA[\u0003YiWM]4f'\u000eDW-\\1t\u0013:\u0004\u0016M]1mY\u0016dGc\u00028\u0002T\u0006U\u0017\u0011\u001c\u0005\u0006yB\u0001\r! \u0005\b\u0003/\u0004\u0002\u0019AA\u000b\u000311\u0017\u000e\\3t)>$v.^2i\u0011\u00151\b\u00031\u0001x\u0003Q\u0011X-\u00193TG\",W.\u0019$s_64un\u001c;feRIq.a8\u0002p\u0006u(q\u0001\u0005\b\u0003C\f\u0002\u0019AAr\u0003\u00191wn\u001c;feB!\u0011Q]Av\u001b\t\t9O\u0003\u0003\u0002&\u0005%(BA\f!\u0013\u0011\ti/a:\u0003\r\u0019{w\u000e^3s\u0011\u001d\t\t0\u0005a\u0001\u0003g\f\u0001c[3z-\u0006dW/Z'fi\u0006$\u0015\r^1\u0011\u0011\u0005U\u00181`A\u0006\u0003\u0017i!!a>\u000b\t\u0005e\u0018qY\u0001\u0005kRLG.\u0003\u0003\u0002\b\u0005]\bbBA\u0000#\u0001\u0007!\u0011A\u0001\nG>tg/\u001a:uKJ\u00042a\nB\u0002\u0013\r\u0011)A\u0006\u0002!\u000f\u0016|\u0007+\u0019:rk\u0016$Hk\\*qCJ\\7k\u00195f[\u0006\u001cuN\u001c<feR,'\u000fC\u0003}#\u0001\u0007Q0A\feKN,'/[1mSj,7k\u00195f[\u0006\u001cFO]5oOR9aN!\u0004\u0003\u0012\tM\u0001b\u0002B\b%\u0001\u0007\u00111B\u0001\rg\u000eDW-\\1TiJLgn\u001a\u0005\b\u0003c\u0014\u0002\u0019AAz\u0011\u0015a(\u00031\u0001~\u0003\u0011\u0012X\r\u001d7bG\u0016<Um\\7fiJL8i\u001c7v[:<\u0016\u000e\u001e5HK>lW\r\u001e:z+\u0012#FcB8\u0003\u001a\tm!Q\u0004\u0005\u0007\u0003c\u001b\u0002\u0019A8\t\u000f\u0005E8\u00031\u0001\u0002t\")Ap\u0005a\u0001{\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0005\t\u0005\u0005K\u0011Y#\u0004\u0002\u0003()!!\u0011FAd\u0003\u0011a\u0017M\\4\n\t\t5\"q\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class GeoParquetFileFormat
extends ParquetFileFormat
implements GeoParquetFileFormatBase {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    @Override
    public String shortName() {
        return GeoParquetFileFormatBase.shortName$(this);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)other).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key(), Boolean.toString(sqlConf.parquetFieldIdWriteEnabled()));
        conf.set(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sqlConf.legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0 & Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option parquet.summary.metadata.level to NONE.").toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean parquetFilterPushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            ParquetRecordReader parquetRecordReader;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFooterReader.readFooter((Configuration)sharedConf, (PartitionedFile)file, (boolean)true).getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, parquetFilterPushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$2 -> parquetFilters.createFilter(x$2))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$7(this, metadata)));
            if (!shouldScanFile) {
                return package$.MODULE$.Seq().empty().iterator();
            }
            None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            if (enableVectorizedReader) {
                this.logWarning((Function0 & Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
            }
            this.logDebug((Function0 & Serializable)() -> "Falling back to parquet-mr");
            GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec, options);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReader readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded(reader, requiredSchema);
            RecordReaderIterator iter = new RecordReaderIterator(readerWithRowIndexes);
            try {
                readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((IterableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema));
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map((Function1)unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$7(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
        GeoParquetFileFormatBase.$init$(this);
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

