/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.flink.expressions;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.common.enums.GeometryType;
import org.apache.sedona.common.utils.FormatUtils;
import org.apache.sedona.common.utils.GeoHashDecoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.gml2.GMLReader;
import org.locationtech.jts.io.kml.KMLReader;

public class Constructors {
    private static Geometry getGeometryByType(String geom, String inputDelimiter, GeometryType geometryType) throws ParseException {
        FileDataSplitter delimiter = inputDelimiter == null ? FileDataSplitter.CSV : FileDataSplitter.getFileDataSplitter(inputDelimiter);
        FormatUtils formatUtils = new FormatUtils(delimiter, false, geometryType);
        return formatUtils.readGeometry(geom);
    }

    private static Geometry getGeometryByFileData(String wktString, FileDataSplitter dataSplitter) throws ParseException {
        FormatUtils formatUtils = new FormatUtils(dataSplitter, false);
        return formatUtils.readGeometry(wktString);
    }

    public static class ST_GeomCollFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.geomCollFromText(wkt, srid);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt) throws ParseException {
            return org.apache.sedona.common.Constructors.geomCollFromText(wkt, 0);
        }
    }

    public static class ST_MPointFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.mPointFromText(wkt, srid);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt) throws ParseException {
            return org.apache.sedona.common.Constructors.mPointFromText(wkt, 0);
        }
    }

    public static class ST_MLineFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.mLineFromText(wkt, srid);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt) throws ParseException {
            return org.apache.sedona.common.Constructors.mLineFromText(wkt, 0);
        }
    }

    public static class ST_MPolyFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.mPolyFromText(wkt, srid);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt) throws ParseException {
            return org.apache.sedona.common.Constructors.mPolyFromText(wkt, 0);
        }
    }

    public static class ST_GeomFromKML
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String kml) throws ParseException {
            return new KMLReader().read(kml);
        }
    }

    public static class ST_GeomFromGML
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String gml) throws ParseException {
            GMLReader reader = new GMLReader();
            try {
                return reader.read(gml, new GeometryFactory());
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public static class ST_PointFromGeoHash
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String value, @DataTypeHint(value="Int") Integer precision) {
            return org.apache.sedona.common.Constructors.pointFromGeoHash(value, precision);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String value) {
            return this.eval(value, null);
        }
    }

    public static class ST_GeomFromGeoHash
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String value, @DataTypeHint(value="Int") Integer precision) throws ParseException, GeoHashDecoder.InvalidGeoHashException {
            return GeoHashDecoder.decode(value, precision);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String value) throws ParseException, GeoHashDecoder.InvalidGeoHashException {
            return this.eval(value, null);
        }
    }

    public static class ST_GeomFromGeoJSON
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String geoJson) throws ParseException {
            return Constructors.getGeometryByFileData(geoJson, FileDataSplitter.GEOJSON);
        }
    }

    public static class ST_LinestringFromWKB
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString) throws ParseException {
            Geometry geometry = Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
            if (geometry instanceof LineString) {
                return geometry;
            }
            return null;
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString, int srid) throws ParseException {
            Geometry geometry = Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
            if (geometry instanceof LineString) {
                geometry = Functions.setSRID(geometry, srid);
                return geometry;
            }
            return null;
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb) throws ParseException {
            return org.apache.sedona.common.Constructors.lineFromWKB(wkb);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb, int srid) throws ParseException {
            return org.apache.sedona.common.Constructors.lineFromWKB(wkb, srid);
        }
    }

    public static class ST_LineFromWKB
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString) throws ParseException {
            Geometry geometry = Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
            if (geometry instanceof LineString) {
                return geometry;
            }
            return null;
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString, int srid) throws ParseException {
            Geometry geometry = Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
            if (geometry instanceof LineString) {
                geometry = Functions.setSRID(geometry, srid);
                return geometry;
            }
            return null;
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb) throws ParseException {
            return org.apache.sedona.common.Constructors.lineFromWKB(wkb);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb, int srid) throws ParseException {
            return org.apache.sedona.common.Constructors.lineFromWKB(wkb, srid);
        }
    }

    public static class ST_PointFromWKB
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString) throws ParseException {
            Geometry geometry = Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
            if (geometry instanceof Point) {
                return geometry;
            }
            return null;
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString, int srid) throws ParseException {
            Geometry geometry = Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
            if (geometry instanceof Point) {
                geometry = Functions.setSRID(geometry, srid);
                return geometry;
            }
            return null;
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb) throws ParseException {
            return org.apache.sedona.common.Constructors.pointFromWKB(wkb);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb, int srid) throws ParseException {
            return org.apache.sedona.common.Constructors.pointFromWKB(wkb, srid);
        }
    }

    public static class ST_GeomFromEWKB
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString) throws ParseException {
            return Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKB(wkb);
        }
    }

    public static class ST_GeomFromWKB
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString) throws ParseException {
            return Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKB(wkb);
        }
    }

    public static class ST_GeomFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKT(wktString, 0);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKT(wktString, srid);
        }
    }

    public static class ST_GeometryFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKT(wktString, 0);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKT(wktString, srid);
        }
    }

    public static class ST_GeomFromEWKT
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromEWKT(wktString);
        }
    }

    public static class ST_GeomFromWKT
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKT(wktString, 0);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKT(wktString, srid);
        }
    }

    public static class ST_PolygonFromEnvelope
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double minX, @DataTypeHint(value="Double") Double minY, @DataTypeHint(value="Double") Double maxX, @DataTypeHint(value="Double") Double maxY) {
            Coordinate[] coordinates;
            coordinates = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), coordinates[0]};
            GeometryFactory geometryFactory = new GeometryFactory();
            return geometryFactory.createPolygon(coordinates);
        }
    }

    public static class ST_PolygonFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String polygonString, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            return Constructors.getGeometryByType(polygonString, inputDelimiter, GeometryType.POLYGON);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String polygonString) throws ParseException {
            return this.eval(polygonString, null);
        }
    }

    public static class ST_LineStringFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String lineString, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            return new ST_LineFromText().eval(lineString, inputDelimiter);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String lineString) throws ParseException {
            return this.eval(lineString, null);
        }
    }

    public static class ST_LineFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String lineString, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            return Constructors.getGeometryByType(lineString, inputDelimiter, GeometryType.LINESTRING);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String lineString) throws ParseException {
            return this.eval(lineString, null);
        }
    }

    public static class ST_MakePoint
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y) throws ParseException {
            return org.apache.sedona.common.Constructors.makePoint(x, y, null, null);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double z) throws ParseException {
            return org.apache.sedona.common.Constructors.makePoint(x, y, z, null);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double z, @DataTypeHint(value="Double") Double m3) throws ParseException {
            return org.apache.sedona.common.Constructors.makePoint(x, y, z, m3);
        }
    }

    public static class ST_MakePointM
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double m3) throws ParseException {
            return org.apache.sedona.common.Constructors.makePointM(x, y, m3);
        }
    }

    public static class ST_PointFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String s2, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            return Constructors.getGeometryByType(s2, inputDelimiter, GeometryType.POINT);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String s2) throws ParseException {
            return this.eval(s2, null);
        }
    }

    public static class ST_PointZM
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double z, @DataTypeHint(value="Double") Double m3) throws ParseException {
            return this.eval(x, y, z, m3, 0);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double z, @DataTypeHint(value="Double") Double m3, @DataTypeHint(value="Integer") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.pointZM(x, y, z, m3, srid);
        }
    }

    public static class ST_PointM
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double m3) throws ParseException {
            return this.eval(x, y, m3, 0);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double m3, @DataTypeHint(value="Integer") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.pointM(x, y, m3, srid);
        }
    }

    public static class ST_PointZ
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double z) throws ParseException {
            return this.eval(x, y, z, 0);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y, @DataTypeHint(value="Double") Double z, @DataTypeHint(value="Integer") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.pointZ(x, y, z, srid);
        }
    }

    public static class ST_Point
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y) throws ParseException {
            return org.apache.sedona.common.Constructors.point(x, y);
        }
    }
}

