/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster.serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import javax.media.jai.RenderedImageAdapter;
import org.apache.sedona.common.raster.DeepCopiedRenderedImage;
import org.apache.sedona.common.raster.serde.AffineTransform2DSerializer;
import org.apache.sedona.common.raster.serde.CRSSerializer;
import org.apache.sedona.common.raster.serde.GridEnvelopeSerializer;
import org.apache.sedona.common.raster.serde.GridSampleDimensionSerializer;
import org.apache.sedona.common.raster.serde.KryoUtil;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.operation.MathTransform;

public class Serde {
    private static final ThreadLocal<Kryo> kryos = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        kryo.register(AffineTransform2D.class, (Serializer)new AffineTransform2DSerializer());
        kryo.register(GridSampleDimension.class, (Serializer)new GridSampleDimensionSerializer());
        kryo.register(URI.class, (Serializer)new URISerializer());
        DeepCopiedRenderedImage.registerKryo(kryo);
        try {
            kryo.register(Class.forName("org.geotools.coverage.grid.RenderedSampleDimension"), (Serializer)new GridSampleDimensionSerializer());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot register kryo serializer for class RenderedSampleDimension", e);
        }
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        return kryo;
    });
    private static final int IN_DB = 0;

    private Serde() {
    }

    public static byte[] serialize(GridCoverage2D raster) throws IOException {
        Kryo kryo = kryos.get();
        DeepCopiedRenderedImage deepCopiedRenderedImage = null;
        RenderedImage renderedImage = raster.getRenderedImage();
        while (renderedImage instanceof RenderedImageAdapter) {
            renderedImage = ((RenderedImageAdapter)renderedImage).getWrappedImage();
        }
        deepCopiedRenderedImage = renderedImage instanceof DeepCopiedRenderedImage ? (DeepCopiedRenderedImage)renderedImage : new DeepCopiedRenderedImage(renderedImage);
        SerializableState state = new SerializableState();
        GridGeometry2D gridGeometry = raster.getGridGeometry();
        state.name = raster.getName();
        state.gridEnvelope2D = gridGeometry.getGridRange2D();
        state.gridToCRS = gridGeometry.getGridToCRS2D();
        state.serializedCRS = CRSSerializer.serialize(gridGeometry.getCoordinateReferenceSystem());
        state.bands = raster.getSampleDimensions();
        state.image = deepCopiedRenderedImage;
        try (UnsafeOutput out = new UnsafeOutput(4096, -1);){
            out.writeByte(0);
            state.write(kryo, (Output)out);
            byte[] byArray = out.toBytes();
            return byArray;
        }
    }

    public static GridCoverage2D deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        Kryo kryo = kryos.get();
        try (UnsafeInput in = new UnsafeInput(bytes);){
            byte rasterType = in.readByte();
            if (rasterType != 0) {
                throw new IllegalArgumentException("Unsupported raster type: " + rasterType);
            }
            SerializableState state = new SerializableState();
            state.read(kryo, (Input)in);
            GridCoverage2D gridCoverage2D = state.restore();
            return gridCoverage2D;
        }
    }

    private static class SerializableState
    implements Serializable,
    KryoSerializable {
        public CharSequence name;
        public GridEnvelope2D gridEnvelope2D;
        public MathTransform gridToCRS;
        public byte[] serializedCRS;
        public GridSampleDimension[] bands;
        public DeepCopiedRenderedImage image;
        private static final GridEnvelopeSerializer gridEnvelopeSerializer = new GridEnvelopeSerializer();
        private static final AffineTransform2DSerializer affineTransform2DSerializer = new AffineTransform2DSerializer();
        private static final GridSampleDimensionSerializer gridSampleDimensionSerializer = new GridSampleDimensionSerializer();

        private SerializableState() {
        }

        public GridCoverage2D restore() {
            GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)this.gridEnvelope2D, this.gridToCRS, CRSSerializer.deserialize(this.serializedCRS));
            return new GridCoverageFactory().create(this.name, (RenderedImage)this.image, gridGeometry, this.bands, null, null);
        }

        public void write(Kryo kryo, Output output) {
            KryoUtil.writeUTF8String(output, this.name.toString());
            gridEnvelopeSerializer.write(kryo, output, this.gridEnvelope2D);
            if (!(this.gridToCRS instanceof AffineTransform2D)) {
                throw new UnsupportedOperationException("Only AffineTransform2D is supported");
            }
            affineTransform2DSerializer.write(kryo, output, (AffineTransform2D)this.gridToCRS);
            output.writeInt(this.serializedCRS.length);
            output.writeBytes(this.serializedCRS);
            output.writeInt(this.bands.length);
            for (GridSampleDimension band : this.bands) {
                gridSampleDimensionSerializer.write(kryo, output, band);
            }
            this.image.write(kryo, output);
        }

        public void read(Kryo kryo, Input input) {
            this.name = KryoUtil.readUTF8String(input);
            this.gridEnvelope2D = gridEnvelopeSerializer.read(kryo, input, GridEnvelope2D.class);
            this.gridToCRS = affineTransform2DSerializer.read(kryo, input, AffineTransform2D.class);
            int serializedCRSLength = input.readInt();
            this.serializedCRS = input.readBytes(serializedCRSLength);
            int bandCount = input.readInt();
            this.bands = new GridSampleDimension[bandCount];
            for (int i = 0; i < bandCount; ++i) {
                this.bands[i] = gridSampleDimensionSerializer.read(kryo, input, GridSampleDimension.class);
            }
            this.image = new DeepCopiedRenderedImage();
            this.image.read(kryo, input);
        }
    }

    private static class URISerializer
    extends Serializer<URI> {
        public URISerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, URI uri) {
            KryoUtil.writeUTF8String(output, uri.toString());
        }

        public URI read(Kryo kryo, Input input, Class<URI> uriClass) {
            return URI.create(KryoUtil.readUTF8String(input));
        }
    }
}

