/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.geojson;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.sedona_sql.UDT.RasterUDT$;
import org.apache.spark.sql.sedona_sql.io.geojson.GeoJSONOutputWriter;
import org.apache.spark.sql.sedona_sql.io.geojson.GeoJSONUtils$;
import org.apache.spark.sql.sedona_sql.io.geojson.SparkCompatUtil$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\u0007\u000f\u0001uAQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0013\u0007\u0003\u0004@\u0001\u0001\u0006IA\r\u0005\u0006\u0001\u0002!\t%\u0011\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006m\u0002!\te\u001e\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\ty\u0002\u0001C!\u0003CAq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011q\u0011\u0001\u0005B\u0005%%!E$f_*\u001bvJ\u0014$jY\u00164uN]7bi*\u0011q\u0002E\u0001\bO\u0016|'n]8o\u0015\t\t\"#\u0001\u0002j_*\u00111\u0003F\u0001\u000bg\u0016$wN\\1`gFd'BA\u000b\u0017\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011c\u0001\u0001\u001fMA\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002$)\u0005IQ\r_3dkRLwN\\\u0005\u0003K\u0001\u00121\u0003V3yi\n\u000b7/\u001a3GS2,gi\u001c:nCR\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u000b\u0002\u000fM|WO]2fg&\u00111\u0006\u000b\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002\u001d\u0005I1\u000f[8si:\u000bW.Z\u000b\u0002eA\u00111\u0007\u0010\b\u0003ii\u0002\"!\u000e\u001d\u000e\u0003YR!a\u000e\u000f\u0002\rq\u0012xn\u001c;?\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mB\u0014AC:i_J$h*Y7fA\u0005Y\u0011n]*qY&$\u0018M\u00197f)\u0011\u0011e\tT)\u0011\u0005\r#U\"\u0001\u001d\n\u0005\u0015C$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u000f\u0012\u0001\r\u0001S\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\u0013*k\u0011\u0001F\u0005\u0003\u0017R\u0011Ab\u00159be.\u001cVm]:j_:DQ!\u0014\u0003A\u00029\u000bqa\u001c9uS>t7\u000f\u0005\u00034\u001fJ\u0012\u0014B\u0001)?\u0005\ri\u0015\r\u001d\u0005\u0006%\u0012\u0001\raU\u0001\u0005a\u0006$\b\u000e\u0005\u0002U36\tQK\u0003\u0002W/\u0006\u0011am\u001d\u0006\u00031b\ta\u0001[1e_>\u0004\u0018B\u0001.V\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u0005;\u001a<\u0007\u000eE\u0002D=\u0002L!a\u0018\u001d\u0003\r=\u0003H/[8o!\t\tG-D\u0001c\u0015\t\u0019G#A\u0003usB,7/\u0003\u0002fE\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\u001d+\u0001\u0019\u0001%\t\u000b5+\u0001\u0019\u0001(\t\u000b%,\u0001\u0019\u00016\u0002\u000b\u0019LG.Z:\u0011\u0007-\u00048O\u0004\u0002m]:\u0011Q'\\\u0005\u0002s%\u0011q\u000eO\u0001\ba\u0006\u001c7.Y4f\u0013\t\t(OA\u0002TKFT!a\u001c\u001d\u0011\u0005Q#\u0018BA;V\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\bqnd\u0018\u0011BA\u0006!\ty\u00120\u0003\u0002{A\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")qI\u0002a\u0001\u0011\")QP\u0002a\u0001}\u0006\u0019!n\u001c2\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A,\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA\u0004\u0003\u0003\u00111AS8c\u0011\u0015ie\u00011\u0001O\u0011\u0019\tiA\u0002a\u0001A\u0006QA-\u0019;b'\u000eDW-\\1\u00025Y\fG.\u001b3bi\u0016<Um\\7fiJL8i\u001c7v[:t\u0015-\\3\u0015\r\u0005M\u0011\u0011DA\u000e!\r\u0019\u0015QC\u0005\u0004\u0003/A$\u0001B+oSRDa!!\u0004\b\u0001\u0004\u0001\u0007BBA\u000f\u000f\u0001\u0007!'\u0001\nhK>lW\r\u001e:z\u0007>dW/\u001c8OC6,\u0017a\u00032vS2$'+Z1eKJ$\u0002#a\t\u0002B\u0005\r\u0013QIA%\u0003\u001b\nI&a\u0017\u0011\u000f\r\u000b)#!\u000b\u00020%\u0019\u0011q\u0005\u001d\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0010\u0002,%\u0019\u0011Q\u0006\u0011\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004Ra[A\u0019\u0003kI1!a\rs\u0005!IE/\u001a:bi>\u0014\b\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mB#\u0001\u0005dCR\fG._:u\u0013\u0011\ty$!\u000f\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006\u000f\"\u0001\r\u0001\u0013\u0005\u0007\u0003\u001bA\u0001\u0019\u00011\t\r\u0005\u001d\u0003\u00021\u0001a\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBA&\u0011\u0001\u0007\u0001-\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005=\u0003\u00021\u0001\u0002R\u00059a-\u001b7uKJ\u001c\b\u0003B6q\u0003'\u00022aJA+\u0013\r\t9\u0006\u000b\u0002\u0007\r&dG/\u001a:\t\u000b5C\u0001\u0019\u0001(\t\u000f\u0005u\u0003\u00021\u0001\u0002`\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001aX\u0003\u0011\u0019wN\u001c4\n\t\u0005%\u00141\r\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012AM\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111\u000f\t\u0004\u0007\u0006U\u0014bAA<q\t\u0019\u0011J\u001c;\u0002\r\u0015\fX/\u00197t)\r\u0011\u0015Q\u0010\u0005\b\u0003\u007fZ\u0001\u0019AAA\u0003\u0015yG\u000f[3s!\r\u0019\u00151Q\u0005\u0004\u0003\u000bC$aA!os\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\rF\u0002C\u0003\u0017Cq!!$\r\u0001\u0004\ty)\u0001\u0005eCR\fG+\u001f9f!\r\t\u0017\u0011S\u0005\u0004\u0003'\u0013'\u0001\u0003#bi\u0006$\u0016\u0010]3")
public class GeoJSONFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    private final String shortName;

    public String shortName() {
        return this.shortName;
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        JsonDataSource jsonDataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
        return jsonDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        Option fullSchemaOption = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions).inferSchema(sparkSession, files, (JSONOptions)parsedOptions);
        return fullSchemaOption.map((Function1 & Serializable)fullSchema -> {
            StructType newFields = GeoJSONUtils$.MODULE$.updateGeometrySchema((StructType)fullSchema, (DataType)GeometryUDT$.MODULE$);
            return StructType$.MODULE$.apply((Seq)newFields);
        });
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        String string;
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        parsedOptions.compressionCodec().foreach((Function1 & Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        Option option = options.get((Object)"geometry.column");
        if (option instanceof Some) {
            Some some = (Some)option;
            String columnName = (String)some.value();
            this.validateGeometryColumnName(dataSchema, columnName);
            string = columnName;
        } else if (None$.MODULE$.equals(option)) {
            Object object;
            StructField[] structFieldArray = (StructField[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fields()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoJSONFileFormat.$anonfun$prepareWrite$2(x$1)));
            if (structFieldArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)structFieldArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0) == 0) {
                throw new IllegalArgumentException("No geometry column found in the schema");
            }
            string = ((StructField)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])structFieldArray), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GeoJSONFileFormat.$anonfun$prepareWrite$3(x$2))).getOrElse((Function0 & Serializable)() -> (StructField)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])structFieldArray)))).name();
        } else {
            throw new MatchError((Object)option);
        }
        String geometryColumnName = string;
        return new OutputWriterFactory(null, parsedOptions, geometryColumnName){
            private final JSONOptions parsedOptions$1;
            private final String geometryColumnName$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new GeoJSONOutputWriter(path, this.parsedOptions$1, dataSchema, this.geometryColumnName$1, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(5).append(".json").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
                this.geometryColumnName$1 = geometryColumnName$1;
            }
        };
    }

    private void validateGeometryColumnName(StructType dataSchema, String geometryColumnName) {
        Some some;
        StructField structField;
        Option<StructField> option = SparkCompatUtil$.MODULE$.findNestedField(dataSchema, StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(geometryColumnName), '.'), (Function2<String, String, Object>)SQLConf$.MODULE$.get().resolver());
        if (option instanceof Some && (structField = (StructField)(some = (Some)option).value()) != null) {
            DataType dataType = structField.dataType();
            if (!dataType.acceptsType((DataType)GeometryUDT$.MODULE$)) {
                throw new IllegalArgumentException(new StringBuilder(25).append(geometryColumnName).append(" is not a geometry column").toString());
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Column ").append(geometryColumnName).append(" not found in the schema").toString());
        }
        throw new MatchError(option);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GeoJSONFileFormat.$anonfun$buildReader$1(parsedOptions, x$3))));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(dataSchema, parsedOptions.columnNameOfCorruptRecord());
        StructType alteredSchema = GeoJSONUtils$.MODULE$.updateGeometrySchema(actualSchema, (DataType)StringType$.MODULE$);
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new IllegalArgumentException("referenced columns only include the internal corrupt record column, this is not allowed");
            }
        }
        return (Function1 & Serializable)file -> {
            JacksonParser parser = SparkCompatUtil$.MODULE$.constructJacksonParser((DataType)alteredSchema, (JSONOptions)parsedOptions, true);
            JsonDataSource dataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
            return SparkCompatUtil$.MODULE$.readFile(dataSource, ((SerializableConfiguration)broadcastedHadoopConf.value()).value(), (PartitionedFile)file, parser, actualSchema).map((Function1 & Serializable)row -> {
                InternalRow newRow = GeoJSONUtils$.MODULE$.convertGeoJsonToGeometry((InternalRow)row, alteredSchema);
                return newRow;
            });
        };
    }

    public String toString() {
        return "GEOJSON";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof GeoJSONFileFormat;
    }

    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (((Object)((Object)GeometryUDT$.MODULE$)).equals(dataType2)) {
            return true;
        }
        if (((Object)((Object)RasterUDT$.MODULE$)).equals(dataType2)) {
            return false;
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return dataType2 instanceof NullType;
    }

    public static final /* synthetic */ boolean $anonfun$prepareWrite$2(StructField x$1) {
        DataType dataType = x$1.dataType();
        GeometryUDT$ geometryUDT$ = GeometryUDT$.MODULE$;
        return !(dataType != null ? !dataType.equals((Object)geometryUDT$) : geometryUDT$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$prepareWrite$3(StructField x$2) {
        return x$2.name().equalsIgnoreCase("geometry");
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$1(JSONOptionsInRead parsedOptions$2, StructField x$3) {
        String string = x$3.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public GeoJSONFileFormat() {
        this.shortName = "geojson";
    }
}

