/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.loadbalancer.Server;
import java.net.URI;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.web.util.UriComponentsBuilder;

public class RibbonUtils {
    public static final String VALUE_NOT_SET = "__not__set__";
    public static final String DEFAULT_NAMESPACE = "ribbon";

    public static void setRibbonProperty(String serviceId, String suffix, String value) {
        String key = RibbonUtils.getRibbonKey(serviceId, suffix);
        DynamicStringProperty property = RibbonUtils.getProperty(key);
        if (property.get().equals(VALUE_NOT_SET)) {
            ConfigurationManager.getConfigInstance().setProperty(key, (Object)value);
        }
    }

    public static String getRibbonKey(String serviceId, String suffix) {
        return serviceId + "." + DEFAULT_NAMESPACE + "." + suffix;
    }

    public static DynamicStringProperty getProperty(String key) {
        return DynamicPropertyFactory.getInstance().getStringProperty(key, VALUE_NOT_SET);
    }

    public static boolean isSecure(IClientConfig config, ServerIntrospector serverIntrospector, Server server) {
        Boolean isSecure;
        if (config != null && (isSecure = (Boolean)config.get(CommonClientConfigKey.IsSecure)) != null) {
            return isSecure;
        }
        return serverIntrospector.isSecure(server);
    }

    public static URI updateToHttpsIfNeeded(URI uri, IClientConfig config, ServerIntrospector serverIntrospector, Server server) {
        String scheme = uri.getScheme();
        if (!"".equals(uri.toString()) && !"https".equals(scheme) && RibbonUtils.isSecure(config, serverIntrospector, server)) {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)uri).scheme("https");
            if (uri.getRawQuery() != null) {
                uriComponentsBuilder.replaceQuery(uri.getRawQuery().replace("+", "%20"));
            }
            return uriComponentsBuilder.build(true).toUri();
        }
        return uri;
    }
}

