/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.http.HttpClientRequest;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.tracing.zipkin.InvocationAware;
import org.apache.servicecomb.tracing.zipkin.TracingConfiguration;

class HttpClientRequestWrapper
extends HttpClientRequest
implements InvocationAware {
    private final Invocation invocation;

    HttpClientRequestWrapper(Invocation invocation) {
        this.invocation = invocation;
    }

    public void header(String name, String value) {
        this.invocation.addContext(name, value);
    }

    public String method() {
        return this.invocation.getOperationMeta().getHttpMethod();
    }

    public String route() {
        return this.invocation.getEndpoint().getEndpoint();
    }

    public String path() {
        return TracingConfiguration.createRequestPath(this.invocation);
    }

    public String url() {
        return this.invocation.getInvocationQualifiedName();
    }

    public String header(String name) {
        return this.invocation.getContext(name);
    }

    public Object unwrap() {
        return this.invocation;
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }
}

