/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlTransient;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.MatrixParameters;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.CloneAccess;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

@XmlTransient
final class MatrixParameterValues<E>
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup,
ParameterValueGroup,
CloneAccess {
    private static final long serialVersionUID = -7747712999115044943L;
    private final MatrixParameters<E> descriptors;
    private final ParameterValue<Integer>[] dimensions;
    private Object[] values;

    MatrixParameterValues(Map<String, ?> properties, MatrixParameters<E> descriptors) {
        super(properties, 1, 1);
        this.descriptors = descriptors;
        this.dimensions = new ParameterValue[descriptors.order()];
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = descriptors.getDimensionDescriptor(i).createValue();
        }
    }

    MatrixParameterValues(MatrixParameterValues<E> other, boolean clone) {
        super(other);
        this.descriptors = other.descriptors;
        this.dimensions = (ParameterValue[])other.dimensions.clone();
        for (int i = 0; i < this.dimensions.length; ++i) {
            ParameterValue<Integer> dim = this.dimensions[i];
            this.dimensions[i] = clone ? dim.clone() : dim.getDescriptor().createValue();
        }
        if (clone) {
            this.values = MatrixParameterValues.clone(other.values);
        }
    }

    private static Object[] clone(Object[] values) {
        if (values != null) {
            values = (Object[])values.clone();
            for (int i = 0; i < values.length; ++i) {
                Object element = values[i];
                element = element instanceof GeneralParameterValue ? ((GeneralParameterValue)element).clone() : MatrixParameterValues.clone(element);
                values[i] = element;
            }
        }
        return values;
    }

    public ParameterValueGroup clone() {
        return new MatrixParameterValues<E>(this, true);
    }

    public ParameterValueGroup createValue() {
        return new MatrixParameterValues<E>(this, false);
    }

    public ParameterDescriptorGroup getDescriptor() {
        return this;
    }

    public List<GeneralParameterDescriptor> descriptors() {
        return Containers.viewAsUnmodifiableList((Object[])this.descriptors.getAllDescriptors(this.size()));
    }

    private int[] size() {
        int[] indices = new int[this.dimensions.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.dimensions[i].intValue();
        }
        return indices;
    }

    public GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        name = name.strip();
        ArgumentChecks.ensureNonEmpty((String)"name", (CharSequence)name);
        return this.descriptors.descriptor(this, name, this.size());
    }

    public ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        int[] actualSize;
        name = name.strip();
        ArgumentChecks.ensureNonEmpty((String)"name", (CharSequence)name);
        IllegalArgumentException cause = null;
        int[] indices = null;
        try {
            indices = this.descriptors.nameToIndices(name);
        }
        catch (IllegalArgumentException exception) {
            cause = exception;
        }
        if (indices != null && MatrixParameters.isInBounds(indices, actualSize = this.size())) {
            return this.parameter(indices, actualSize);
        }
        int order = this.descriptors.order();
        for (int i = 0; i < order; ++i) {
            ParameterDescriptor<Integer> param = this.descriptors.getDimensionDescriptor(i);
            if (!IdentifiedObjects.isHeuristicMatchForName(param, name)) continue;
            return this.dimensions[i];
        }
        throw (ParameterNotFoundException)new ParameterNotFoundException(Resources.format((short)61, this.getName(), name), name).initCause((Throwable)cause);
    }

    private ParameterValue<E> parameter(int[] indices, int[] actualSize) {
        int order = this.dimensions.length;
        if (indices.length != order) {
            throw new IllegalArgumentException(Errors.format((short)164, (Object)order, (Object)indices.length));
        }
        Object[] parent = null;
        Object element = this.values;
        for (int i = 0; i < order; ++i) {
            if (element == null) {
                Class componentType = Classes.changeArrayDimension(ParameterValue.class, (int)(order - i - 1));
                element = Array.newInstance(componentType, actualSize[i]);
                if (parent != null) {
                    parent[indices[i - 1]] = element;
                } else {
                    this.values = element;
                }
            } else if (((Object[])element).length <= indices[i]) {
                parent[indices[i - 1]] = element = Arrays.copyOf((Object[])element, actualSize[i]);
            }
            parent = element;
            element = parent[indices[i]];
        }
        if (element == null) {
            element = this.descriptors.getElementDescriptor(indices).createValue();
            parent[indices[order - 1]] = element;
        }
        return Parameters.cast((ParameterValue)element, this.descriptors.getElementType());
    }

    public List<GeneralParameterValue> values() {
        ArrayList<GeneralParameterValue> addTo = new ArrayList<GeneralParameterValue>();
        for (ParameterValue<Integer> dimension : this.dimensions) {
            if (MatrixParameterValues.isOmitted(dimension)) continue;
            addTo.add((GeneralParameterValue)dimension);
        }
        MatrixParameterValues.addValues(this.values, this.size(), 0, addTo);
        return Collections.unmodifiableList(addTo);
    }

    private static void addValues(Object[] values, int[] actualSize, int j, List<GeneralParameterValue> addTo) {
        block4: {
            if (values == null) break block4;
            int length = Math.min(values.length, actualSize[j]);
            if (++j != actualSize.length) {
                for (int i = 0; i < length; ++i) {
                    MatrixParameterValues.addValues((Object[])values[i], actualSize, j, addTo);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    ParameterValue parameter = (ParameterValue)values[i];
                    if (parameter == null || MatrixParameterValues.isOmitted(parameter)) continue;
                    addTo.add((GeneralParameterValue)parameter);
                }
            }
        }
    }

    private static boolean isOmitted(ParameterValue<?> parameter) {
        Object value = parameter.getValue();
        if (value == null) {
            return true;
        }
        ParameterDescriptor descriptor = parameter.getDescriptor();
        return descriptor.getMinimumOccurs() == 0 && value.equals(descriptor.getDefaultValue());
    }

    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        throw new ParameterNotFoundException(Resources.format((short)61, this.getName(), name), name);
    }

    public ParameterValueGroup addGroup(String name) throws ParameterNotFoundException, IllegalStateException {
        throw new ParameterNotFoundException(Resources.format((short)61, this.getName(), name), name);
    }

    final Matrix toMatrix() {
        int numRow = this.dimensions[0].intValue();
        int numCol = this.dimensions[1].intValue();
        MatrixSIS matrix = Matrices.createDiagonal(numRow, numCol);
        if (this.values != null) {
            for (int j = 0; j < numRow; ++j) {
                ParameterValue[] row = (ParameterValue[])this.values[j];
                if (row == null) continue;
                for (int i = 0; i < numCol; ++i) {
                    ParameterValue element = row[i];
                    if (element == null) continue;
                    matrix.setElement(j, i, element.doubleValue());
                }
            }
        }
        return matrix;
    }

    final void setMatrix(Matrix matrix) {
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        this.dimensions[0].setValue(numRow);
        this.dimensions[1].setValue(numCol);
        this.values = null;
        int[] indices = new int[2];
        for (int j = 0; j < numRow; ++j) {
            indices[0] = j;
            ParameterValue[] row = null;
            for (int i = 0; i < numCol; ++i) {
                indices[1] = i;
                ParameterDescriptor<E> descriptor = this.descriptors.getElementDescriptor(indices);
                Object def = descriptor.getDefaultValue();
                double element = matrix.getElement(j, i);
                if (def instanceof Number && Numerics.equalsIgnoreZeroSign((double)element, (double)((Number)def).doubleValue())) continue;
                ParameterValue value = descriptor.createValue();
                value.setValue(element);
                if (row == null) {
                    row = new ParameterValue[numCol];
                    if (this.values == null) {
                        this.values = new ParameterValue[numRow][];
                    }
                    this.values[j] = row;
                }
                row[i] = value;
            }
        }
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            MatrixParameterValues that = (MatrixParameterValues)object;
            return Utilities.deepEquals(this.descriptors, that.descriptors, (ComparisonMode)mode) && Utilities.deepEquals(this.values(), that.values(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.descriptors.hashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendParamMT(this, formatter);
        return "ParameterGroup";
    }
}

