/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import io.netty.util.internal.StringUtil;

public final class PercentEncoder {
    private static final char[] UTF_UNKNOWN = new char[]{'%', '3', 'F'};
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final byte[] SAFE_OCTETS = new byte[65536];

    public static void encodeComponent(StringBuilder buf, String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (SAFE_OCTETS[c] != 0) continue;
            if (i != 0) {
                buf.append(s, 0, i);
            }
            PercentEncoder.encodeUtf8Component(buf, s, i);
            return;
        }
        buf.append(s);
    }

    private static void encodeUtf8Component(StringBuilder buf, String s, int start) {
        int end = s.length();
        if (start == end) {
            return;
        }
        char[] tmp = new char[12];
        tmp[9] = 37;
        tmp[6] = 37;
        tmp[3] = 37;
        tmp[0] = 37;
        int i = start;
        while (true) {
            char c2;
            char c;
            if ((c = s.charAt(i++)) < '\u0080') {
                if (c == ' ') {
                    buf.append('+');
                } else {
                    tmp[2] = UPPER_HEX_DIGITS[c & 0xF];
                    tmp[1] = UPPER_HEX_DIGITS[c >>> 4];
                    buf.append(tmp, 0, 3);
                }
            } else if (c < '\u0800') {
                tmp[5] = UPPER_HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                tmp[4] = UPPER_HEX_DIGITS[8 | c & 3];
                c = (char)(c >>> 2);
                tmp[2] = UPPER_HEX_DIGITS[c & 0xF];
                tmp[1] = UPPER_HEX_DIGITS[0xC | c >>> 4];
                buf.append(tmp, 0, 6);
            } else if (!StringUtil.isSurrogate(c)) {
                tmp[8] = UPPER_HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                tmp[7] = UPPER_HEX_DIGITS[8 | c & 3];
                c = (char)(c >>> 2);
                tmp[5] = UPPER_HEX_DIGITS[c & 0xF];
                c = (char)(c >>> 4);
                tmp[4] = UPPER_HEX_DIGITS[8 | c & 3];
                tmp[2] = UPPER_HEX_DIGITS[c >>> 2 & 0xF];
                tmp[1] = 69;
                buf.append(tmp, 0, 9);
            } else if (!Character.isHighSurrogate(c) || i == end) {
                buf.append(UTF_UNKNOWN);
            } else if (!Character.isLowSurrogate(c2 = s.charAt(i++))) {
                buf.append(UTF_UNKNOWN);
                if (Character.isHighSurrogate(c2)) {
                    buf.append(UTF_UNKNOWN);
                } else {
                    tmp[2] = UPPER_HEX_DIGITS[c2 & 0xF];
                    tmp[1] = UPPER_HEX_DIGITS[c2 >>> 4];
                    buf.append(tmp, 0, 3);
                }
            } else {
                int codePoint = Character.toCodePoint(c, c2);
                tmp[11] = UPPER_HEX_DIGITS[codePoint & 0xF];
                tmp[10] = UPPER_HEX_DIGITS[8 | (codePoint >>>= 4) & 3];
                tmp[8] = UPPER_HEX_DIGITS[(codePoint >>>= 2) & 0xF];
                tmp[7] = UPPER_HEX_DIGITS[8 | (codePoint >>>= 4) & 3];
                tmp[5] = UPPER_HEX_DIGITS[(codePoint >>>= 2) & 0xF];
                tmp[4] = UPPER_HEX_DIGITS[8 | (codePoint >>>= 4) & 3];
                tmp[2] = UPPER_HEX_DIGITS[codePoint >>> 2 & 0xF];
                tmp[1] = 70;
                buf.append(tmp, 0, 12);
            }
            int nextUnsafeOctetIndex = PercentEncoder.indexOfUnsafeOctet(s, i);
            if (nextUnsafeOctetIndex < 0) {
                if (i == end) break;
                buf.append(s, i, end);
                break;
            }
            if (nextUnsafeOctetIndex == i) continue;
            buf.append(s, i, nextUnsafeOctetIndex);
            i = nextUnsafeOctetIndex;
        }
    }

    private static int indexOfUnsafeOctet(String s, int start) {
        int len = s.length();
        for (int i = start; i < len; ++i) {
            char c = s.charAt(i);
            if (SAFE_OCTETS[c] != 0) continue;
            return i;
        }
        return -1;
    }

    private PercentEncoder() {
    }

    static {
        String safeOctetStr = "-_.~*abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        for (int i = 0; i < "-_.~*abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length(); ++i) {
            PercentEncoder.SAFE_OCTETS["-_.~*abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt((int)i)] = -1;
        }
    }
}

