/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.zookeeper;

import com.google.common.base.Strings;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.zookeeper.ZookeeperConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.zookeeper.ZookeeperServerSettings;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;

public class ZookeeperConfigurationProvider
extends AbstractConfigurationProvider {
    private ZookeeperServerSettings settings;

    public String name() {
        return "zookeeper";
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<ZookeeperServerSettings>(){

            public Class type() {
                return ZookeeperServerSettings.class;
            }

            public void onInitialized(ZookeeperServerSettings initialized) {
                ZookeeperConfigurationProvider.this.settings = initialized;
            }
        };
    }

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        if (Strings.isNullOrEmpty((String)this.settings.getHostPort())) {
            throw new ModuleStartException("Zookeeper hostPort cannot be null or empty.");
        }
        if (Strings.isNullOrEmpty((String)this.settings.getNamespace())) {
            throw new ModuleStartException("Zookeeper namespace cannot be null or empty.");
        }
        try {
            return new ZookeeperConfigWatcherRegister(this.settings);
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }
}

